/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.trafficmanager.implementation;

import com.dataiku.dss.shadelibazure.com.azure.core.management.Region;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.arm.models.implementation.ExternalChildResourceImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.utils.ResourceManagerUtils;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.trafficmanager.fluent.EndpointsClient;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.trafficmanager.fluent.models.EndpointInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.trafficmanager.implementation.TrafficManagerProfileImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.trafficmanager.models.EndpointMonitorStatus;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.trafficmanager.models.EndpointPropertiesCustomHeadersItem;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.trafficmanager.models.EndpointPropertiesSubnetsItem;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.trafficmanager.models.EndpointStatus;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.trafficmanager.models.EndpointType;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.trafficmanager.models.EndpointTypes;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.trafficmanager.models.GeographicLocation;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.trafficmanager.models.TrafficManagerEndpoint;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.trafficmanager.models.TrafficManagerProfile;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Mono;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

class TrafficManagerEndpointImpl
extends ExternalChildResourceImpl<TrafficManagerEndpoint, EndpointInner, TrafficManagerProfileImpl, TrafficManagerProfile>
implements TrafficManagerEndpoint,
TrafficManagerEndpoint.Definition<TrafficManagerProfile.DefinitionStages.WithCreate>,
TrafficManagerEndpoint.UpdateDefinition<TrafficManagerProfile.Update>,
TrafficManagerEndpoint.UpdateAzureEndpoint,
TrafficManagerEndpoint.UpdateExternalEndpoint,
TrafficManagerEndpoint.UpdateNestedProfileEndpoint {
    private final EndpointsClient client;
    private EndpointType endpointType;

    TrafficManagerEndpointImpl(String name, TrafficManagerProfileImpl parent, EndpointInner inner, EndpointsClient client) {
        super(name, parent, inner);
        this.client = client;
    }

    @Override
    public String id() {
        return ((EndpointInner)this.innerModel()).id();
    }

    @Override
    public EndpointType endpointType() {
        if (((EndpointInner)this.innerModel()).type() != null) {
            return EndpointType.fromValue(((EndpointInner)this.innerModel()).type());
        }
        return this.endpointType;
    }

    @Override
    public EndpointMonitorStatus monitorStatus() {
        return ((EndpointInner)this.innerModel()).endpointMonitorStatus();
    }

    @Override
    public boolean isEnabled() {
        return ((EndpointInner)this.innerModel()).endpointStatus().equals(EndpointStatus.ENABLED);
    }

    @Override
    public long routingWeight() {
        return ResourceManagerUtils.toPrimitiveLong(((EndpointInner)this.innerModel()).weight());
    }

    @Override
    public long routingPriority() {
        return ResourceManagerUtils.toPrimitiveLong(((EndpointInner)this.innerModel()).priority());
    }

    @Override
    public Set<String> geographicLocationCodes() {
        if (((EndpointInner)this.innerModel()).geoMapping() == null) {
            return Collections.unmodifiableSet(new HashSet());
        }
        return Collections.unmodifiableSet(new HashSet<String>(((EndpointInner)this.innerModel()).geoMapping()));
    }

    @Override
    public Collection<EndpointPropertiesSubnetsItem> subnets() {
        if (((EndpointInner)this.innerModel()).subnets() == null) {
            return Collections.unmodifiableList(new ArrayList());
        }
        return Collections.unmodifiableList(((EndpointInner)this.innerModel()).subnets());
    }

    @Override
    public Map<String, String> customHeaders() {
        if (((EndpointInner)this.innerModel()).customHeaders() == null) {
            return Collections.unmodifiableMap(new TreeMap());
        }
        TreeMap<String, String> headers = new TreeMap<String, String>();
        for (EndpointPropertiesCustomHeadersItem header : ((EndpointInner)this.innerModel()).customHeaders()) {
            headers.put(header.name(), header.value());
        }
        return Collections.unmodifiableMap(headers);
    }

    @Override
    public TrafficManagerEndpointImpl toResourceId(String resourceId) {
        ((EndpointInner)this.innerModel()).withTargetResourceId(resourceId);
        return this;
    }

    @Override
    public TrafficManagerEndpointImpl toFqdn(String externalFqdn) {
        ((EndpointInner)this.innerModel()).withTarget(externalFqdn);
        return this;
    }

    @Override
    public TrafficManagerEndpointImpl toProfile(TrafficManagerProfile nestedProfile) {
        ((EndpointInner)this.innerModel()).withTargetResourceId(nestedProfile.id());
        ((EndpointInner)this.innerModel()).withMinChildEndpoints(1L);
        return this;
    }

    @Override
    public TrafficManagerEndpointImpl fromRegion(Region location) {
        ((EndpointInner)this.innerModel()).withEndpointLocation(location.toString());
        return this;
    }

    @Override
    public TrafficManagerEndpointImpl withMinimumEndpointsToEnableTraffic(int count) {
        ((EndpointInner)this.innerModel()).withMinChildEndpoints(Long.valueOf(count));
        return this;
    }

    @Override
    public TrafficManagerEndpointImpl withRoutingPriority(int priority) {
        ((EndpointInner)this.innerModel()).withPriority(Long.valueOf(priority));
        return this;
    }

    @Override
    public TrafficManagerEndpointImpl withTrafficDisabled() {
        ((EndpointInner)this.innerModel()).withEndpointStatus(EndpointStatus.DISABLED);
        return this;
    }

    @Override
    public TrafficManagerEndpointImpl withTrafficEnabled() {
        ((EndpointInner)this.innerModel()).withEndpointStatus(EndpointStatus.ENABLED);
        return this;
    }

    @Override
    public TrafficManagerEndpointImpl withRoutingWeight(int weight) {
        ((EndpointInner)this.innerModel()).withWeight(Long.valueOf(weight));
        return this;
    }

    @Override
    public TrafficManagerEndpointImpl withGeographicLocation(GeographicLocation geographicLocation) {
        return this.withGeographicLocation(geographicLocation.code());
    }

    @Override
    public TrafficManagerEndpointImpl withoutGeographicLocation(GeographicLocation geographicLocation) {
        return this.withoutGeographicLocation(geographicLocation.code());
    }

    @Override
    public TrafficManagerEndpointImpl withGeographicLocations(List<GeographicLocation> geographicLocations) {
        for (GeographicLocation location : geographicLocations) {
            this.withGeographicLocation(location);
        }
        return this;
    }

    @Override
    public TrafficManagerEndpointImpl withGeographicLocation(String geographicLocationCode) {
        if (((EndpointInner)this.innerModel()).geoMapping() == null) {
            ((EndpointInner)this.innerModel()).withGeoMapping(new ArrayList<String>());
        }
        boolean found = false;
        for (String locationCode : ((EndpointInner)this.innerModel()).geoMapping()) {
            if (!locationCode.equalsIgnoreCase(geographicLocationCode)) continue;
            found = true;
            break;
        }
        if (!found) {
            ((EndpointInner)this.innerModel()).geoMapping().add(geographicLocationCode);
        }
        return this;
    }

    @Override
    public TrafficManagerEndpointImpl withGeographicLocations(Collection<String> geographicLocationCodes) {
        for (String locationCode : geographicLocationCodes) {
            this.withGeographicLocation(locationCode);
        }
        return this;
    }

    @Override
    public TrafficManagerEndpointImpl withoutGeographicLocation(String geographicLocationCode) {
        if (((EndpointInner)this.innerModel()).geoMapping() == null) {
            return this;
        }
        int itemIndex = -1;
        int i = 0;
        for (String locationCode : ((EndpointInner)this.innerModel()).geoMapping()) {
            if (locationCode.equalsIgnoreCase(geographicLocationCode)) {
                itemIndex = i;
                break;
            }
            ++i;
        }
        if (itemIndex != -1) {
            ((EndpointInner)this.innerModel()).geoMapping().remove(itemIndex);
        }
        return this;
    }

    @Override
    public TrafficManagerEndpointImpl withSubnet(String subnetStartIp, int mask) {
        if (((EndpointInner)this.innerModel()).subnets() == null) {
            ((EndpointInner)this.innerModel()).withSubnets(new ArrayList<EndpointPropertiesSubnetsItem>());
        }
        boolean found = false;
        for (EndpointPropertiesSubnetsItem subnetItem : ((EndpointInner)this.innerModel()).subnets()) {
            if (subnetItem.first() == null || subnetItem.scope() == null || !subnetItem.first().equalsIgnoreCase(subnetStartIp) || subnetItem.scope() != mask) continue;
            found = true;
            break;
        }
        if (!found) {
            ((EndpointInner)this.innerModel()).subnets().add(new EndpointPropertiesSubnetsItem().withFirst(subnetStartIp).withScope(mask));
        }
        return this;
    }

    @Override
    public TrafficManagerEndpointImpl withSubnet(String subnetStartIp, String subnetEndIp) {
        if (((EndpointInner)this.innerModel()).subnets() == null) {
            ((EndpointInner)this.innerModel()).withSubnets(new ArrayList<EndpointPropertiesSubnetsItem>());
        }
        boolean found = false;
        for (EndpointPropertiesSubnetsItem subnetItem : ((EndpointInner)this.innerModel()).subnets()) {
            if (subnetItem.first() == null || subnetItem.last() == null || !subnetItem.first().equalsIgnoreCase(subnetStartIp) || !subnetItem.last().equalsIgnoreCase(subnetEndIp)) continue;
            found = true;
            break;
        }
        if (!found) {
            ((EndpointInner)this.innerModel()).subnets().add(new EndpointPropertiesSubnetsItem().withFirst(subnetStartIp).withLast(subnetEndIp));
        }
        return this;
    }

    @Override
    public TrafficManagerEndpointImpl withSubnets(List<EndpointPropertiesSubnetsItem> subnets) {
        ((EndpointInner)this.innerModel()).withSubnets(new ArrayList<EndpointPropertiesSubnetsItem>());
        for (EndpointPropertiesSubnetsItem subnet : subnets) {
            ((EndpointInner)this.innerModel()).subnets().add(new EndpointPropertiesSubnetsItem().withFirst(subnet.first()).withLast(subnet.last()).withScope(subnet.scope()));
        }
        return this;
    }

    @Override
    public TrafficManagerEndpointImpl withoutSubnet(String subnetStartIp, int mask) {
        if (((EndpointInner)this.innerModel()).subnets() == null) {
            return this;
        }
        int foundIndex = -1;
        int i = 0;
        for (EndpointPropertiesSubnetsItem subnetItem : ((EndpointInner)this.innerModel()).subnets()) {
            if (subnetItem.first() != null && subnetItem.scope() != null && subnetItem.first().equalsIgnoreCase(subnetStartIp) && subnetItem.scope() == mask) {
                foundIndex = i;
                break;
            }
            ++i;
        }
        if (foundIndex != -1) {
            ((EndpointInner)this.innerModel()).subnets().remove(foundIndex);
        }
        return this;
    }

    @Override
    public TrafficManagerEndpointImpl withoutSubnet(String subnetStartIp, String subnetEndIp) {
        if (((EndpointInner)this.innerModel()).subnets() == null) {
            return this;
        }
        int foundIndex = -1;
        int i = 0;
        for (EndpointPropertiesSubnetsItem subnetItem : ((EndpointInner)this.innerModel()).subnets()) {
            if (subnetItem.first() != null && subnetItem.last() != null && subnetItem.first().equalsIgnoreCase(subnetStartIp) && subnetItem.last().equalsIgnoreCase(subnetEndIp)) {
                foundIndex = i;
                break;
            }
            ++i;
        }
        if (foundIndex != -1) {
            ((EndpointInner)this.innerModel()).subnets().remove(foundIndex);
        }
        return this;
    }

    @Override
    public TrafficManagerEndpointImpl withCustomHeader(String name, String value) {
        if (((EndpointInner)this.innerModel()).customHeaders() == null) {
            ((EndpointInner)this.innerModel()).withCustomHeaders(new ArrayList<EndpointPropertiesCustomHeadersItem>());
        }
        boolean found = false;
        for (EndpointPropertiesCustomHeadersItem headersItem : ((EndpointInner)this.innerModel()).customHeaders()) {
            if (headersItem.name() == null || !headersItem.name().equalsIgnoreCase(name) || headersItem.value() == null || !headersItem.value().equalsIgnoreCase(value)) continue;
            found = true;
            break;
        }
        if (!found) {
            ((EndpointInner)this.innerModel()).customHeaders().add(new EndpointPropertiesCustomHeadersItem().withName(name).withValue(value));
        }
        return this;
    }

    @Override
    public TrafficManagerEndpointImpl withCustomHeaders(Map<String, String> headers) {
        ((EndpointInner)this.innerModel()).withCustomHeaders(new ArrayList<EndpointPropertiesCustomHeadersItem>());
        for (Map.Entry<String, String> entry : headers.entrySet()) {
            ((EndpointInner)this.innerModel()).customHeaders().add(new EndpointPropertiesCustomHeadersItem().withName(entry.getKey()).withValue(entry.getValue()));
        }
        return this;
    }

    @Override
    public TrafficManagerEndpointImpl withoutCustomHeader(String name) {
        if (((EndpointInner)this.innerModel()).customHeaders() == null) {
            return this;
        }
        int foundIndex = -1;
        int i = 0;
        for (EndpointPropertiesCustomHeadersItem headersItem : ((EndpointInner)this.innerModel()).customHeaders()) {
            if (headersItem.name() != null && headersItem.name().equalsIgnoreCase(name)) {
                foundIndex = i;
                break;
            }
            ++i;
        }
        if (foundIndex != -1) {
            ((EndpointInner)this.innerModel()).customHeaders().remove(foundIndex);
        }
        return this;
    }

    @Override
    public Mono<TrafficManagerEndpoint> createResourceAsync() {
        return this.client.createOrUpdateAsync(((TrafficManagerProfileImpl)this.parent()).resourceGroupName(), ((TrafficManagerProfileImpl)this.parent()).name(), EndpointTypes.fromString(this.endpointType().localName()), this.name(), (EndpointInner)this.innerModel()).map(inner -> {
            this.setInner(inner);
            return this;
        });
    }

    @Override
    public Mono<TrafficManagerEndpoint> updateResourceAsync() {
        return this.createResourceAsync();
    }

    @Override
    public Mono<Void> deleteResourceAsync() {
        return this.client.deleteAsync(((TrafficManagerProfileImpl)this.parent()).resourceGroupName(), ((TrafficManagerProfileImpl)this.parent()).name(), EndpointTypes.fromString(this.endpointType().localName()), this.name()).then();
    }

    @Override
    public TrafficManagerProfileImpl attach() {
        return ((TrafficManagerProfileImpl)this.parent()).withEndpoint(this);
    }

    @Override
    protected Mono<EndpointInner> getInnerAsync() {
        return this.client.getAsync(((TrafficManagerProfileImpl)this.parent()).resourceGroupName(), ((TrafficManagerProfileImpl)this.parent()).name(), EndpointTypes.fromString(this.endpointType().toString()), this.name());
    }

    void withEndpointType(EndpointType endpointType) {
        this.endpointType = endpointType;
    }
}

