/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.trafficmanager.models;

import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.trafficmanager.models.QueryExperience;
import java.io.IOException;
import java.util.List;

public final class TrafficFlow
implements JsonSerializable<TrafficFlow> {
    private String sourceIp;
    private Double latitude;
    private Double longitude;
    private List<QueryExperience> queryExperiences;

    public String sourceIp() {
        return this.sourceIp;
    }

    public TrafficFlow withSourceIp(String sourceIp) {
        this.sourceIp = sourceIp;
        return this;
    }

    public Double latitude() {
        return this.latitude;
    }

    public TrafficFlow withLatitude(Double latitude) {
        this.latitude = latitude;
        return this;
    }

    public Double longitude() {
        return this.longitude;
    }

    public TrafficFlow withLongitude(Double longitude) {
        this.longitude = longitude;
        return this;
    }

    public List<QueryExperience> queryExperiences() {
        return this.queryExperiences;
    }

    public TrafficFlow withQueryExperiences(List<QueryExperience> queryExperiences) {
        this.queryExperiences = queryExperiences;
        return this;
    }

    public void validate() {
        if (this.queryExperiences() != null) {
            this.queryExperiences().forEach(e -> e.validate());
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("sourceIp", this.sourceIp);
        jsonWriter.writeNumberField("latitude", this.latitude);
        jsonWriter.writeNumberField("longitude", this.longitude);
        jsonWriter.writeArrayField("queryExperiences", this.queryExperiences, (writer, element) -> writer.writeJson((JsonSerializable<?>)element));
        return jsonWriter.writeEndObject();
    }

    public static TrafficFlow fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            TrafficFlow deserializedTrafficFlow = new TrafficFlow();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("sourceIp".equals(fieldName)) {
                    deserializedTrafficFlow.sourceIp = reader.getString();
                    continue;
                }
                if ("latitude".equals(fieldName)) {
                    deserializedTrafficFlow.latitude = reader.getNullable(JsonReader::getDouble);
                    continue;
                }
                if ("longitude".equals(fieldName)) {
                    deserializedTrafficFlow.longitude = reader.getNullable(JsonReader::getDouble);
                    continue;
                }
                if ("queryExperiences".equals(fieldName)) {
                    List<QueryExperience> queryExperiences = reader.readArray(reader1 -> QueryExperience.fromJson(reader1));
                    deserializedTrafficFlow.queryExperiences = queryExperiences;
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedTrafficFlow;
        });
    }
}

