/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.security.keyvault.keys.cryptography;

import com.dataiku.dss.shadelibazure.com.azure.core.annotation.ServiceClientBuilder;
import com.dataiku.dss.shadelibazure.com.azure.core.client.traits.ConfigurationTrait;
import com.dataiku.dss.shadelibazure.com.azure.core.client.traits.HttpTrait;
import com.dataiku.dss.shadelibazure.com.azure.core.client.traits.TokenCredentialTrait;
import com.dataiku.dss.shadelibazure.com.azure.core.credential.TokenCredential;
import com.dataiku.dss.shadelibazure.com.azure.core.http.HttpClient;
import com.dataiku.dss.shadelibazure.com.azure.core.http.HttpHeader;
import com.dataiku.dss.shadelibazure.com.azure.core.http.HttpHeaders;
import com.dataiku.dss.shadelibazure.com.azure.core.http.HttpPipeline;
import com.dataiku.dss.shadelibazure.com.azure.core.http.HttpPipelineBuilder;
import com.dataiku.dss.shadelibazure.com.azure.core.http.HttpPipelinePosition;
import com.dataiku.dss.shadelibazure.com.azure.core.http.policy.AddHeadersPolicy;
import com.dataiku.dss.shadelibazure.com.azure.core.http.policy.HttpLogOptions;
import com.dataiku.dss.shadelibazure.com.azure.core.http.policy.HttpLoggingPolicy;
import com.dataiku.dss.shadelibazure.com.azure.core.http.policy.HttpPipelinePolicy;
import com.dataiku.dss.shadelibazure.com.azure.core.http.policy.HttpPolicyProviders;
import com.dataiku.dss.shadelibazure.com.azure.core.http.policy.RetryOptions;
import com.dataiku.dss.shadelibazure.com.azure.core.http.policy.RetryPolicy;
import com.dataiku.dss.shadelibazure.com.azure.core.http.policy.UserAgentPolicy;
import com.dataiku.dss.shadelibazure.com.azure.core.util.ClientOptions;
import com.dataiku.dss.shadelibazure.com.azure.core.util.Configuration;
import com.dataiku.dss.shadelibazure.com.azure.core.util.CoreUtils;
import com.dataiku.dss.shadelibazure.com.azure.core.util.TracingOptions;
import com.dataiku.dss.shadelibazure.com.azure.core.util.builder.ClientBuilderUtil;
import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.core.util.tracing.Tracer;
import com.dataiku.dss.shadelibazure.com.azure.core.util.tracing.TracerProvider;
import com.dataiku.dss.shadelibazure.com.azure.security.keyvault.keys.cryptography.CryptographyAsyncClient;
import com.dataiku.dss.shadelibazure.com.azure.security.keyvault.keys.cryptography.CryptographyClient;
import com.dataiku.dss.shadelibazure.com.azure.security.keyvault.keys.cryptography.CryptographyServiceVersion;
import com.dataiku.dss.shadelibazure.com.azure.security.keyvault.keys.implementation.KeyVaultCredentialPolicy;
import com.dataiku.dss.shadelibazure.com.azure.security.keyvault.keys.models.JsonWebKey;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

@ServiceClientBuilder(serviceClients={CryptographyClient.class})
public final class CryptographyClientBuilder
implements TokenCredentialTrait<CryptographyClientBuilder>,
HttpTrait<CryptographyClientBuilder>,
ConfigurationTrait<CryptographyClientBuilder> {
    private static final ClientLogger LOGGER = new ClientLogger(CryptographyClientBuilder.class);
    private static final String CLIENT_NAME;
    private static final String CLIENT_VERSION;
    private static final String KEYVAULT_TRACING_NAMESPACE_VALUE = "Microsoft.KeyVault";
    private final List<HttpPipelinePolicy> perCallPolicies;
    private final List<HttpPipelinePolicy> perRetryPolicies;
    private ClientOptions clientOptions;
    private Configuration configuration;
    private CryptographyServiceVersion version;
    private HttpClient httpClient;
    private HttpLogOptions httpLogOptions = new HttpLogOptions();
    private HttpPipeline pipeline;
    private JsonWebKey jsonWebKey;
    private RetryPolicy retryPolicy;
    private RetryOptions retryOptions;
    private String keyId;
    private TokenCredential credential;
    private boolean isChallengeResourceVerificationDisabled = false;
    private boolean isKeyCachingDisabled = false;

    public CryptographyClientBuilder() {
        this.perCallPolicies = new ArrayList<HttpPipelinePolicy>();
        this.perRetryPolicies = new ArrayList<HttpPipelinePolicy>();
    }

    public CryptographyClient buildClient() {
        if (this.jsonWebKey == null) {
            CryptographyServiceVersion serviceVersion;
            if (CoreUtils.isNullOrEmpty(this.keyId)) {
                throw LOGGER.logExceptionAsError(new IllegalStateException("An Azure Key Vault key identifier is required to build the cryptography client if a JSON Web Key is not provided."));
            }
            CryptographyServiceVersion cryptographyServiceVersion = serviceVersion = this.version != null ? this.version : CryptographyServiceVersion.getLatest();
            if (this.pipeline != null) {
                return new CryptographyClient(this.keyId, this.pipeline, serviceVersion, this.isKeyCachingDisabled);
            }
            if (this.credential == null) {
                throw LOGGER.logExceptionAsError(new IllegalStateException("Azure Key Vault credentials are required to build the cryptography client if a JSON Web Key is not provided."));
            }
            HttpPipeline pipeline = this.setupPipeline();
            return new CryptographyClient(this.keyId, pipeline, serviceVersion, this.isKeyCachingDisabled);
        }
        if (this.isKeyCachingDisabled) {
            throw LOGGER.logExceptionAsError(new IllegalStateException("Key caching cannot be disabled when using a JSON Web Key."));
        }
        return new CryptographyClient(this.jsonWebKey);
    }

    public CryptographyAsyncClient buildAsyncClient() {
        if (this.jsonWebKey == null) {
            CryptographyServiceVersion serviceVersion;
            if (CoreUtils.isNullOrEmpty(this.keyId)) {
                throw LOGGER.logExceptionAsError(new IllegalStateException("An Azure Key Vault key identifier is required to build the cryptography client if a JSON Web Key is not provided."));
            }
            CryptographyServiceVersion cryptographyServiceVersion = serviceVersion = this.version != null ? this.version : CryptographyServiceVersion.getLatest();
            if (this.pipeline != null) {
                return new CryptographyAsyncClient(this.keyId, this.pipeline, serviceVersion, this.isKeyCachingDisabled);
            }
            if (this.credential == null) {
                throw LOGGER.logExceptionAsError(new IllegalStateException("Azure Key Vault credentials are required to build the cryptography client if a JSON Web Key is not provided."));
            }
            HttpPipeline pipeline = this.setupPipeline();
            return new CryptographyAsyncClient(this.keyId, pipeline, serviceVersion, this.isKeyCachingDisabled);
        }
        if (this.isKeyCachingDisabled) {
            throw LOGGER.logExceptionAsError(new IllegalStateException("Key caching cannot be disabled when using a JSON Web Key."));
        }
        return new CryptographyAsyncClient(this.jsonWebKey);
    }

    HttpPipeline setupPipeline() {
        Configuration buildConfiguration = this.configuration == null ? Configuration.getGlobalConfiguration().clone() : this.configuration;
        ArrayList<HttpPipelinePolicy> policies = new ArrayList<HttpPipelinePolicy>();
        this.httpLogOptions = this.httpLogOptions == null ? new HttpLogOptions() : this.httpLogOptions;
        ClientOptions localClientOptions = this.clientOptions != null ? this.clientOptions : new ClientOptions();
        policies.add(new UserAgentPolicy(CoreUtils.getApplicationId(localClientOptions, this.httpLogOptions), CLIENT_NAME, CLIENT_VERSION, buildConfiguration));
        ArrayList<HttpHeader> httpHeaderList = new ArrayList<HttpHeader>();
        localClientOptions.getHeaders().forEach(header -> httpHeaderList.add(new HttpHeader(header.getName(), header.getValue())));
        policies.add(new AddHeadersPolicy(new HttpHeaders(httpHeaderList)));
        policies.addAll(this.perCallPolicies);
        HttpPolicyProviders.addBeforeRetryPolicies(policies);
        policies.add(ClientBuilderUtil.validateAndGetRetryPolicy(this.retryPolicy, this.retryOptions));
        policies.add(new KeyVaultCredentialPolicy(this.credential, this.isChallengeResourceVerificationDisabled));
        policies.addAll(this.perRetryPolicies);
        HttpPolicyProviders.addAfterRetryPolicies(policies);
        policies.add(new HttpLoggingPolicy(this.httpLogOptions));
        TracingOptions tracingOptions = localClientOptions.getTracingOptions();
        Tracer tracer = TracerProvider.getDefaultProvider().createTracer(CLIENT_NAME, CLIENT_VERSION, KEYVAULT_TRACING_NAMESPACE_VALUE, tracingOptions);
        return new HttpPipelineBuilder().policies(policies.toArray(new HttpPipelinePolicy[0])).httpClient(this.httpClient).tracer(tracer).clientOptions(localClientOptions).build();
    }

    TokenCredential getCredential() {
        return this.credential;
    }

    HttpPipeline getPipeline() {
        return this.pipeline;
    }

    CryptographyServiceVersion getServiceVersion() {
        return this.version;
    }

    public CryptographyClientBuilder keyIdentifier(String keyId) {
        if (keyId == null) {
            throw LOGGER.logExceptionAsError(new NullPointerException("'keyId' cannot be null."));
        }
        this.keyId = keyId;
        return this;
    }

    @Override
    public CryptographyClientBuilder credential(TokenCredential credential) {
        if (credential == null) {
            throw LOGGER.logExceptionAsError(new NullPointerException("'credential' cannot be null."));
        }
        this.credential = credential;
        return this;
    }

    public CryptographyClientBuilder jsonWebKey(JsonWebKey jsonWebKey) {
        if (jsonWebKey == null) {
            throw LOGGER.logExceptionAsError(new NullPointerException("'jsonWebKey' must not be null."));
        }
        this.jsonWebKey = jsonWebKey;
        return this;
    }

    @Override
    public CryptographyClientBuilder httpLogOptions(HttpLogOptions logOptions) {
        this.httpLogOptions = logOptions;
        return this;
    }

    @Override
    public CryptographyClientBuilder addPolicy(HttpPipelinePolicy policy) {
        if (policy == null) {
            throw LOGGER.logExceptionAsError(new NullPointerException("'policy' cannot be null."));
        }
        if (policy.getPipelinePosition() == HttpPipelinePosition.PER_CALL) {
            this.perCallPolicies.add(policy);
        } else {
            this.perRetryPolicies.add(policy);
        }
        return this;
    }

    @Override
    public CryptographyClientBuilder httpClient(HttpClient client) {
        this.httpClient = client;
        return this;
    }

    @Override
    public CryptographyClientBuilder pipeline(HttpPipeline pipeline) {
        this.pipeline = pipeline;
        return this;
    }

    @Override
    public CryptographyClientBuilder configuration(Configuration configuration) {
        this.configuration = configuration;
        return this;
    }

    public CryptographyClientBuilder serviceVersion(CryptographyServiceVersion version) {
        this.version = version;
        return this;
    }

    public CryptographyClientBuilder retryPolicy(RetryPolicy retryPolicy) {
        this.retryPolicy = retryPolicy;
        return this;
    }

    @Override
    public CryptographyClientBuilder retryOptions(RetryOptions retryOptions) {
        this.retryOptions = retryOptions;
        return this;
    }

    @Override
    public CryptographyClientBuilder clientOptions(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        return this;
    }

    public CryptographyClientBuilder disableChallengeResourceVerification() {
        this.isChallengeResourceVerificationDisabled = true;
        return this;
    }

    public CryptographyClientBuilder disableKeyCaching() {
        this.isKeyCachingDisabled = true;
        return this;
    }

    static {
        Map<String, String> properties = CoreUtils.getProperties("azure-key-vault-keys.properties");
        CLIENT_NAME = properties.getOrDefault("name", "UnknownName");
        CLIENT_VERSION = properties.getOrDefault("version", "UnknownVersion");
    }
}

