/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.security.keyvault.keys.implementation;

import com.dataiku.dss.shadelibazure.com.azure.core.annotation.BodyParam;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.Delete;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.ExpectedResponses;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.Get;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.HeaderParam;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.Host;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.HostParam;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.Patch;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.PathParam;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.Post;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.Put;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.QueryParam;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.ReturnType;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.ServiceInterface;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.ServiceMethod;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.dataiku.dss.shadelibazure.com.azure.core.http.HttpPipeline;
import com.dataiku.dss.shadelibazure.com.azure.core.http.HttpPipelineBuilder;
import com.dataiku.dss.shadelibazure.com.azure.core.http.policy.RetryPolicy;
import com.dataiku.dss.shadelibazure.com.azure.core.http.policy.UserAgentPolicy;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedFlux;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedIterable;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedResponse;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedResponseBase;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.Response;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.RestProxy;
import com.dataiku.dss.shadelibazure.com.azure.core.util.Context;
import com.dataiku.dss.shadelibazure.com.azure.core.util.FluxUtil;
import com.dataiku.dss.shadelibazure.com.azure.core.util.serializer.JacksonAdapter;
import com.dataiku.dss.shadelibazure.com.azure.core.util.serializer.SerializerAdapter;
import com.dataiku.dss.shadelibazure.com.azure.security.keyvault.keys.implementation.models.BackupKeyResult;
import com.dataiku.dss.shadelibazure.com.azure.security.keyvault.keys.implementation.models.DeletedKeyBundle;
import com.dataiku.dss.shadelibazure.com.azure.security.keyvault.keys.implementation.models.DeletedKeyItem;
import com.dataiku.dss.shadelibazure.com.azure.security.keyvault.keys.implementation.models.DeletedKeyListResult;
import com.dataiku.dss.shadelibazure.com.azure.security.keyvault.keys.implementation.models.GetRandomBytesRequest;
import com.dataiku.dss.shadelibazure.com.azure.security.keyvault.keys.implementation.models.JsonWebKey;
import com.dataiku.dss.shadelibazure.com.azure.security.keyvault.keys.implementation.models.JsonWebKeyEncryptionAlgorithm;
import com.dataiku.dss.shadelibazure.com.azure.security.keyvault.keys.implementation.models.JsonWebKeySignatureAlgorithm;
import com.dataiku.dss.shadelibazure.com.azure.security.keyvault.keys.implementation.models.KeyAttributes;
import com.dataiku.dss.shadelibazure.com.azure.security.keyvault.keys.implementation.models.KeyBundle;
import com.dataiku.dss.shadelibazure.com.azure.security.keyvault.keys.implementation.models.KeyCreateParameters;
import com.dataiku.dss.shadelibazure.com.azure.security.keyvault.keys.implementation.models.KeyImportParameters;
import com.dataiku.dss.shadelibazure.com.azure.security.keyvault.keys.implementation.models.KeyItem;
import com.dataiku.dss.shadelibazure.com.azure.security.keyvault.keys.implementation.models.KeyListResult;
import com.dataiku.dss.shadelibazure.com.azure.security.keyvault.keys.implementation.models.KeyOperationResult;
import com.dataiku.dss.shadelibazure.com.azure.security.keyvault.keys.implementation.models.KeyOperationsParameters;
import com.dataiku.dss.shadelibazure.com.azure.security.keyvault.keys.implementation.models.KeyReleaseParameters;
import com.dataiku.dss.shadelibazure.com.azure.security.keyvault.keys.implementation.models.KeyReleasePolicy;
import com.dataiku.dss.shadelibazure.com.azure.security.keyvault.keys.implementation.models.KeyRestoreParameters;
import com.dataiku.dss.shadelibazure.com.azure.security.keyvault.keys.implementation.models.KeyRotationPolicy;
import com.dataiku.dss.shadelibazure.com.azure.security.keyvault.keys.implementation.models.KeySignParameters;
import com.dataiku.dss.shadelibazure.com.azure.security.keyvault.keys.implementation.models.KeyUpdateParameters;
import com.dataiku.dss.shadelibazure.com.azure.security.keyvault.keys.implementation.models.KeyVaultErrorException;
import com.dataiku.dss.shadelibazure.com.azure.security.keyvault.keys.implementation.models.KeyVerifyParameters;
import com.dataiku.dss.shadelibazure.com.azure.security.keyvault.keys.implementation.models.KeyVerifyResult;
import com.dataiku.dss.shadelibazure.com.azure.security.keyvault.keys.implementation.models.RandomBytes;
import com.dataiku.dss.shadelibazure.com.azure.security.keyvault.keys.models.KeyCurveName;
import com.dataiku.dss.shadelibazure.com.azure.security.keyvault.keys.models.KeyExportEncryptionAlgorithm;
import com.dataiku.dss.shadelibazure.com.azure.security.keyvault.keys.models.KeyOperation;
import com.dataiku.dss.shadelibazure.com.azure.security.keyvault.keys.models.KeyType;
import com.dataiku.dss.shadelibazure.com.azure.security.keyvault.keys.models.ReleaseKeyResult;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Mono;
import java.util.List;
import java.util.Map;

public final class KeyClientImpl {
    private final KeyClientService service;
    private final String apiVersion;
    private final HttpPipeline httpPipeline;
    private final SerializerAdapter serializerAdapter;

    public String getApiVersion() {
        return this.apiVersion;
    }

    public HttpPipeline getHttpPipeline() {
        return this.httpPipeline;
    }

    public SerializerAdapter getSerializerAdapter() {
        return this.serializerAdapter;
    }

    public KeyClientImpl(String apiVersion) {
        this(new HttpPipelineBuilder().policies(new UserAgentPolicy(), new RetryPolicy()).build(), JacksonAdapter.createDefaultSerializerAdapter(), apiVersion);
    }

    public KeyClientImpl(HttpPipeline httpPipeline, String apiVersion) {
        this(httpPipeline, JacksonAdapter.createDefaultSerializerAdapter(), apiVersion);
    }

    public KeyClientImpl(HttpPipeline httpPipeline, SerializerAdapter serializerAdapter, String apiVersion) {
        this.httpPipeline = httpPipeline;
        this.serializerAdapter = serializerAdapter;
        this.apiVersion = apiVersion;
        this.service = RestProxy.create(KeyClientService.class, this.httpPipeline, this.getSerializerAdapter());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<KeyBundle>> createKeyWithResponseAsync(String vaultBaseUrl, String keyName, KeyType kty, Integer keySize, Integer publicExponent, List<KeyOperation> keyOps, KeyAttributes keyAttributes, Map<String, String> tags, KeyCurveName crv, KeyReleasePolicy releasePolicy) {
        return FluxUtil.withContext(context -> this.createKeyWithResponseAsync(vaultBaseUrl, keyName, kty, keySize, publicExponent, keyOps, keyAttributes, tags, crv, releasePolicy, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<KeyBundle>> createKeyWithResponseAsync(String vaultBaseUrl, String keyName, KeyType kty, Integer keySize, Integer publicExponent, List<KeyOperation> keyOps, KeyAttributes keyAttributes, Map<String, String> tags, KeyCurveName crv, KeyReleasePolicy releasePolicy, Context context) {
        String accept = "application/json";
        KeyCreateParameters parameters = new KeyCreateParameters();
        parameters.setKty(kty);
        parameters.setKeySize(keySize);
        parameters.setPublicExponent(publicExponent);
        parameters.setKeyOps(keyOps);
        parameters.setKeyAttributes(keyAttributes);
        parameters.setTags(tags);
        parameters.setCrv(crv);
        parameters.setReleasePolicy(releasePolicy);
        return this.service.createKey(vaultBaseUrl, keyName, this.getApiVersion(), parameters, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<KeyBundle> createKeyAsync(String vaultBaseUrl, String keyName, KeyType kty, Integer keySize, Integer publicExponent, List<KeyOperation> keyOps, KeyAttributes keyAttributes, Map<String, String> tags, KeyCurveName crv, KeyReleasePolicy releasePolicy) {
        return this.createKeyWithResponseAsync(vaultBaseUrl, keyName, kty, keySize, publicExponent, keyOps, keyAttributes, tags, crv, releasePolicy).flatMap(res -> Mono.justOrEmpty((KeyBundle)res.getValue()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<KeyBundle> createKeyAsync(String vaultBaseUrl, String keyName, KeyType kty, Integer keySize, Integer publicExponent, List<KeyOperation> keyOps, KeyAttributes keyAttributes, Map<String, String> tags, KeyCurveName crv, KeyReleasePolicy releasePolicy, Context context) {
        return this.createKeyWithResponseAsync(vaultBaseUrl, keyName, kty, keySize, publicExponent, keyOps, keyAttributes, tags, crv, releasePolicy, context).flatMap(res -> Mono.justOrEmpty((KeyBundle)res.getValue()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<KeyBundle> createKeyWithResponse(String vaultBaseUrl, String keyName, KeyType kty, Integer keySize, Integer publicExponent, List<KeyOperation> keyOps, KeyAttributes keyAttributes, Map<String, String> tags, KeyCurveName crv, KeyReleasePolicy releasePolicy, Context context) {
        String accept = "application/json";
        KeyCreateParameters parameters = new KeyCreateParameters();
        parameters.setKty(kty);
        parameters.setKeySize(keySize);
        parameters.setPublicExponent(publicExponent);
        parameters.setKeyOps(keyOps);
        parameters.setKeyAttributes(keyAttributes);
        parameters.setTags(tags);
        parameters.setCrv(crv);
        parameters.setReleasePolicy(releasePolicy);
        return this.service.createKeySync(vaultBaseUrl, keyName, this.getApiVersion(), parameters, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public KeyBundle createKey(String vaultBaseUrl, String keyName, KeyType kty, Integer keySize, Integer publicExponent, List<KeyOperation> keyOps, KeyAttributes keyAttributes, Map<String, String> tags, KeyCurveName crv, KeyReleasePolicy releasePolicy) {
        return this.createKeyWithResponse(vaultBaseUrl, keyName, kty, keySize, publicExponent, keyOps, keyAttributes, tags, crv, releasePolicy, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<KeyBundle>> rotateKeyWithResponseAsync(String vaultBaseUrl, String keyName) {
        return FluxUtil.withContext(context -> this.rotateKeyWithResponseAsync(vaultBaseUrl, keyName, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<KeyBundle>> rotateKeyWithResponseAsync(String vaultBaseUrl, String keyName, Context context) {
        String accept = "application/json";
        return this.service.rotateKey(vaultBaseUrl, keyName, this.getApiVersion(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<KeyBundle> rotateKeyAsync(String vaultBaseUrl, String keyName) {
        return this.rotateKeyWithResponseAsync(vaultBaseUrl, keyName).flatMap(res -> Mono.justOrEmpty((KeyBundle)res.getValue()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<KeyBundle> rotateKeyAsync(String vaultBaseUrl, String keyName, Context context) {
        return this.rotateKeyWithResponseAsync(vaultBaseUrl, keyName, context).flatMap(res -> Mono.justOrEmpty((KeyBundle)res.getValue()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<KeyBundle> rotateKeyWithResponse(String vaultBaseUrl, String keyName, Context context) {
        String accept = "application/json";
        return this.service.rotateKeySync(vaultBaseUrl, keyName, this.getApiVersion(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public KeyBundle rotateKey(String vaultBaseUrl, String keyName) {
        return this.rotateKeyWithResponse(vaultBaseUrl, keyName, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<KeyBundle>> importKeyWithResponseAsync(String vaultBaseUrl, String keyName, JsonWebKey key, Boolean hsm, KeyAttributes keyAttributes, Map<String, String> tags, KeyReleasePolicy releasePolicy) {
        return FluxUtil.withContext(context -> this.importKeyWithResponseAsync(vaultBaseUrl, keyName, key, hsm, keyAttributes, tags, releasePolicy, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<KeyBundle>> importKeyWithResponseAsync(String vaultBaseUrl, String keyName, JsonWebKey key, Boolean hsm, KeyAttributes keyAttributes, Map<String, String> tags, KeyReleasePolicy releasePolicy, Context context) {
        String accept = "application/json";
        KeyImportParameters parameters = new KeyImportParameters();
        parameters.setHsm(hsm);
        parameters.setKey(key);
        parameters.setKeyAttributes(keyAttributes);
        parameters.setTags(tags);
        parameters.setReleasePolicy(releasePolicy);
        return this.service.importKey(vaultBaseUrl, keyName, this.getApiVersion(), parameters, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<KeyBundle> importKeyAsync(String vaultBaseUrl, String keyName, JsonWebKey key, Boolean hsm, KeyAttributes keyAttributes, Map<String, String> tags, KeyReleasePolicy releasePolicy) {
        return this.importKeyWithResponseAsync(vaultBaseUrl, keyName, key, hsm, keyAttributes, tags, releasePolicy).flatMap(res -> Mono.justOrEmpty((KeyBundle)res.getValue()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<KeyBundle> importKeyAsync(String vaultBaseUrl, String keyName, JsonWebKey key, Boolean hsm, KeyAttributes keyAttributes, Map<String, String> tags, KeyReleasePolicy releasePolicy, Context context) {
        return this.importKeyWithResponseAsync(vaultBaseUrl, keyName, key, hsm, keyAttributes, tags, releasePolicy, context).flatMap(res -> Mono.justOrEmpty((KeyBundle)res.getValue()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<KeyBundle> importKeyWithResponse(String vaultBaseUrl, String keyName, JsonWebKey key, Boolean hsm, KeyAttributes keyAttributes, Map<String, String> tags, KeyReleasePolicy releasePolicy, Context context) {
        String accept = "application/json";
        KeyImportParameters parameters = new KeyImportParameters();
        parameters.setHsm(hsm);
        parameters.setKey(key);
        parameters.setKeyAttributes(keyAttributes);
        parameters.setTags(tags);
        parameters.setReleasePolicy(releasePolicy);
        return this.service.importKeySync(vaultBaseUrl, keyName, this.getApiVersion(), parameters, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public KeyBundle importKey(String vaultBaseUrl, String keyName, JsonWebKey key, Boolean hsm, KeyAttributes keyAttributes, Map<String, String> tags, KeyReleasePolicy releasePolicy) {
        return this.importKeyWithResponse(vaultBaseUrl, keyName, key, hsm, keyAttributes, tags, releasePolicy, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<DeletedKeyBundle>> deleteKeyWithResponseAsync(String vaultBaseUrl, String keyName) {
        return FluxUtil.withContext(context -> this.deleteKeyWithResponseAsync(vaultBaseUrl, keyName, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<DeletedKeyBundle>> deleteKeyWithResponseAsync(String vaultBaseUrl, String keyName, Context context) {
        String accept = "application/json";
        return this.service.deleteKey(vaultBaseUrl, keyName, this.getApiVersion(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<DeletedKeyBundle> deleteKeyAsync(String vaultBaseUrl, String keyName) {
        return this.deleteKeyWithResponseAsync(vaultBaseUrl, keyName).flatMap(res -> Mono.justOrEmpty((DeletedKeyBundle)res.getValue()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<DeletedKeyBundle> deleteKeyAsync(String vaultBaseUrl, String keyName, Context context) {
        return this.deleteKeyWithResponseAsync(vaultBaseUrl, keyName, context).flatMap(res -> Mono.justOrEmpty((DeletedKeyBundle)res.getValue()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<DeletedKeyBundle> deleteKeyWithResponse(String vaultBaseUrl, String keyName, Context context) {
        String accept = "application/json";
        return this.service.deleteKeySync(vaultBaseUrl, keyName, this.getApiVersion(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public DeletedKeyBundle deleteKey(String vaultBaseUrl, String keyName) {
        return this.deleteKeyWithResponse(vaultBaseUrl, keyName, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<KeyBundle>> updateKeyWithResponseAsync(String vaultBaseUrl, String keyName, String keyVersion, List<KeyOperation> keyOps, KeyAttributes keyAttributes, Map<String, String> tags, KeyReleasePolicy releasePolicy) {
        return FluxUtil.withContext(context -> this.updateKeyWithResponseAsync(vaultBaseUrl, keyName, keyVersion, keyOps, keyAttributes, tags, releasePolicy, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<KeyBundle>> updateKeyWithResponseAsync(String vaultBaseUrl, String keyName, String keyVersion, List<KeyOperation> keyOps, KeyAttributes keyAttributes, Map<String, String> tags, KeyReleasePolicy releasePolicy, Context context) {
        String accept = "application/json";
        KeyUpdateParameters parameters = new KeyUpdateParameters();
        parameters.setKeyOps(keyOps);
        parameters.setKeyAttributes(keyAttributes);
        parameters.setTags(tags);
        parameters.setReleasePolicy(releasePolicy);
        return this.service.updateKey(vaultBaseUrl, keyName, keyVersion, this.getApiVersion(), parameters, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<KeyBundle> updateKeyAsync(String vaultBaseUrl, String keyName, String keyVersion, List<KeyOperation> keyOps, KeyAttributes keyAttributes, Map<String, String> tags, KeyReleasePolicy releasePolicy) {
        return this.updateKeyWithResponseAsync(vaultBaseUrl, keyName, keyVersion, keyOps, keyAttributes, tags, releasePolicy).flatMap(res -> Mono.justOrEmpty((KeyBundle)res.getValue()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<KeyBundle> updateKeyAsync(String vaultBaseUrl, String keyName, String keyVersion, List<KeyOperation> keyOps, KeyAttributes keyAttributes, Map<String, String> tags, KeyReleasePolicy releasePolicy, Context context) {
        return this.updateKeyWithResponseAsync(vaultBaseUrl, keyName, keyVersion, keyOps, keyAttributes, tags, releasePolicy, context).flatMap(res -> Mono.justOrEmpty((KeyBundle)res.getValue()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<KeyBundle> updateKeyWithResponse(String vaultBaseUrl, String keyName, String keyVersion, List<KeyOperation> keyOps, KeyAttributes keyAttributes, Map<String, String> tags, KeyReleasePolicy releasePolicy, Context context) {
        String accept = "application/json";
        KeyUpdateParameters parameters = new KeyUpdateParameters();
        parameters.setKeyOps(keyOps);
        parameters.setKeyAttributes(keyAttributes);
        parameters.setTags(tags);
        parameters.setReleasePolicy(releasePolicy);
        return this.service.updateKeySync(vaultBaseUrl, keyName, keyVersion, this.getApiVersion(), parameters, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public KeyBundle updateKey(String vaultBaseUrl, String keyName, String keyVersion, List<KeyOperation> keyOps, KeyAttributes keyAttributes, Map<String, String> tags, KeyReleasePolicy releasePolicy) {
        return this.updateKeyWithResponse(vaultBaseUrl, keyName, keyVersion, keyOps, keyAttributes, tags, releasePolicy, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<KeyBundle>> getKeyWithResponseAsync(String vaultBaseUrl, String keyName, String keyVersion) {
        return FluxUtil.withContext(context -> this.getKeyWithResponseAsync(vaultBaseUrl, keyName, keyVersion, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<KeyBundle>> getKeyWithResponseAsync(String vaultBaseUrl, String keyName, String keyVersion, Context context) {
        String accept = "application/json";
        return this.service.getKey(vaultBaseUrl, keyName, keyVersion, this.getApiVersion(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<KeyBundle> getKeyAsync(String vaultBaseUrl, String keyName, String keyVersion) {
        return this.getKeyWithResponseAsync(vaultBaseUrl, keyName, keyVersion).flatMap(res -> Mono.justOrEmpty((KeyBundle)res.getValue()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<KeyBundle> getKeyAsync(String vaultBaseUrl, String keyName, String keyVersion, Context context) {
        return this.getKeyWithResponseAsync(vaultBaseUrl, keyName, keyVersion, context).flatMap(res -> Mono.justOrEmpty((KeyBundle)res.getValue()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<KeyBundle> getKeyWithResponse(String vaultBaseUrl, String keyName, String keyVersion, Context context) {
        String accept = "application/json";
        return this.service.getKeySync(vaultBaseUrl, keyName, keyVersion, this.getApiVersion(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public KeyBundle getKey(String vaultBaseUrl, String keyName, String keyVersion) {
        return this.getKeyWithResponse(vaultBaseUrl, keyName, keyVersion, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<KeyItem>> getKeyVersionsSinglePageAsync(String vaultBaseUrl, String keyName, Integer maxresults) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getKeyVersions(vaultBaseUrl, keyName, maxresults, this.getApiVersion(), "application/json", (Context)context)).map(res -> new PagedResponseBase<Object, KeyItem>(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((KeyListResult)res.getValue()).getValue(), ((KeyListResult)res.getValue()).getNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<KeyItem>> getKeyVersionsSinglePageAsync(String vaultBaseUrl, String keyName, Integer maxresults, Context context) {
        String accept = "application/json";
        return this.service.getKeyVersions(vaultBaseUrl, keyName, maxresults, this.getApiVersion(), "application/json", context).map(res -> new PagedResponseBase<Object, KeyItem>(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((KeyListResult)res.getValue()).getValue(), ((KeyListResult)res.getValue()).getNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<KeyItem> getKeyVersionsAsync(String vaultBaseUrl, String keyName, Integer maxresults) {
        return new PagedFlux<KeyItem>(() -> this.getKeyVersionsSinglePageAsync(vaultBaseUrl, keyName, maxresults), nextLink -> this.getKeyVersionsNextSinglePageAsync((String)nextLink, vaultBaseUrl));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<KeyItem> getKeyVersionsAsync(String vaultBaseUrl, String keyName, Integer maxresults, Context context) {
        return new PagedFlux<KeyItem>(() -> this.getKeyVersionsSinglePageAsync(vaultBaseUrl, keyName, maxresults, context), nextLink -> this.getKeyVersionsNextSinglePageAsync((String)nextLink, vaultBaseUrl, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PagedResponse<KeyItem> getKeyVersionsSinglePage(String vaultBaseUrl, String keyName, Integer maxresults) {
        String accept = "application/json";
        Response<KeyListResult> res = this.service.getKeyVersionsSync(vaultBaseUrl, keyName, maxresults, this.getApiVersion(), "application/json", Context.NONE);
        return new PagedResponseBase<Object, KeyItem>(res.getRequest(), res.getStatusCode(), res.getHeaders(), res.getValue().getValue(), res.getValue().getNextLink(), null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PagedResponse<KeyItem> getKeyVersionsSinglePage(String vaultBaseUrl, String keyName, Integer maxresults, Context context) {
        String accept = "application/json";
        Response<KeyListResult> res = this.service.getKeyVersionsSync(vaultBaseUrl, keyName, maxresults, this.getApiVersion(), "application/json", context);
        return new PagedResponseBase<Object, KeyItem>(res.getRequest(), res.getStatusCode(), res.getHeaders(), res.getValue().getValue(), res.getValue().getNextLink(), null);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<KeyItem> getKeyVersions(String vaultBaseUrl, String keyName, Integer maxresults) {
        return new PagedIterable<KeyItem>(() -> this.getKeyVersionsSinglePage(vaultBaseUrl, keyName, maxresults, Context.NONE), nextLink -> this.getKeyVersionsNextSinglePage((String)nextLink, vaultBaseUrl));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<KeyItem> getKeyVersions(String vaultBaseUrl, String keyName, Integer maxresults, Context context) {
        return new PagedIterable<KeyItem>(() -> this.getKeyVersionsSinglePage(vaultBaseUrl, keyName, maxresults, context), nextLink -> this.getKeyVersionsNextSinglePage((String)nextLink, vaultBaseUrl, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<KeyItem>> getKeysSinglePageAsync(String vaultBaseUrl, Integer maxresults) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getKeys(vaultBaseUrl, maxresults, this.getApiVersion(), "application/json", (Context)context)).map(res -> new PagedResponseBase<Object, KeyItem>(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((KeyListResult)res.getValue()).getValue(), ((KeyListResult)res.getValue()).getNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<KeyItem>> getKeysSinglePageAsync(String vaultBaseUrl, Integer maxresults, Context context) {
        String accept = "application/json";
        return this.service.getKeys(vaultBaseUrl, maxresults, this.getApiVersion(), "application/json", context).map(res -> new PagedResponseBase<Object, KeyItem>(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((KeyListResult)res.getValue()).getValue(), ((KeyListResult)res.getValue()).getNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<KeyItem> getKeysAsync(String vaultBaseUrl, Integer maxresults) {
        return new PagedFlux<KeyItem>(() -> this.getKeysSinglePageAsync(vaultBaseUrl, maxresults), nextLink -> this.getKeysNextSinglePageAsync((String)nextLink, vaultBaseUrl));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<KeyItem> getKeysAsync(String vaultBaseUrl, Integer maxresults, Context context) {
        return new PagedFlux<KeyItem>(() -> this.getKeysSinglePageAsync(vaultBaseUrl, maxresults, context), nextLink -> this.getKeysNextSinglePageAsync((String)nextLink, vaultBaseUrl, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PagedResponse<KeyItem> getKeysSinglePage(String vaultBaseUrl, Integer maxresults) {
        String accept = "application/json";
        Response<KeyListResult> res = this.service.getKeysSync(vaultBaseUrl, maxresults, this.getApiVersion(), "application/json", Context.NONE);
        return new PagedResponseBase<Object, KeyItem>(res.getRequest(), res.getStatusCode(), res.getHeaders(), res.getValue().getValue(), res.getValue().getNextLink(), null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PagedResponse<KeyItem> getKeysSinglePage(String vaultBaseUrl, Integer maxresults, Context context) {
        String accept = "application/json";
        Response<KeyListResult> res = this.service.getKeysSync(vaultBaseUrl, maxresults, this.getApiVersion(), "application/json", context);
        return new PagedResponseBase<Object, KeyItem>(res.getRequest(), res.getStatusCode(), res.getHeaders(), res.getValue().getValue(), res.getValue().getNextLink(), null);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<KeyItem> getKeys(String vaultBaseUrl, Integer maxresults) {
        return new PagedIterable<KeyItem>(() -> this.getKeysSinglePage(vaultBaseUrl, maxresults, Context.NONE), nextLink -> this.getKeysNextSinglePage((String)nextLink, vaultBaseUrl));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<KeyItem> getKeys(String vaultBaseUrl, Integer maxresults, Context context) {
        return new PagedIterable<KeyItem>(() -> this.getKeysSinglePage(vaultBaseUrl, maxresults, context), nextLink -> this.getKeysNextSinglePage((String)nextLink, vaultBaseUrl, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BackupKeyResult>> backupKeyWithResponseAsync(String vaultBaseUrl, String keyName) {
        return FluxUtil.withContext(context -> this.backupKeyWithResponseAsync(vaultBaseUrl, keyName, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BackupKeyResult>> backupKeyWithResponseAsync(String vaultBaseUrl, String keyName, Context context) {
        String accept = "application/json";
        return this.service.backupKey(vaultBaseUrl, keyName, this.getApiVersion(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<BackupKeyResult> backupKeyAsync(String vaultBaseUrl, String keyName) {
        return this.backupKeyWithResponseAsync(vaultBaseUrl, keyName).flatMap(res -> Mono.justOrEmpty((BackupKeyResult)res.getValue()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<BackupKeyResult> backupKeyAsync(String vaultBaseUrl, String keyName, Context context) {
        return this.backupKeyWithResponseAsync(vaultBaseUrl, keyName, context).flatMap(res -> Mono.justOrEmpty((BackupKeyResult)res.getValue()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BackupKeyResult> backupKeyWithResponse(String vaultBaseUrl, String keyName, Context context) {
        String accept = "application/json";
        return this.service.backupKeySync(vaultBaseUrl, keyName, this.getApiVersion(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public BackupKeyResult backupKey(String vaultBaseUrl, String keyName) {
        return this.backupKeyWithResponse(vaultBaseUrl, keyName, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<KeyBundle>> restoreKeyWithResponseAsync(String vaultBaseUrl, byte[] keyBundleBackup) {
        return FluxUtil.withContext(context -> this.restoreKeyWithResponseAsync(vaultBaseUrl, keyBundleBackup, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<KeyBundle>> restoreKeyWithResponseAsync(String vaultBaseUrl, byte[] keyBundleBackup, Context context) {
        String accept = "application/json";
        KeyRestoreParameters parameters = new KeyRestoreParameters();
        parameters.setKeyBundleBackup(keyBundleBackup);
        return this.service.restoreKey(vaultBaseUrl, this.getApiVersion(), parameters, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<KeyBundle> restoreKeyAsync(String vaultBaseUrl, byte[] keyBundleBackup) {
        return this.restoreKeyWithResponseAsync(vaultBaseUrl, keyBundleBackup).flatMap(res -> Mono.justOrEmpty((KeyBundle)res.getValue()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<KeyBundle> restoreKeyAsync(String vaultBaseUrl, byte[] keyBundleBackup, Context context) {
        return this.restoreKeyWithResponseAsync(vaultBaseUrl, keyBundleBackup, context).flatMap(res -> Mono.justOrEmpty((KeyBundle)res.getValue()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<KeyBundle> restoreKeyWithResponse(String vaultBaseUrl, byte[] keyBundleBackup, Context context) {
        String accept = "application/json";
        KeyRestoreParameters parameters = new KeyRestoreParameters();
        parameters.setKeyBundleBackup(keyBundleBackup);
        return this.service.restoreKeySync(vaultBaseUrl, this.getApiVersion(), parameters, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public KeyBundle restoreKey(String vaultBaseUrl, byte[] keyBundleBackup) {
        return this.restoreKeyWithResponse(vaultBaseUrl, keyBundleBackup, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<KeyOperationResult>> encryptWithResponseAsync(String vaultBaseUrl, String keyName, String keyVersion, JsonWebKeyEncryptionAlgorithm algorithm, byte[] value, byte[] iv, byte[] aad, byte[] tag) {
        return FluxUtil.withContext(context -> this.encryptWithResponseAsync(vaultBaseUrl, keyName, keyVersion, algorithm, value, iv, aad, tag, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<KeyOperationResult>> encryptWithResponseAsync(String vaultBaseUrl, String keyName, String keyVersion, JsonWebKeyEncryptionAlgorithm algorithm, byte[] value, byte[] iv, byte[] aad, byte[] tag, Context context) {
        String accept = "application/json";
        KeyOperationsParameters parameters = new KeyOperationsParameters();
        parameters.setAlgorithm(algorithm);
        parameters.setValue(value);
        parameters.setIv(iv);
        parameters.setAad(aad);
        parameters.setTag(tag);
        return this.service.encrypt(vaultBaseUrl, keyName, keyVersion, this.getApiVersion(), parameters, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<KeyOperationResult> encryptAsync(String vaultBaseUrl, String keyName, String keyVersion, JsonWebKeyEncryptionAlgorithm algorithm, byte[] value, byte[] iv, byte[] aad, byte[] tag) {
        return this.encryptWithResponseAsync(vaultBaseUrl, keyName, keyVersion, algorithm, value, iv, aad, tag).flatMap(res -> Mono.justOrEmpty((KeyOperationResult)res.getValue()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<KeyOperationResult> encryptAsync(String vaultBaseUrl, String keyName, String keyVersion, JsonWebKeyEncryptionAlgorithm algorithm, byte[] value, byte[] iv, byte[] aad, byte[] tag, Context context) {
        return this.encryptWithResponseAsync(vaultBaseUrl, keyName, keyVersion, algorithm, value, iv, aad, tag, context).flatMap(res -> Mono.justOrEmpty((KeyOperationResult)res.getValue()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<KeyOperationResult> encryptWithResponse(String vaultBaseUrl, String keyName, String keyVersion, JsonWebKeyEncryptionAlgorithm algorithm, byte[] value, byte[] iv, byte[] aad, byte[] tag, Context context) {
        String accept = "application/json";
        KeyOperationsParameters parameters = new KeyOperationsParameters();
        parameters.setAlgorithm(algorithm);
        parameters.setValue(value);
        parameters.setIv(iv);
        parameters.setAad(aad);
        parameters.setTag(tag);
        return this.service.encryptSync(vaultBaseUrl, keyName, keyVersion, this.getApiVersion(), parameters, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public KeyOperationResult encrypt(String vaultBaseUrl, String keyName, String keyVersion, JsonWebKeyEncryptionAlgorithm algorithm, byte[] value, byte[] iv, byte[] aad, byte[] tag) {
        return this.encryptWithResponse(vaultBaseUrl, keyName, keyVersion, algorithm, value, iv, aad, tag, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<KeyOperationResult>> decryptWithResponseAsync(String vaultBaseUrl, String keyName, String keyVersion, JsonWebKeyEncryptionAlgorithm algorithm, byte[] value, byte[] iv, byte[] aad, byte[] tag) {
        return FluxUtil.withContext(context -> this.decryptWithResponseAsync(vaultBaseUrl, keyName, keyVersion, algorithm, value, iv, aad, tag, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<KeyOperationResult>> decryptWithResponseAsync(String vaultBaseUrl, String keyName, String keyVersion, JsonWebKeyEncryptionAlgorithm algorithm, byte[] value, byte[] iv, byte[] aad, byte[] tag, Context context) {
        String accept = "application/json";
        KeyOperationsParameters parameters = new KeyOperationsParameters();
        parameters.setAlgorithm(algorithm);
        parameters.setValue(value);
        parameters.setIv(iv);
        parameters.setAad(aad);
        parameters.setTag(tag);
        return this.service.decrypt(vaultBaseUrl, keyName, keyVersion, this.getApiVersion(), parameters, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<KeyOperationResult> decryptAsync(String vaultBaseUrl, String keyName, String keyVersion, JsonWebKeyEncryptionAlgorithm algorithm, byte[] value, byte[] iv, byte[] aad, byte[] tag) {
        return this.decryptWithResponseAsync(vaultBaseUrl, keyName, keyVersion, algorithm, value, iv, aad, tag).flatMap(res -> Mono.justOrEmpty((KeyOperationResult)res.getValue()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<KeyOperationResult> decryptAsync(String vaultBaseUrl, String keyName, String keyVersion, JsonWebKeyEncryptionAlgorithm algorithm, byte[] value, byte[] iv, byte[] aad, byte[] tag, Context context) {
        return this.decryptWithResponseAsync(vaultBaseUrl, keyName, keyVersion, algorithm, value, iv, aad, tag, context).flatMap(res -> Mono.justOrEmpty((KeyOperationResult)res.getValue()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<KeyOperationResult> decryptWithResponse(String vaultBaseUrl, String keyName, String keyVersion, JsonWebKeyEncryptionAlgorithm algorithm, byte[] value, byte[] iv, byte[] aad, byte[] tag, Context context) {
        String accept = "application/json";
        KeyOperationsParameters parameters = new KeyOperationsParameters();
        parameters.setAlgorithm(algorithm);
        parameters.setValue(value);
        parameters.setIv(iv);
        parameters.setAad(aad);
        parameters.setTag(tag);
        return this.service.decryptSync(vaultBaseUrl, keyName, keyVersion, this.getApiVersion(), parameters, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public KeyOperationResult decrypt(String vaultBaseUrl, String keyName, String keyVersion, JsonWebKeyEncryptionAlgorithm algorithm, byte[] value, byte[] iv, byte[] aad, byte[] tag) {
        return this.decryptWithResponse(vaultBaseUrl, keyName, keyVersion, algorithm, value, iv, aad, tag, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<KeyOperationResult>> signWithResponseAsync(String vaultBaseUrl, String keyName, String keyVersion, JsonWebKeySignatureAlgorithm algorithm, byte[] value) {
        return FluxUtil.withContext(context -> this.signWithResponseAsync(vaultBaseUrl, keyName, keyVersion, algorithm, value, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<KeyOperationResult>> signWithResponseAsync(String vaultBaseUrl, String keyName, String keyVersion, JsonWebKeySignatureAlgorithm algorithm, byte[] value, Context context) {
        String accept = "application/json";
        KeySignParameters parameters = new KeySignParameters();
        parameters.setAlgorithm(algorithm);
        parameters.setValue(value);
        return this.service.sign(vaultBaseUrl, keyName, keyVersion, this.getApiVersion(), parameters, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<KeyOperationResult> signAsync(String vaultBaseUrl, String keyName, String keyVersion, JsonWebKeySignatureAlgorithm algorithm, byte[] value) {
        return this.signWithResponseAsync(vaultBaseUrl, keyName, keyVersion, algorithm, value).flatMap(res -> Mono.justOrEmpty((KeyOperationResult)res.getValue()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<KeyOperationResult> signAsync(String vaultBaseUrl, String keyName, String keyVersion, JsonWebKeySignatureAlgorithm algorithm, byte[] value, Context context) {
        return this.signWithResponseAsync(vaultBaseUrl, keyName, keyVersion, algorithm, value, context).flatMap(res -> Mono.justOrEmpty((KeyOperationResult)res.getValue()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<KeyOperationResult> signWithResponse(String vaultBaseUrl, String keyName, String keyVersion, JsonWebKeySignatureAlgorithm algorithm, byte[] value, Context context) {
        String accept = "application/json";
        KeySignParameters parameters = new KeySignParameters();
        parameters.setAlgorithm(algorithm);
        parameters.setValue(value);
        return this.service.signSync(vaultBaseUrl, keyName, keyVersion, this.getApiVersion(), parameters, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public KeyOperationResult sign(String vaultBaseUrl, String keyName, String keyVersion, JsonWebKeySignatureAlgorithm algorithm, byte[] value) {
        return this.signWithResponse(vaultBaseUrl, keyName, keyVersion, algorithm, value, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<KeyVerifyResult>> verifyWithResponseAsync(String vaultBaseUrl, String keyName, String keyVersion, JsonWebKeySignatureAlgorithm algorithm, byte[] digest, byte[] signature) {
        return FluxUtil.withContext(context -> this.verifyWithResponseAsync(vaultBaseUrl, keyName, keyVersion, algorithm, digest, signature, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<KeyVerifyResult>> verifyWithResponseAsync(String vaultBaseUrl, String keyName, String keyVersion, JsonWebKeySignatureAlgorithm algorithm, byte[] digest, byte[] signature, Context context) {
        String accept = "application/json";
        KeyVerifyParameters parameters = new KeyVerifyParameters();
        parameters.setAlgorithm(algorithm);
        parameters.setDigest(digest);
        parameters.setSignature(signature);
        return this.service.verify(vaultBaseUrl, keyName, keyVersion, this.getApiVersion(), parameters, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<KeyVerifyResult> verifyAsync(String vaultBaseUrl, String keyName, String keyVersion, JsonWebKeySignatureAlgorithm algorithm, byte[] digest, byte[] signature) {
        return this.verifyWithResponseAsync(vaultBaseUrl, keyName, keyVersion, algorithm, digest, signature).flatMap(res -> Mono.justOrEmpty((KeyVerifyResult)res.getValue()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<KeyVerifyResult> verifyAsync(String vaultBaseUrl, String keyName, String keyVersion, JsonWebKeySignatureAlgorithm algorithm, byte[] digest, byte[] signature, Context context) {
        return this.verifyWithResponseAsync(vaultBaseUrl, keyName, keyVersion, algorithm, digest, signature, context).flatMap(res -> Mono.justOrEmpty((KeyVerifyResult)res.getValue()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<KeyVerifyResult> verifyWithResponse(String vaultBaseUrl, String keyName, String keyVersion, JsonWebKeySignatureAlgorithm algorithm, byte[] digest, byte[] signature, Context context) {
        String accept = "application/json";
        KeyVerifyParameters parameters = new KeyVerifyParameters();
        parameters.setAlgorithm(algorithm);
        parameters.setDigest(digest);
        parameters.setSignature(signature);
        return this.service.verifySync(vaultBaseUrl, keyName, keyVersion, this.getApiVersion(), parameters, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public KeyVerifyResult verify(String vaultBaseUrl, String keyName, String keyVersion, JsonWebKeySignatureAlgorithm algorithm, byte[] digest, byte[] signature) {
        return this.verifyWithResponse(vaultBaseUrl, keyName, keyVersion, algorithm, digest, signature, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<KeyOperationResult>> wrapKeyWithResponseAsync(String vaultBaseUrl, String keyName, String keyVersion, JsonWebKeyEncryptionAlgorithm algorithm, byte[] value, byte[] iv, byte[] aad, byte[] tag) {
        return FluxUtil.withContext(context -> this.wrapKeyWithResponseAsync(vaultBaseUrl, keyName, keyVersion, algorithm, value, iv, aad, tag, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<KeyOperationResult>> wrapKeyWithResponseAsync(String vaultBaseUrl, String keyName, String keyVersion, JsonWebKeyEncryptionAlgorithm algorithm, byte[] value, byte[] iv, byte[] aad, byte[] tag, Context context) {
        String accept = "application/json";
        KeyOperationsParameters parameters = new KeyOperationsParameters();
        parameters.setAlgorithm(algorithm);
        parameters.setValue(value);
        parameters.setIv(iv);
        parameters.setAad(aad);
        parameters.setTag(tag);
        return this.service.wrapKey(vaultBaseUrl, keyName, keyVersion, this.getApiVersion(), parameters, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<KeyOperationResult> wrapKeyAsync(String vaultBaseUrl, String keyName, String keyVersion, JsonWebKeyEncryptionAlgorithm algorithm, byte[] value, byte[] iv, byte[] aad, byte[] tag) {
        return this.wrapKeyWithResponseAsync(vaultBaseUrl, keyName, keyVersion, algorithm, value, iv, aad, tag).flatMap(res -> Mono.justOrEmpty((KeyOperationResult)res.getValue()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<KeyOperationResult> wrapKeyAsync(String vaultBaseUrl, String keyName, String keyVersion, JsonWebKeyEncryptionAlgorithm algorithm, byte[] value, byte[] iv, byte[] aad, byte[] tag, Context context) {
        return this.wrapKeyWithResponseAsync(vaultBaseUrl, keyName, keyVersion, algorithm, value, iv, aad, tag, context).flatMap(res -> Mono.justOrEmpty((KeyOperationResult)res.getValue()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<KeyOperationResult> wrapKeyWithResponse(String vaultBaseUrl, String keyName, String keyVersion, JsonWebKeyEncryptionAlgorithm algorithm, byte[] value, byte[] iv, byte[] aad, byte[] tag, Context context) {
        String accept = "application/json";
        KeyOperationsParameters parameters = new KeyOperationsParameters();
        parameters.setAlgorithm(algorithm);
        parameters.setValue(value);
        parameters.setIv(iv);
        parameters.setAad(aad);
        parameters.setTag(tag);
        return this.service.wrapKeySync(vaultBaseUrl, keyName, keyVersion, this.getApiVersion(), parameters, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public KeyOperationResult wrapKey(String vaultBaseUrl, String keyName, String keyVersion, JsonWebKeyEncryptionAlgorithm algorithm, byte[] value, byte[] iv, byte[] aad, byte[] tag) {
        return this.wrapKeyWithResponse(vaultBaseUrl, keyName, keyVersion, algorithm, value, iv, aad, tag, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<KeyOperationResult>> unwrapKeyWithResponseAsync(String vaultBaseUrl, String keyName, String keyVersion, JsonWebKeyEncryptionAlgorithm algorithm, byte[] value, byte[] iv, byte[] aad, byte[] tag) {
        return FluxUtil.withContext(context -> this.unwrapKeyWithResponseAsync(vaultBaseUrl, keyName, keyVersion, algorithm, value, iv, aad, tag, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<KeyOperationResult>> unwrapKeyWithResponseAsync(String vaultBaseUrl, String keyName, String keyVersion, JsonWebKeyEncryptionAlgorithm algorithm, byte[] value, byte[] iv, byte[] aad, byte[] tag, Context context) {
        String accept = "application/json";
        KeyOperationsParameters parameters = new KeyOperationsParameters();
        parameters.setAlgorithm(algorithm);
        parameters.setValue(value);
        parameters.setIv(iv);
        parameters.setAad(aad);
        parameters.setTag(tag);
        return this.service.unwrapKey(vaultBaseUrl, keyName, keyVersion, this.getApiVersion(), parameters, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<KeyOperationResult> unwrapKeyAsync(String vaultBaseUrl, String keyName, String keyVersion, JsonWebKeyEncryptionAlgorithm algorithm, byte[] value, byte[] iv, byte[] aad, byte[] tag) {
        return this.unwrapKeyWithResponseAsync(vaultBaseUrl, keyName, keyVersion, algorithm, value, iv, aad, tag).flatMap(res -> Mono.justOrEmpty((KeyOperationResult)res.getValue()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<KeyOperationResult> unwrapKeyAsync(String vaultBaseUrl, String keyName, String keyVersion, JsonWebKeyEncryptionAlgorithm algorithm, byte[] value, byte[] iv, byte[] aad, byte[] tag, Context context) {
        return this.unwrapKeyWithResponseAsync(vaultBaseUrl, keyName, keyVersion, algorithm, value, iv, aad, tag, context).flatMap(res -> Mono.justOrEmpty((KeyOperationResult)res.getValue()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<KeyOperationResult> unwrapKeyWithResponse(String vaultBaseUrl, String keyName, String keyVersion, JsonWebKeyEncryptionAlgorithm algorithm, byte[] value, byte[] iv, byte[] aad, byte[] tag, Context context) {
        String accept = "application/json";
        KeyOperationsParameters parameters = new KeyOperationsParameters();
        parameters.setAlgorithm(algorithm);
        parameters.setValue(value);
        parameters.setIv(iv);
        parameters.setAad(aad);
        parameters.setTag(tag);
        return this.service.unwrapKeySync(vaultBaseUrl, keyName, keyVersion, this.getApiVersion(), parameters, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public KeyOperationResult unwrapKey(String vaultBaseUrl, String keyName, String keyVersion, JsonWebKeyEncryptionAlgorithm algorithm, byte[] value, byte[] iv, byte[] aad, byte[] tag) {
        return this.unwrapKeyWithResponse(vaultBaseUrl, keyName, keyVersion, algorithm, value, iv, aad, tag, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<ReleaseKeyResult>> releaseWithResponseAsync(String vaultBaseUrl, String keyName, String keyVersion, String targetAttestationToken, String nonce, KeyExportEncryptionAlgorithm enc) {
        return FluxUtil.withContext(context -> this.releaseWithResponseAsync(vaultBaseUrl, keyName, keyVersion, targetAttestationToken, nonce, enc, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<ReleaseKeyResult>> releaseWithResponseAsync(String vaultBaseUrl, String keyName, String keyVersion, String targetAttestationToken, String nonce, KeyExportEncryptionAlgorithm enc, Context context) {
        String accept = "application/json";
        KeyReleaseParameters parameters = new KeyReleaseParameters();
        parameters.setTargetAttestationToken(targetAttestationToken);
        parameters.setNonce(nonce);
        parameters.setEnc(enc);
        return this.service.release(vaultBaseUrl, keyName, keyVersion, this.getApiVersion(), parameters, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ReleaseKeyResult> releaseAsync(String vaultBaseUrl, String keyName, String keyVersion, String targetAttestationToken, String nonce, KeyExportEncryptionAlgorithm enc) {
        return this.releaseWithResponseAsync(vaultBaseUrl, keyName, keyVersion, targetAttestationToken, nonce, enc).flatMap(res -> Mono.justOrEmpty((ReleaseKeyResult)res.getValue()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ReleaseKeyResult> releaseAsync(String vaultBaseUrl, String keyName, String keyVersion, String targetAttestationToken, String nonce, KeyExportEncryptionAlgorithm enc, Context context) {
        return this.releaseWithResponseAsync(vaultBaseUrl, keyName, keyVersion, targetAttestationToken, nonce, enc, context).flatMap(res -> Mono.justOrEmpty((ReleaseKeyResult)res.getValue()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ReleaseKeyResult> releaseWithResponse(String vaultBaseUrl, String keyName, String keyVersion, String targetAttestationToken, String nonce, KeyExportEncryptionAlgorithm enc, Context context) {
        String accept = "application/json";
        KeyReleaseParameters parameters = new KeyReleaseParameters();
        parameters.setTargetAttestationToken(targetAttestationToken);
        parameters.setNonce(nonce);
        parameters.setEnc(enc);
        return this.service.releaseSync(vaultBaseUrl, keyName, keyVersion, this.getApiVersion(), parameters, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ReleaseKeyResult release(String vaultBaseUrl, String keyName, String keyVersion, String targetAttestationToken, String nonce, KeyExportEncryptionAlgorithm enc) {
        return this.releaseWithResponse(vaultBaseUrl, keyName, keyVersion, targetAttestationToken, nonce, enc, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<DeletedKeyItem>> getDeletedKeysSinglePageAsync(String vaultBaseUrl, Integer maxresults) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getDeletedKeys(vaultBaseUrl, maxresults, this.getApiVersion(), "application/json", (Context)context)).map(res -> new PagedResponseBase<Object, DeletedKeyItem>(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DeletedKeyListResult)res.getValue()).getValue(), ((DeletedKeyListResult)res.getValue()).getNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<DeletedKeyItem>> getDeletedKeysSinglePageAsync(String vaultBaseUrl, Integer maxresults, Context context) {
        String accept = "application/json";
        return this.service.getDeletedKeys(vaultBaseUrl, maxresults, this.getApiVersion(), "application/json", context).map(res -> new PagedResponseBase<Object, DeletedKeyItem>(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DeletedKeyListResult)res.getValue()).getValue(), ((DeletedKeyListResult)res.getValue()).getNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<DeletedKeyItem> getDeletedKeysAsync(String vaultBaseUrl, Integer maxresults) {
        return new PagedFlux<DeletedKeyItem>(() -> this.getDeletedKeysSinglePageAsync(vaultBaseUrl, maxresults), nextLink -> this.getDeletedKeysNextSinglePageAsync((String)nextLink, vaultBaseUrl));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<DeletedKeyItem> getDeletedKeysAsync(String vaultBaseUrl, Integer maxresults, Context context) {
        return new PagedFlux<DeletedKeyItem>(() -> this.getDeletedKeysSinglePageAsync(vaultBaseUrl, maxresults, context), nextLink -> this.getDeletedKeysNextSinglePageAsync((String)nextLink, vaultBaseUrl, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PagedResponse<DeletedKeyItem> getDeletedKeysSinglePage(String vaultBaseUrl, Integer maxresults) {
        String accept = "application/json";
        Response<DeletedKeyListResult> res = this.service.getDeletedKeysSync(vaultBaseUrl, maxresults, this.getApiVersion(), "application/json", Context.NONE);
        return new PagedResponseBase<Object, DeletedKeyItem>(res.getRequest(), res.getStatusCode(), res.getHeaders(), res.getValue().getValue(), res.getValue().getNextLink(), null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PagedResponse<DeletedKeyItem> getDeletedKeysSinglePage(String vaultBaseUrl, Integer maxresults, Context context) {
        String accept = "application/json";
        Response<DeletedKeyListResult> res = this.service.getDeletedKeysSync(vaultBaseUrl, maxresults, this.getApiVersion(), "application/json", context);
        return new PagedResponseBase<Object, DeletedKeyItem>(res.getRequest(), res.getStatusCode(), res.getHeaders(), res.getValue().getValue(), res.getValue().getNextLink(), null);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<DeletedKeyItem> getDeletedKeys(String vaultBaseUrl, Integer maxresults) {
        return new PagedIterable<DeletedKeyItem>(() -> this.getDeletedKeysSinglePage(vaultBaseUrl, maxresults, Context.NONE), nextLink -> this.getDeletedKeysNextSinglePage((String)nextLink, vaultBaseUrl));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<DeletedKeyItem> getDeletedKeys(String vaultBaseUrl, Integer maxresults, Context context) {
        return new PagedIterable<DeletedKeyItem>(() -> this.getDeletedKeysSinglePage(vaultBaseUrl, maxresults, context), nextLink -> this.getDeletedKeysNextSinglePage((String)nextLink, vaultBaseUrl, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<DeletedKeyBundle>> getDeletedKeyWithResponseAsync(String vaultBaseUrl, String keyName) {
        return FluxUtil.withContext(context -> this.getDeletedKeyWithResponseAsync(vaultBaseUrl, keyName, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<DeletedKeyBundle>> getDeletedKeyWithResponseAsync(String vaultBaseUrl, String keyName, Context context) {
        String accept = "application/json";
        return this.service.getDeletedKey(vaultBaseUrl, keyName, this.getApiVersion(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<DeletedKeyBundle> getDeletedKeyAsync(String vaultBaseUrl, String keyName) {
        return this.getDeletedKeyWithResponseAsync(vaultBaseUrl, keyName).flatMap(res -> Mono.justOrEmpty((DeletedKeyBundle)res.getValue()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<DeletedKeyBundle> getDeletedKeyAsync(String vaultBaseUrl, String keyName, Context context) {
        return this.getDeletedKeyWithResponseAsync(vaultBaseUrl, keyName, context).flatMap(res -> Mono.justOrEmpty((DeletedKeyBundle)res.getValue()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<DeletedKeyBundle> getDeletedKeyWithResponse(String vaultBaseUrl, String keyName, Context context) {
        String accept = "application/json";
        return this.service.getDeletedKeySync(vaultBaseUrl, keyName, this.getApiVersion(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public DeletedKeyBundle getDeletedKey(String vaultBaseUrl, String keyName) {
        return this.getDeletedKeyWithResponse(vaultBaseUrl, keyName, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> purgeDeletedKeyWithResponseAsync(String vaultBaseUrl, String keyName) {
        return FluxUtil.withContext(context -> this.purgeDeletedKeyWithResponseAsync(vaultBaseUrl, keyName, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> purgeDeletedKeyWithResponseAsync(String vaultBaseUrl, String keyName, Context context) {
        String accept = "application/json";
        return this.service.purgeDeletedKey(vaultBaseUrl, keyName, this.getApiVersion(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> purgeDeletedKeyAsync(String vaultBaseUrl, String keyName) {
        return this.purgeDeletedKeyWithResponseAsync(vaultBaseUrl, keyName).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> purgeDeletedKeyAsync(String vaultBaseUrl, String keyName, Context context) {
        return this.purgeDeletedKeyWithResponseAsync(vaultBaseUrl, keyName, context).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> purgeDeletedKeyWithResponse(String vaultBaseUrl, String keyName, Context context) {
        String accept = "application/json";
        return this.service.purgeDeletedKeySync(vaultBaseUrl, keyName, this.getApiVersion(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void purgeDeletedKey(String vaultBaseUrl, String keyName) {
        this.purgeDeletedKeyWithResponse(vaultBaseUrl, keyName, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<KeyBundle>> recoverDeletedKeyWithResponseAsync(String vaultBaseUrl, String keyName) {
        return FluxUtil.withContext(context -> this.recoverDeletedKeyWithResponseAsync(vaultBaseUrl, keyName, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<KeyBundle>> recoverDeletedKeyWithResponseAsync(String vaultBaseUrl, String keyName, Context context) {
        String accept = "application/json";
        return this.service.recoverDeletedKey(vaultBaseUrl, keyName, this.getApiVersion(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<KeyBundle> recoverDeletedKeyAsync(String vaultBaseUrl, String keyName) {
        return this.recoverDeletedKeyWithResponseAsync(vaultBaseUrl, keyName).flatMap(res -> Mono.justOrEmpty((KeyBundle)res.getValue()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<KeyBundle> recoverDeletedKeyAsync(String vaultBaseUrl, String keyName, Context context) {
        return this.recoverDeletedKeyWithResponseAsync(vaultBaseUrl, keyName, context).flatMap(res -> Mono.justOrEmpty((KeyBundle)res.getValue()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<KeyBundle> recoverDeletedKeyWithResponse(String vaultBaseUrl, String keyName, Context context) {
        String accept = "application/json";
        return this.service.recoverDeletedKeySync(vaultBaseUrl, keyName, this.getApiVersion(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public KeyBundle recoverDeletedKey(String vaultBaseUrl, String keyName) {
        return this.recoverDeletedKeyWithResponse(vaultBaseUrl, keyName, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<KeyRotationPolicy>> getKeyRotationPolicyWithResponseAsync(String vaultBaseUrl, String keyName) {
        return FluxUtil.withContext(context -> this.getKeyRotationPolicyWithResponseAsync(vaultBaseUrl, keyName, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<KeyRotationPolicy>> getKeyRotationPolicyWithResponseAsync(String vaultBaseUrl, String keyName, Context context) {
        String accept = "application/json";
        return this.service.getKeyRotationPolicy(vaultBaseUrl, keyName, this.getApiVersion(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<KeyRotationPolicy> getKeyRotationPolicyAsync(String vaultBaseUrl, String keyName) {
        return this.getKeyRotationPolicyWithResponseAsync(vaultBaseUrl, keyName).flatMap(res -> Mono.justOrEmpty((KeyRotationPolicy)res.getValue()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<KeyRotationPolicy> getKeyRotationPolicyAsync(String vaultBaseUrl, String keyName, Context context) {
        return this.getKeyRotationPolicyWithResponseAsync(vaultBaseUrl, keyName, context).flatMap(res -> Mono.justOrEmpty((KeyRotationPolicy)res.getValue()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<KeyRotationPolicy> getKeyRotationPolicyWithResponse(String vaultBaseUrl, String keyName, Context context) {
        String accept = "application/json";
        return this.service.getKeyRotationPolicySync(vaultBaseUrl, keyName, this.getApiVersion(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public KeyRotationPolicy getKeyRotationPolicy(String vaultBaseUrl, String keyName) {
        return this.getKeyRotationPolicyWithResponse(vaultBaseUrl, keyName, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<KeyRotationPolicy>> updateKeyRotationPolicyWithResponseAsync(String vaultBaseUrl, String keyName, KeyRotationPolicy keyRotationPolicy) {
        return FluxUtil.withContext(context -> this.updateKeyRotationPolicyWithResponseAsync(vaultBaseUrl, keyName, keyRotationPolicy, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<KeyRotationPolicy>> updateKeyRotationPolicyWithResponseAsync(String vaultBaseUrl, String keyName, KeyRotationPolicy keyRotationPolicy, Context context) {
        String accept = "application/json";
        return this.service.updateKeyRotationPolicy(vaultBaseUrl, keyName, this.getApiVersion(), keyRotationPolicy, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<KeyRotationPolicy> updateKeyRotationPolicyAsync(String vaultBaseUrl, String keyName, KeyRotationPolicy keyRotationPolicy) {
        return this.updateKeyRotationPolicyWithResponseAsync(vaultBaseUrl, keyName, keyRotationPolicy).flatMap(res -> Mono.justOrEmpty((KeyRotationPolicy)res.getValue()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<KeyRotationPolicy> updateKeyRotationPolicyAsync(String vaultBaseUrl, String keyName, KeyRotationPolicy keyRotationPolicy, Context context) {
        return this.updateKeyRotationPolicyWithResponseAsync(vaultBaseUrl, keyName, keyRotationPolicy, context).flatMap(res -> Mono.justOrEmpty((KeyRotationPolicy)res.getValue()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<KeyRotationPolicy> updateKeyRotationPolicyWithResponse(String vaultBaseUrl, String keyName, KeyRotationPolicy keyRotationPolicy, Context context) {
        String accept = "application/json";
        return this.service.updateKeyRotationPolicySync(vaultBaseUrl, keyName, this.getApiVersion(), keyRotationPolicy, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public KeyRotationPolicy updateKeyRotationPolicy(String vaultBaseUrl, String keyName, KeyRotationPolicy keyRotationPolicy) {
        return this.updateKeyRotationPolicyWithResponse(vaultBaseUrl, keyName, keyRotationPolicy, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<RandomBytes>> getRandomBytesWithResponseAsync(String vaultBaseUrl, int count) {
        return FluxUtil.withContext(context -> this.getRandomBytesWithResponseAsync(vaultBaseUrl, count, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<RandomBytes>> getRandomBytesWithResponseAsync(String vaultBaseUrl, int count, Context context) {
        String accept = "application/json";
        GetRandomBytesRequest parameters = new GetRandomBytesRequest();
        parameters.setCount(count);
        return this.service.getRandomBytes(vaultBaseUrl, this.getApiVersion(), parameters, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<RandomBytes> getRandomBytesAsync(String vaultBaseUrl, int count) {
        return this.getRandomBytesWithResponseAsync(vaultBaseUrl, count).flatMap(res -> Mono.justOrEmpty((RandomBytes)res.getValue()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<RandomBytes> getRandomBytesAsync(String vaultBaseUrl, int count, Context context) {
        return this.getRandomBytesWithResponseAsync(vaultBaseUrl, count, context).flatMap(res -> Mono.justOrEmpty((RandomBytes)res.getValue()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<RandomBytes> getRandomBytesWithResponse(String vaultBaseUrl, int count, Context context) {
        String accept = "application/json";
        GetRandomBytesRequest parameters = new GetRandomBytesRequest();
        parameters.setCount(count);
        return this.service.getRandomBytesSync(vaultBaseUrl, this.getApiVersion(), parameters, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public RandomBytes getRandomBytes(String vaultBaseUrl, int count) {
        return this.getRandomBytesWithResponse(vaultBaseUrl, count, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<KeyItem>> getKeyVersionsNextSinglePageAsync(String nextLink, String vaultBaseUrl) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getKeyVersionsNext(nextLink, vaultBaseUrl, "application/json", (Context)context)).map(res -> new PagedResponseBase<Object, KeyItem>(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((KeyListResult)res.getValue()).getValue(), ((KeyListResult)res.getValue()).getNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<KeyItem>> getKeyVersionsNextSinglePageAsync(String nextLink, String vaultBaseUrl, Context context) {
        String accept = "application/json";
        return this.service.getKeyVersionsNext(nextLink, vaultBaseUrl, "application/json", context).map(res -> new PagedResponseBase<Object, KeyItem>(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((KeyListResult)res.getValue()).getValue(), ((KeyListResult)res.getValue()).getNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PagedResponse<KeyItem> getKeyVersionsNextSinglePage(String nextLink, String vaultBaseUrl) {
        String accept = "application/json";
        Response<KeyListResult> res = this.service.getKeyVersionsNextSync(nextLink, vaultBaseUrl, "application/json", Context.NONE);
        return new PagedResponseBase<Object, KeyItem>(res.getRequest(), res.getStatusCode(), res.getHeaders(), res.getValue().getValue(), res.getValue().getNextLink(), null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PagedResponse<KeyItem> getKeyVersionsNextSinglePage(String nextLink, String vaultBaseUrl, Context context) {
        String accept = "application/json";
        Response<KeyListResult> res = this.service.getKeyVersionsNextSync(nextLink, vaultBaseUrl, "application/json", context);
        return new PagedResponseBase<Object, KeyItem>(res.getRequest(), res.getStatusCode(), res.getHeaders(), res.getValue().getValue(), res.getValue().getNextLink(), null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<KeyItem>> getKeysNextSinglePageAsync(String nextLink, String vaultBaseUrl) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getKeysNext(nextLink, vaultBaseUrl, "application/json", (Context)context)).map(res -> new PagedResponseBase<Object, KeyItem>(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((KeyListResult)res.getValue()).getValue(), ((KeyListResult)res.getValue()).getNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<KeyItem>> getKeysNextSinglePageAsync(String nextLink, String vaultBaseUrl, Context context) {
        String accept = "application/json";
        return this.service.getKeysNext(nextLink, vaultBaseUrl, "application/json", context).map(res -> new PagedResponseBase<Object, KeyItem>(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((KeyListResult)res.getValue()).getValue(), ((KeyListResult)res.getValue()).getNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PagedResponse<KeyItem> getKeysNextSinglePage(String nextLink, String vaultBaseUrl) {
        String accept = "application/json";
        Response<KeyListResult> res = this.service.getKeysNextSync(nextLink, vaultBaseUrl, "application/json", Context.NONE);
        return new PagedResponseBase<Object, KeyItem>(res.getRequest(), res.getStatusCode(), res.getHeaders(), res.getValue().getValue(), res.getValue().getNextLink(), null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PagedResponse<KeyItem> getKeysNextSinglePage(String nextLink, String vaultBaseUrl, Context context) {
        String accept = "application/json";
        Response<KeyListResult> res = this.service.getKeysNextSync(nextLink, vaultBaseUrl, "application/json", context);
        return new PagedResponseBase<Object, KeyItem>(res.getRequest(), res.getStatusCode(), res.getHeaders(), res.getValue().getValue(), res.getValue().getNextLink(), null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<DeletedKeyItem>> getDeletedKeysNextSinglePageAsync(String nextLink, String vaultBaseUrl) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getDeletedKeysNext(nextLink, vaultBaseUrl, "application/json", (Context)context)).map(res -> new PagedResponseBase<Object, DeletedKeyItem>(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DeletedKeyListResult)res.getValue()).getValue(), ((DeletedKeyListResult)res.getValue()).getNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<DeletedKeyItem>> getDeletedKeysNextSinglePageAsync(String nextLink, String vaultBaseUrl, Context context) {
        String accept = "application/json";
        return this.service.getDeletedKeysNext(nextLink, vaultBaseUrl, "application/json", context).map(res -> new PagedResponseBase<Object, DeletedKeyItem>(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DeletedKeyListResult)res.getValue()).getValue(), ((DeletedKeyListResult)res.getValue()).getNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PagedResponse<DeletedKeyItem> getDeletedKeysNextSinglePage(String nextLink, String vaultBaseUrl) {
        String accept = "application/json";
        Response<DeletedKeyListResult> res = this.service.getDeletedKeysNextSync(nextLink, vaultBaseUrl, "application/json", Context.NONE);
        return new PagedResponseBase<Object, DeletedKeyItem>(res.getRequest(), res.getStatusCode(), res.getHeaders(), res.getValue().getValue(), res.getValue().getNextLink(), null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PagedResponse<DeletedKeyItem> getDeletedKeysNextSinglePage(String nextLink, String vaultBaseUrl, Context context) {
        String accept = "application/json";
        Response<DeletedKeyListResult> res = this.service.getDeletedKeysNextSync(nextLink, vaultBaseUrl, "application/json", context);
        return new PagedResponseBase<Object, DeletedKeyItem>(res.getRequest(), res.getStatusCode(), res.getHeaders(), res.getValue().getValue(), res.getValue().getNextLink(), null);
    }

    @Host(value="{vaultBaseUrl}")
    @ServiceInterface(name="KeyClient")
    public static interface KeyClientService {
        @Post(value="/keys/{key-name}/create")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=KeyVaultErrorException.class)
        public Mono<Response<KeyBundle>> createKey(@HostParam(value="vaultBaseUrl") String var1, @PathParam(value="key-name") String var2, @QueryParam(value="api-version") String var3, @BodyParam(value="application/json") KeyCreateParameters var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Post(value="/keys/{key-name}/create")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=KeyVaultErrorException.class)
        public Response<KeyBundle> createKeySync(@HostParam(value="vaultBaseUrl") String var1, @PathParam(value="key-name") String var2, @QueryParam(value="api-version") String var3, @BodyParam(value="application/json") KeyCreateParameters var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Post(value="/keys/{key-name}/rotate")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=KeyVaultErrorException.class)
        public Mono<Response<KeyBundle>> rotateKey(@HostParam(value="vaultBaseUrl") String var1, @PathParam(value="key-name") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Post(value="/keys/{key-name}/rotate")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=KeyVaultErrorException.class)
        public Response<KeyBundle> rotateKeySync(@HostParam(value="vaultBaseUrl") String var1, @PathParam(value="key-name") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Put(value="/keys/{key-name}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=KeyVaultErrorException.class)
        public Mono<Response<KeyBundle>> importKey(@HostParam(value="vaultBaseUrl") String var1, @PathParam(value="key-name") String var2, @QueryParam(value="api-version") String var3, @BodyParam(value="application/json") KeyImportParameters var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Put(value="/keys/{key-name}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=KeyVaultErrorException.class)
        public Response<KeyBundle> importKeySync(@HostParam(value="vaultBaseUrl") String var1, @PathParam(value="key-name") String var2, @QueryParam(value="api-version") String var3, @BodyParam(value="application/json") KeyImportParameters var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Delete(value="/keys/{key-name}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=KeyVaultErrorException.class)
        public Mono<Response<DeletedKeyBundle>> deleteKey(@HostParam(value="vaultBaseUrl") String var1, @PathParam(value="key-name") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Delete(value="/keys/{key-name}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=KeyVaultErrorException.class)
        public Response<DeletedKeyBundle> deleteKeySync(@HostParam(value="vaultBaseUrl") String var1, @PathParam(value="key-name") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Patch(value="/keys/{key-name}/{key-version}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=KeyVaultErrorException.class)
        public Mono<Response<KeyBundle>> updateKey(@HostParam(value="vaultBaseUrl") String var1, @PathParam(value="key-name") String var2, @PathParam(value="key-version") String var3, @QueryParam(value="api-version") String var4, @BodyParam(value="application/json") KeyUpdateParameters var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Patch(value="/keys/{key-name}/{key-version}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=KeyVaultErrorException.class)
        public Response<KeyBundle> updateKeySync(@HostParam(value="vaultBaseUrl") String var1, @PathParam(value="key-name") String var2, @PathParam(value="key-version") String var3, @QueryParam(value="api-version") String var4, @BodyParam(value="application/json") KeyUpdateParameters var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Get(value="/keys/{key-name}/{key-version}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=KeyVaultErrorException.class)
        public Mono<Response<KeyBundle>> getKey(@HostParam(value="vaultBaseUrl") String var1, @PathParam(value="key-name") String var2, @PathParam(value="key-version") String var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Get(value="/keys/{key-name}/{key-version}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=KeyVaultErrorException.class)
        public Response<KeyBundle> getKeySync(@HostParam(value="vaultBaseUrl") String var1, @PathParam(value="key-name") String var2, @PathParam(value="key-version") String var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Get(value="/keys/{key-name}/versions")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=KeyVaultErrorException.class)
        public Mono<Response<KeyListResult>> getKeyVersions(@HostParam(value="vaultBaseUrl") String var1, @PathParam(value="key-name") String var2, @QueryParam(value="maxresults") Integer var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Get(value="/keys/{key-name}/versions")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=KeyVaultErrorException.class)
        public Response<KeyListResult> getKeyVersionsSync(@HostParam(value="vaultBaseUrl") String var1, @PathParam(value="key-name") String var2, @QueryParam(value="maxresults") Integer var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Get(value="/keys")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=KeyVaultErrorException.class)
        public Mono<Response<KeyListResult>> getKeys(@HostParam(value="vaultBaseUrl") String var1, @QueryParam(value="maxresults") Integer var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Get(value="/keys")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=KeyVaultErrorException.class)
        public Response<KeyListResult> getKeysSync(@HostParam(value="vaultBaseUrl") String var1, @QueryParam(value="maxresults") Integer var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Post(value="/keys/{key-name}/backup")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=KeyVaultErrorException.class)
        public Mono<Response<BackupKeyResult>> backupKey(@HostParam(value="vaultBaseUrl") String var1, @PathParam(value="key-name") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Post(value="/keys/{key-name}/backup")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=KeyVaultErrorException.class)
        public Response<BackupKeyResult> backupKeySync(@HostParam(value="vaultBaseUrl") String var1, @PathParam(value="key-name") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Post(value="/keys/restore")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=KeyVaultErrorException.class)
        public Mono<Response<KeyBundle>> restoreKey(@HostParam(value="vaultBaseUrl") String var1, @QueryParam(value="api-version") String var2, @BodyParam(value="application/json") KeyRestoreParameters var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Post(value="/keys/restore")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=KeyVaultErrorException.class)
        public Response<KeyBundle> restoreKeySync(@HostParam(value="vaultBaseUrl") String var1, @QueryParam(value="api-version") String var2, @BodyParam(value="application/json") KeyRestoreParameters var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Post(value="/keys/{key-name}/{key-version}/encrypt")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=KeyVaultErrorException.class)
        public Mono<Response<KeyOperationResult>> encrypt(@HostParam(value="vaultBaseUrl") String var1, @PathParam(value="key-name") String var2, @PathParam(value="key-version") String var3, @QueryParam(value="api-version") String var4, @BodyParam(value="application/json") KeyOperationsParameters var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Post(value="/keys/{key-name}/{key-version}/encrypt")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=KeyVaultErrorException.class)
        public Response<KeyOperationResult> encryptSync(@HostParam(value="vaultBaseUrl") String var1, @PathParam(value="key-name") String var2, @PathParam(value="key-version") String var3, @QueryParam(value="api-version") String var4, @BodyParam(value="application/json") KeyOperationsParameters var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Post(value="/keys/{key-name}/{key-version}/decrypt")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=KeyVaultErrorException.class)
        public Mono<Response<KeyOperationResult>> decrypt(@HostParam(value="vaultBaseUrl") String var1, @PathParam(value="key-name") String var2, @PathParam(value="key-version") String var3, @QueryParam(value="api-version") String var4, @BodyParam(value="application/json") KeyOperationsParameters var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Post(value="/keys/{key-name}/{key-version}/decrypt")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=KeyVaultErrorException.class)
        public Response<KeyOperationResult> decryptSync(@HostParam(value="vaultBaseUrl") String var1, @PathParam(value="key-name") String var2, @PathParam(value="key-version") String var3, @QueryParam(value="api-version") String var4, @BodyParam(value="application/json") KeyOperationsParameters var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Post(value="/keys/{key-name}/{key-version}/sign")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=KeyVaultErrorException.class)
        public Mono<Response<KeyOperationResult>> sign(@HostParam(value="vaultBaseUrl") String var1, @PathParam(value="key-name") String var2, @PathParam(value="key-version") String var3, @QueryParam(value="api-version") String var4, @BodyParam(value="application/json") KeySignParameters var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Post(value="/keys/{key-name}/{key-version}/sign")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=KeyVaultErrorException.class)
        public Response<KeyOperationResult> signSync(@HostParam(value="vaultBaseUrl") String var1, @PathParam(value="key-name") String var2, @PathParam(value="key-version") String var3, @QueryParam(value="api-version") String var4, @BodyParam(value="application/json") KeySignParameters var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Post(value="/keys/{key-name}/{key-version}/verify")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=KeyVaultErrorException.class)
        public Mono<Response<KeyVerifyResult>> verify(@HostParam(value="vaultBaseUrl") String var1, @PathParam(value="key-name") String var2, @PathParam(value="key-version") String var3, @QueryParam(value="api-version") String var4, @BodyParam(value="application/json") KeyVerifyParameters var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Post(value="/keys/{key-name}/{key-version}/verify")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=KeyVaultErrorException.class)
        public Response<KeyVerifyResult> verifySync(@HostParam(value="vaultBaseUrl") String var1, @PathParam(value="key-name") String var2, @PathParam(value="key-version") String var3, @QueryParam(value="api-version") String var4, @BodyParam(value="application/json") KeyVerifyParameters var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Post(value="/keys/{key-name}/{key-version}/wrapkey")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=KeyVaultErrorException.class)
        public Mono<Response<KeyOperationResult>> wrapKey(@HostParam(value="vaultBaseUrl") String var1, @PathParam(value="key-name") String var2, @PathParam(value="key-version") String var3, @QueryParam(value="api-version") String var4, @BodyParam(value="application/json") KeyOperationsParameters var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Post(value="/keys/{key-name}/{key-version}/wrapkey")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=KeyVaultErrorException.class)
        public Response<KeyOperationResult> wrapKeySync(@HostParam(value="vaultBaseUrl") String var1, @PathParam(value="key-name") String var2, @PathParam(value="key-version") String var3, @QueryParam(value="api-version") String var4, @BodyParam(value="application/json") KeyOperationsParameters var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Post(value="/keys/{key-name}/{key-version}/unwrapkey")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=KeyVaultErrorException.class)
        public Mono<Response<KeyOperationResult>> unwrapKey(@HostParam(value="vaultBaseUrl") String var1, @PathParam(value="key-name") String var2, @PathParam(value="key-version") String var3, @QueryParam(value="api-version") String var4, @BodyParam(value="application/json") KeyOperationsParameters var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Post(value="/keys/{key-name}/{key-version}/unwrapkey")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=KeyVaultErrorException.class)
        public Response<KeyOperationResult> unwrapKeySync(@HostParam(value="vaultBaseUrl") String var1, @PathParam(value="key-name") String var2, @PathParam(value="key-version") String var3, @QueryParam(value="api-version") String var4, @BodyParam(value="application/json") KeyOperationsParameters var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Post(value="/keys/{key-name}/{key-version}/release")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=KeyVaultErrorException.class)
        public Mono<Response<ReleaseKeyResult>> release(@HostParam(value="vaultBaseUrl") String var1, @PathParam(value="key-name") String var2, @PathParam(value="key-version") String var3, @QueryParam(value="api-version") String var4, @BodyParam(value="application/json") KeyReleaseParameters var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Post(value="/keys/{key-name}/{key-version}/release")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=KeyVaultErrorException.class)
        public Response<ReleaseKeyResult> releaseSync(@HostParam(value="vaultBaseUrl") String var1, @PathParam(value="key-name") String var2, @PathParam(value="key-version") String var3, @QueryParam(value="api-version") String var4, @BodyParam(value="application/json") KeyReleaseParameters var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Get(value="/deletedkeys")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=KeyVaultErrorException.class)
        public Mono<Response<DeletedKeyListResult>> getDeletedKeys(@HostParam(value="vaultBaseUrl") String var1, @QueryParam(value="maxresults") Integer var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Get(value="/deletedkeys")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=KeyVaultErrorException.class)
        public Response<DeletedKeyListResult> getDeletedKeysSync(@HostParam(value="vaultBaseUrl") String var1, @QueryParam(value="maxresults") Integer var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Get(value="/deletedkeys/{key-name}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=KeyVaultErrorException.class)
        public Mono<Response<DeletedKeyBundle>> getDeletedKey(@HostParam(value="vaultBaseUrl") String var1, @PathParam(value="key-name") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Get(value="/deletedkeys/{key-name}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=KeyVaultErrorException.class)
        public Response<DeletedKeyBundle> getDeletedKeySync(@HostParam(value="vaultBaseUrl") String var1, @PathParam(value="key-name") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Delete(value="/deletedkeys/{key-name}")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=KeyVaultErrorException.class)
        public Mono<Response<Void>> purgeDeletedKey(@HostParam(value="vaultBaseUrl") String var1, @PathParam(value="key-name") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Delete(value="/deletedkeys/{key-name}")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=KeyVaultErrorException.class)
        public Response<Void> purgeDeletedKeySync(@HostParam(value="vaultBaseUrl") String var1, @PathParam(value="key-name") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Post(value="/deletedkeys/{key-name}/recover")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=KeyVaultErrorException.class)
        public Mono<Response<KeyBundle>> recoverDeletedKey(@HostParam(value="vaultBaseUrl") String var1, @PathParam(value="key-name") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Post(value="/deletedkeys/{key-name}/recover")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=KeyVaultErrorException.class)
        public Response<KeyBundle> recoverDeletedKeySync(@HostParam(value="vaultBaseUrl") String var1, @PathParam(value="key-name") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Get(value="/keys/{key-name}/rotationpolicy")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=KeyVaultErrorException.class)
        public Mono<Response<KeyRotationPolicy>> getKeyRotationPolicy(@HostParam(value="vaultBaseUrl") String var1, @PathParam(value="key-name") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Get(value="/keys/{key-name}/rotationpolicy")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=KeyVaultErrorException.class)
        public Response<KeyRotationPolicy> getKeyRotationPolicySync(@HostParam(value="vaultBaseUrl") String var1, @PathParam(value="key-name") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Put(value="/keys/{key-name}/rotationpolicy")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=KeyVaultErrorException.class)
        public Mono<Response<KeyRotationPolicy>> updateKeyRotationPolicy(@HostParam(value="vaultBaseUrl") String var1, @PathParam(value="key-name") String var2, @QueryParam(value="api-version") String var3, @BodyParam(value="application/json") KeyRotationPolicy var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Put(value="/keys/{key-name}/rotationpolicy")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=KeyVaultErrorException.class)
        public Response<KeyRotationPolicy> updateKeyRotationPolicySync(@HostParam(value="vaultBaseUrl") String var1, @PathParam(value="key-name") String var2, @QueryParam(value="api-version") String var3, @BodyParam(value="application/json") KeyRotationPolicy var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Post(value="/rng")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=KeyVaultErrorException.class)
        public Mono<Response<RandomBytes>> getRandomBytes(@HostParam(value="vaultBaseUrl") String var1, @QueryParam(value="api-version") String var2, @BodyParam(value="application/json") GetRandomBytesRequest var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Post(value="/rng")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=KeyVaultErrorException.class)
        public Response<RandomBytes> getRandomBytesSync(@HostParam(value="vaultBaseUrl") String var1, @QueryParam(value="api-version") String var2, @BodyParam(value="application/json") GetRandomBytesRequest var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=KeyVaultErrorException.class)
        public Mono<Response<KeyListResult>> getKeyVersionsNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="vaultBaseUrl") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=KeyVaultErrorException.class)
        public Response<KeyListResult> getKeyVersionsNextSync(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="vaultBaseUrl") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=KeyVaultErrorException.class)
        public Mono<Response<KeyListResult>> getKeysNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="vaultBaseUrl") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=KeyVaultErrorException.class)
        public Response<KeyListResult> getKeysNextSync(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="vaultBaseUrl") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=KeyVaultErrorException.class)
        public Mono<Response<DeletedKeyListResult>> getDeletedKeysNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="vaultBaseUrl") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=KeyVaultErrorException.class)
        public Response<DeletedKeyListResult> getDeletedKeysNextSync(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="vaultBaseUrl") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

