/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.security.keyvault.keys.implementation.models;

import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.security.keyvault.keys.implementation.models.KeyAttributes;
import com.dataiku.dss.shadelibazure.com.azure.security.keyvault.keys.implementation.models.KeyItem;
import java.io.IOException;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.Map;

public final class DeletedKeyItem
extends KeyItem {
    private String recoveryId;
    private Long scheduledPurgeDate;
    private Long deletedDate;
    private Boolean managed;

    public String getRecoveryId() {
        return this.recoveryId;
    }

    public DeletedKeyItem setRecoveryId(String recoveryId) {
        this.recoveryId = recoveryId;
        return this;
    }

    public OffsetDateTime getScheduledPurgeDate() {
        if (this.scheduledPurgeDate == null) {
            return null;
        }
        return OffsetDateTime.ofInstant(Instant.ofEpochSecond(this.scheduledPurgeDate), ZoneOffset.UTC);
    }

    public OffsetDateTime getDeletedDate() {
        if (this.deletedDate == null) {
            return null;
        }
        return OffsetDateTime.ofInstant(Instant.ofEpochSecond(this.deletedDate), ZoneOffset.UTC);
    }

    @Override
    public Boolean isManaged() {
        return this.managed;
    }

    @Override
    public DeletedKeyItem setKid(String kid) {
        super.setKid(kid);
        return this;
    }

    @Override
    public DeletedKeyItem setAttributes(KeyAttributes attributes) {
        super.setAttributes(attributes);
        return this;
    }

    @Override
    public DeletedKeyItem setTags(Map<String, String> tags) {
        super.setTags(tags);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("kid", this.getKid());
        jsonWriter.writeJsonField("attributes", this.getAttributes());
        jsonWriter.writeMapField("tags", this.getTags(), (writer, element) -> writer.writeString((String)element));
        jsonWriter.writeStringField("recoveryId", this.recoveryId);
        return jsonWriter.writeEndObject();
    }

    public static DeletedKeyItem fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            DeletedKeyItem deserializedDeletedKeyItem = new DeletedKeyItem();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("kid".equals(fieldName)) {
                    deserializedDeletedKeyItem.setKid(reader.getString());
                    continue;
                }
                if ("attributes".equals(fieldName)) {
                    deserializedDeletedKeyItem.setAttributes(KeyAttributes.fromJson(reader));
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map<String, String> tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedDeletedKeyItem.setTags((Map)tags);
                    continue;
                }
                if ("managed".equals(fieldName)) {
                    deserializedDeletedKeyItem.managed = reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("recoveryId".equals(fieldName)) {
                    deserializedDeletedKeyItem.recoveryId = reader.getString();
                    continue;
                }
                if ("scheduledPurgeDate".equals(fieldName)) {
                    deserializedDeletedKeyItem.scheduledPurgeDate = reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("deletedDate".equals(fieldName)) {
                    deserializedDeletedKeyItem.deletedDate = reader.getNullable(JsonReader::getLong);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDeletedKeyItem;
        });
    }
}

