/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.security.keyvault.keys.implementation.models;

import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.security.keyvault.keys.implementation.models.Attributes;
import com.dataiku.dss.shadelibazure.com.azure.security.keyvault.keys.implementation.models.DeletionRecoveryLevel;
import java.io.IOException;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;

public final class KeyAttributes
extends Attributes {
    private Integer recoverableDays;
    private DeletionRecoveryLevel recoveryLevel;
    private Boolean exportable;
    private String hsmPlatform;
    private Long updated;
    private Long created;

    public Integer getRecoverableDays() {
        return this.recoverableDays;
    }

    public DeletionRecoveryLevel getRecoveryLevel() {
        return this.recoveryLevel;
    }

    public Boolean isExportable() {
        return this.exportable;
    }

    public KeyAttributes setExportable(Boolean exportable) {
        this.exportable = exportable;
        return this;
    }

    public String getHsmPlatform() {
        return this.hsmPlatform;
    }

    @Override
    public OffsetDateTime getUpdated() {
        if (this.updated == null) {
            return null;
        }
        return OffsetDateTime.ofInstant(Instant.ofEpochSecond(this.updated), ZoneOffset.UTC);
    }

    @Override
    public OffsetDateTime getCreated() {
        if (this.created == null) {
            return null;
        }
        return OffsetDateTime.ofInstant(Instant.ofEpochSecond(this.created), ZoneOffset.UTC);
    }

    @Override
    public KeyAttributes setEnabled(Boolean enabled) {
        super.setEnabled(enabled);
        return this;
    }

    @Override
    public KeyAttributes setNotBefore(OffsetDateTime notBefore) {
        super.setNotBefore(notBefore);
        return this;
    }

    @Override
    public KeyAttributes setExpires(OffsetDateTime expires) {
        super.setExpires(expires);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBooleanField("enabled", this.isEnabled());
        if (this.getNotBefore() != null) {
            jsonWriter.writeNumberField("nbf", this.getNotBefore().toEpochSecond());
        }
        if (this.getExpires() != null) {
            jsonWriter.writeNumberField("exp", this.getExpires().toEpochSecond());
        }
        jsonWriter.writeBooleanField("exportable", this.exportable);
        return jsonWriter.writeEndObject();
    }

    public static KeyAttributes fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            KeyAttributes deserializedKeyAttributes = new KeyAttributes();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("enabled".equals(fieldName)) {
                    deserializedKeyAttributes.setEnabled(reader.getNullable(JsonReader::getBoolean));
                    continue;
                }
                if ("nbf".equals(fieldName)) {
                    Long notBeforeHolder = reader.getNullable(JsonReader::getLong);
                    if (notBeforeHolder == null) continue;
                    deserializedKeyAttributes.setNotBefore(OffsetDateTime.ofInstant(Instant.ofEpochSecond(notBeforeHolder), ZoneOffset.UTC));
                    continue;
                }
                if ("exp".equals(fieldName)) {
                    Long expiresHolder = reader.getNullable(JsonReader::getLong);
                    if (expiresHolder == null) continue;
                    deserializedKeyAttributes.setExpires(OffsetDateTime.ofInstant(Instant.ofEpochSecond(expiresHolder), ZoneOffset.UTC));
                    continue;
                }
                if ("created".equals(fieldName)) {
                    deserializedKeyAttributes.created = reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("updated".equals(fieldName)) {
                    deserializedKeyAttributes.updated = reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("recoverableDays".equals(fieldName)) {
                    deserializedKeyAttributes.recoverableDays = reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("recoveryLevel".equals(fieldName)) {
                    deserializedKeyAttributes.recoveryLevel = DeletionRecoveryLevel.fromString(reader.getString());
                    continue;
                }
                if ("exportable".equals(fieldName)) {
                    deserializedKeyAttributes.exportable = reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("hsmPlatform".equals(fieldName)) {
                    deserializedKeyAttributes.hsmPlatform = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedKeyAttributes;
        });
    }
}

