/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.security.keyvault.secrets.implementation;

import com.dataiku.dss.shadelibazure.com.azure.core.credential.TokenCredential;
import com.dataiku.dss.shadelibazure.com.azure.core.credential.TokenRequestContext;
import com.dataiku.dss.shadelibazure.com.azure.core.http.HttpHeaderName;
import com.dataiku.dss.shadelibazure.com.azure.core.http.HttpPipelineCallContext;
import com.dataiku.dss.shadelibazure.com.azure.core.http.HttpPipelineNextPolicy;
import com.dataiku.dss.shadelibazure.com.azure.core.http.HttpPipelineNextSyncPolicy;
import com.dataiku.dss.shadelibazure.com.azure.core.http.HttpRequest;
import com.dataiku.dss.shadelibazure.com.azure.core.http.HttpResponse;
import com.dataiku.dss.shadelibazure.com.azure.core.http.policy.BearerTokenAuthenticationPolicy;
import com.dataiku.dss.shadelibazure.com.azure.core.util.Base64Util;
import com.dataiku.dss.shadelibazure.com.azure.core.util.BinaryData;
import com.dataiku.dss.shadelibazure.com.azure.core.util.CoreUtils;
import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Flux;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Mono;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class KeyVaultCredentialPolicy
extends BearerTokenAuthenticationPolicy {
    private static final ClientLogger LOGGER = new ClientLogger(KeyVaultCredentialPolicy.class);
    private static final String BEARER_TOKEN_PREFIX = "Bearer ";
    private static final String KEY_VAULT_STASHED_CONTENT_KEY = "KeyVaultCredentialPolicyStashedBody";
    private static final String KEY_VAULT_STASHED_CONTENT_LENGTH_KEY = "KeyVaultCredentialPolicyStashedContentLength";
    private static final ConcurrentMap<String, ChallengeParameters> CHALLENGE_CACHE = new ConcurrentHashMap<String, ChallengeParameters>();
    private ChallengeParameters challenge;
    private final boolean disableChallengeResourceVerification;

    public KeyVaultCredentialPolicy(TokenCredential credential, boolean disableChallengeResourceVerification) {
        super(credential, new String[0]);
        this.disableChallengeResourceVerification = disableChallengeResourceVerification;
    }

    private static Map<String, String> extractChallengeAttributes(String authenticateHeader, String authChallengePrefix) {
        if (!KeyVaultCredentialPolicy.isBearerChallenge(authenticateHeader, authChallengePrefix)) {
            return Collections.emptyMap();
        }
        String[] attributes = authenticateHeader.replace("\"", "").substring(authChallengePrefix.length()).split(",");
        HashMap<String, String> attributeMap = new HashMap<String, String>();
        for (String pair : attributes) {
            String[] keyValue = pair.trim().split("=", 2);
            attributeMap.put(keyValue[0], keyValue[1]);
        }
        return attributeMap;
    }

    private static boolean isBearerChallenge(String authenticateHeader, String authChallengePrefix) {
        return !CoreUtils.isNullOrEmpty(authenticateHeader) && authenticateHeader.toLowerCase(Locale.ROOT).startsWith(authChallengePrefix.toLowerCase(Locale.ROOT));
    }

    @Override
    public Mono<Void> authorizeRequest(HttpPipelineCallContext context) {
        return Mono.defer(() -> {
            HttpRequest request = context.getHttpRequest();
            if (this.challenge == null) {
                this.challenge = (ChallengeParameters)CHALLENGE_CACHE.get(KeyVaultCredentialPolicy.getRequestAuthority(request));
            }
            if (this.challenge != null) {
                TokenRequestContext tokenRequestContext = new TokenRequestContext().addScopes(this.challenge.getScopes()).setTenantId(this.challenge.getTenantId()).setCaeEnabled(true);
                return this.setAuthorizationHeader(context, tokenRequestContext);
            }
            if (!context.getData(KEY_VAULT_STASHED_CONTENT_KEY).isPresent() && request.getBody() != null) {
                context.setData(KEY_VAULT_STASHED_CONTENT_KEY, request.getBody());
                context.setData(KEY_VAULT_STASHED_CONTENT_LENGTH_KEY, request.getHeaders().getValue(HttpHeaderName.CONTENT_LENGTH));
                request.setHeader(HttpHeaderName.CONTENT_LENGTH, "0");
                request.setBody((Flux<ByteBuffer>)null);
            }
            return Mono.empty();
        });
    }

    @Override
    public Mono<Boolean> authorizeRequestOnChallenge(HttpPipelineCallContext context, HttpResponse response) {
        return Mono.defer(() -> {
            HttpRequest request = context.getHttpRequest();
            Optional<Object> contentOptional = context.getData(KEY_VAULT_STASHED_CONTENT_KEY);
            Optional<Object> contentLengthOptional = context.getData(KEY_VAULT_STASHED_CONTENT_LENGTH_KEY);
            if (request.getBody() == null && contentOptional.isPresent() && contentLengthOptional.isPresent()) {
                request.setBody((Flux)contentOptional.get());
                request.setHeader(HttpHeaderName.CONTENT_LENGTH, (String)contentLengthOptional.get());
            }
            String authority = KeyVaultCredentialPolicy.getRequestAuthority(request);
            Map<String, String> challengeAttributes = KeyVaultCredentialPolicy.extractChallengeAttributes(response.getHeaderValue(HttpHeaderName.WWW_AUTHENTICATE), BEARER_TOKEN_PREFIX);
            String scope = challengeAttributes.get("resource");
            scope = scope != null ? scope + "/.default" : challengeAttributes.get("scope");
            if (scope == null) {
                this.challenge = (ChallengeParameters)CHALLENGE_CACHE.get(authority);
                if (this.challenge == null) {
                    return Mono.just(false);
                }
            } else {
                URI authorizationUri;
                if (!this.disableChallengeResourceVerification && !KeyVaultCredentialPolicy.isChallengeResourceValid(request, scope)) {
                    throw LOGGER.logExceptionAsError(new RuntimeException(String.format("The challenge resource '%s' does not match the requested domain. If you wish to disable this check for your client, pass 'true' to the SecretClientBuilder.disableChallengeResourceVerification() method when building it. See https://aka.ms/azsdk/blog/vault-uri for more information.", scope)));
                }
                String authorization = challengeAttributes.get("authorization");
                if (authorization == null) {
                    authorization = challengeAttributes.get("authorization_uri");
                }
                try {
                    authorizationUri = new URI(authorization);
                }
                catch (URISyntaxException e) {
                    throw LOGGER.logExceptionAsError(new RuntimeException(String.format("The challenge authorization URI '%s' is invalid.", authorization), e));
                }
                this.challenge = new ChallengeParameters(authorizationUri, new String[]{scope});
                CHALLENGE_CACHE.put(authority, this.challenge);
            }
            TokenRequestContext tokenRequestContext = new TokenRequestContext().addScopes(this.challenge.getScopes()).setTenantId(this.challenge.getTenantId()).setCaeEnabled(true);
            String error = challengeAttributes.get("error");
            if (error != null) {
                String claims;
                LOGGER.verbose("The challenge response contained an error: {}", error);
                if ("insufficient_claims".equalsIgnoreCase(error) && (claims = challengeAttributes.get("claims")) != null) {
                    tokenRequestContext.setClaims(new String(Base64Util.decodeString(claims), StandardCharsets.UTF_8));
                }
            }
            return this.setAuthorizationHeader(context, tokenRequestContext).then(Mono.just(true));
        });
    }

    @Override
    public void authorizeRequestSync(HttpPipelineCallContext context) {
        HttpRequest request = context.getHttpRequest();
        if (this.challenge == null) {
            this.challenge = (ChallengeParameters)CHALLENGE_CACHE.get(KeyVaultCredentialPolicy.getRequestAuthority(request));
        }
        if (this.challenge != null) {
            TokenRequestContext tokenRequestContext = new TokenRequestContext().addScopes(this.challenge.getScopes()).setTenantId(this.challenge.getTenantId()).setCaeEnabled(true);
            this.setAuthorizationHeaderSync(context, tokenRequestContext);
            return;
        }
        if (!context.getData(KEY_VAULT_STASHED_CONTENT_KEY).isPresent() && request.getBodyAsBinaryData() != null) {
            context.setData(KEY_VAULT_STASHED_CONTENT_KEY, request.getBodyAsBinaryData());
            context.setData(KEY_VAULT_STASHED_CONTENT_LENGTH_KEY, request.getHeaders().getValue(HttpHeaderName.CONTENT_LENGTH));
            request.setHeader(HttpHeaderName.CONTENT_LENGTH, "0");
            request.setBody((BinaryData)null);
        }
    }

    @Override
    public boolean authorizeRequestOnChallengeSync(HttpPipelineCallContext context, HttpResponse response) {
        HttpRequest request = context.getHttpRequest();
        Optional<Object> contentOptional = context.getData(KEY_VAULT_STASHED_CONTENT_KEY);
        Optional<Object> contentLengthOptional = context.getData(KEY_VAULT_STASHED_CONTENT_LENGTH_KEY);
        if (request.getBody() == null && contentOptional.isPresent() && contentLengthOptional.isPresent()) {
            request.setBody((BinaryData)contentOptional.get());
            request.setHeader(HttpHeaderName.CONTENT_LENGTH, (String)contentLengthOptional.get());
        }
        String authority = KeyVaultCredentialPolicy.getRequestAuthority(request);
        Map<String, String> challengeAttributes = KeyVaultCredentialPolicy.extractChallengeAttributes(response.getHeaderValue(HttpHeaderName.WWW_AUTHENTICATE), BEARER_TOKEN_PREFIX);
        String scope = challengeAttributes.get("resource");
        scope = scope != null ? scope + "/.default" : challengeAttributes.get("scope");
        if (scope == null) {
            this.challenge = (ChallengeParameters)CHALLENGE_CACHE.get(authority);
            if (this.challenge == null) {
                return false;
            }
        } else {
            URI authorizationUri;
            if (!this.disableChallengeResourceVerification && !KeyVaultCredentialPolicy.isChallengeResourceValid(request, scope)) {
                throw LOGGER.logExceptionAsError(new RuntimeException(String.format("The challenge resource '%s' does not match the requested domain. If you wish to disable this check for your client, pass 'true' to the SecretClientBuilder.disableChallengeResourceVerification() method when building it. See https://aka.ms/azsdk/blog/vault-uri for more information.", scope)));
            }
            String authorization = challengeAttributes.get("authorization");
            if (authorization == null) {
                authorization = challengeAttributes.get("authorization_uri");
            }
            try {
                authorizationUri = new URI(authorization);
            }
            catch (URISyntaxException e) {
                throw LOGGER.logExceptionAsError(new RuntimeException(String.format("The challenge authorization URI '%s' is invalid.", authorization), e));
            }
            this.challenge = new ChallengeParameters(authorizationUri, new String[]{scope});
            CHALLENGE_CACHE.put(authority, this.challenge);
        }
        TokenRequestContext tokenRequestContext = new TokenRequestContext().addScopes(this.challenge.getScopes()).setTenantId(this.challenge.getTenantId()).setCaeEnabled(true);
        String error = challengeAttributes.get("error");
        if (error != null) {
            String claims;
            LOGGER.verbose("The challenge response contained an error: {}", error);
            if ("insufficient_claims".equalsIgnoreCase(error) && (claims = challengeAttributes.get("claims")) != null) {
                tokenRequestContext.setClaims(new String(Base64Util.decodeString(claims)));
            }
        }
        this.setAuthorizationHeaderSync(context, tokenRequestContext);
        return true;
    }

    @Override
    public Mono<HttpResponse> process(HttpPipelineCallContext context, HttpPipelineNextPolicy next) {
        if (!"https".equals(context.getHttpRequest().getUrl().getProtocol())) {
            return Mono.error(new RuntimeException("Token credentials require a URL using the HTTPS protocol scheme."));
        }
        HttpPipelineNextPolicy nextPolicy = next.clone();
        return this.authorizeRequest(context).then(Mono.defer(next::process)).flatMap(httpResponse -> {
            String authHeader = httpResponse.getHeaderValue(HttpHeaderName.WWW_AUTHENTICATE);
            if (httpResponse.getStatusCode() == 401 && authHeader != null) {
                return this.handleChallenge(context, (HttpResponse)httpResponse, nextPolicy);
            }
            return Mono.just(httpResponse);
        });
    }

    @Override
    public HttpResponse processSync(HttpPipelineCallContext context, HttpPipelineNextSyncPolicy next) {
        if (!"https".equals(context.getHttpRequest().getUrl().getProtocol())) {
            throw LOGGER.logExceptionAsError(new RuntimeException("Token credentials require a URL using the HTTPS protocol scheme."));
        }
        HttpPipelineNextSyncPolicy nextPolicy = next.clone();
        this.authorizeRequestSync(context);
        HttpResponse httpResponse = next.processSync();
        String authHeader = httpResponse.getHeaderValue(HttpHeaderName.WWW_AUTHENTICATE);
        if (httpResponse.getStatusCode() == 401 && authHeader != null) {
            return this.handleChallengeSync(context, httpResponse, nextPolicy);
        }
        return httpResponse;
    }

    private Mono<HttpResponse> handleChallenge(HttpPipelineCallContext context, HttpResponse httpResponse, HttpPipelineNextPolicy next) {
        return this.authorizeRequestOnChallenge(context, httpResponse).flatMap(authorized -> {
            if (authorized.booleanValue()) {
                httpResponse.close();
                HttpPipelineNextPolicy nextPolicy = next.clone();
                return next.process().flatMap(newResponse -> {
                    String authHeader = newResponse.getHeaderValue(HttpHeaderName.WWW_AUTHENTICATE);
                    if (newResponse.getStatusCode() == 401 && authHeader != null && this.isClaimsPresent((HttpResponse)newResponse) && !this.isClaimsPresent(httpResponse)) {
                        return this.handleChallenge(context, (HttpResponse)newResponse, nextPolicy);
                    }
                    return Mono.just(newResponse);
                });
            }
            return Mono.just(httpResponse);
        });
    }

    private HttpResponse handleChallengeSync(HttpPipelineCallContext context, HttpResponse httpResponse, HttpPipelineNextSyncPolicy next) {
        if (this.authorizeRequestOnChallengeSync(context, httpResponse)) {
            httpResponse.close();
            HttpPipelineNextSyncPolicy nextPolicy = next.clone();
            HttpResponse newResponse = next.processSync();
            String authHeader = newResponse.getHeaderValue(HttpHeaderName.WWW_AUTHENTICATE);
            if (newResponse.getStatusCode() == 401 && authHeader != null && this.isClaimsPresent(newResponse) && !this.isClaimsPresent(httpResponse)) {
                return this.handleChallengeSync(context, newResponse, nextPolicy);
            }
            return newResponse;
        }
        return httpResponse;
    }

    private boolean isClaimsPresent(HttpResponse httpResponse) {
        Map<String, String> challengeAttributes = KeyVaultCredentialPolicy.extractChallengeAttributes(httpResponse.getHeaderValue(HttpHeaderName.WWW_AUTHENTICATE), BEARER_TOKEN_PREFIX);
        String error = challengeAttributes.get("error");
        if (error != null) {
            String base64Claims = challengeAttributes.get("claims");
            return "insufficient_claims".equalsIgnoreCase(error) && base64Claims != null;
        }
        return false;
    }

    public static void clearCache() {
        CHALLENGE_CACHE.clear();
    }

    private static String getRequestAuthority(HttpRequest request) {
        URL url = request.getUrl();
        String authority = url.getAuthority();
        int port = url.getPort();
        if (!authority.contains(":") && port > 0) {
            authority = authority + ":" + port;
        }
        return authority;
    }

    private static boolean isChallengeResourceValid(HttpRequest request, String scope) {
        URI scopeUri;
        try {
            scopeUri = new URI(scope);
        }
        catch (URISyntaxException e) {
            throw LOGGER.logExceptionAsError(new RuntimeException(String.format("The challenge resource '%s' is not a valid URI.", scope), e));
        }
        return request.getUrl().getHost().toLowerCase(Locale.ROOT).endsWith("." + scopeUri.getHost().toLowerCase(Locale.ROOT));
    }

    private static class ChallengeParameters {
        private final URI authorizationUri;
        private final String tenantId;
        private final String[] scopes;

        ChallengeParameters(URI authorizationUri, String[] scopes) {
            this.authorizationUri = authorizationUri;
            this.tenantId = authorizationUri.getPath().split("/")[1];
            this.scopes = scopes;
        }

        public URI getAuthorizationUri() {
            return this.authorizationUri;
        }

        public String[] getScopes() {
            return this.scopes;
        }

        public String getTenantId() {
            return this.tenantId;
        }
    }
}

