/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.storage.blob.implementation.util;

import com.dataiku.dss.shadelibazure.com.azure.core.http.HttpHeaderName;
import com.dataiku.dss.shadelibazure.com.azure.core.http.HttpPipelineCallContext;
import com.dataiku.dss.shadelibazure.com.azure.core.http.HttpPipelineNextPolicy;
import com.dataiku.dss.shadelibazure.com.azure.core.http.HttpPipelinePosition;
import com.dataiku.dss.shadelibazure.com.azure.core.http.HttpResponse;
import com.dataiku.dss.shadelibazure.com.azure.core.http.policy.HttpPipelinePolicy;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Mono;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class BlobUserAgentModificationPolicy
implements HttpPipelinePolicy {
    private final String clientName;
    private final String clientVersion;
    private static final String REGEX = "(.*? )?(azsdk-java-azure-storage-blob/12\\.\\d{1,2}\\.\\d{1,2}(?:-beta\\.\\d{1,2})?)( .*?)?";
    private static final Pattern PATTERN = Pattern.compile("(.*? )?(azsdk-java-azure-storage-blob/12\\.\\d{1,2}\\.\\d{1,2}(?:-beta\\.\\d{1,2})?)( .*?)?");

    public BlobUserAgentModificationPolicy(String clientName, String clientVersion) {
        this.clientName = clientName;
        this.clientVersion = clientVersion;
    }

    @Override
    public Mono<HttpResponse> process(HttpPipelineCallContext context, HttpPipelineNextPolicy next) {
        String userAgent = context.getHttpRequest().getHeaders().getValue(HttpHeaderName.USER_AGENT);
        Matcher matcher = PATTERN.matcher(userAgent);
        StringBuilder builder = new StringBuilder();
        if (matcher.matches()) {
            builder.append(matcher.group(1) == null ? "" : matcher.group(1)).append(matcher.group(2) == null ? "" : matcher.group(2)).append(" ").append("azsdk-java-").append(this.clientName).append("/").append(this.clientVersion).append(matcher.group(3) == null ? "" : matcher.group(3));
            context.getHttpRequest().getHeaders().set(HttpHeaderName.USER_AGENT, builder.toString());
        }
        return next.process();
    }

    @Override
    public HttpPipelinePosition getPipelinePosition() {
        return HttpPipelinePosition.PER_CALL;
    }
}

