/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.storage.blob.specialized;

import com.dataiku.dss.shadelibazure.com.azure.core.util.CoreUtils;
import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.storage.blob.implementation.util.ByteBufferBackedOutputStreamUtil;
import com.dataiku.dss.shadelibazure.com.azure.storage.blob.models.BlobDownloadHeaders;
import com.dataiku.dss.shadelibazure.com.azure.storage.blob.models.BlobDownloadResponse;
import com.dataiku.dss.shadelibazure.com.azure.storage.blob.models.BlobErrorCode;
import com.dataiku.dss.shadelibazure.com.azure.storage.blob.models.BlobRange;
import com.dataiku.dss.shadelibazure.com.azure.storage.blob.models.BlobRequestConditions;
import com.dataiku.dss.shadelibazure.com.azure.storage.blob.models.BlobStorageException;
import com.dataiku.dss.shadelibazure.com.azure.storage.blob.specialized.BlobClientBase;
import com.dataiku.dss.shadelibazure.com.azure.storage.common.implementation.StorageSeekableByteChannel;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Objects;

class StorageSeekableByteChannelBlobReadBehavior
implements StorageSeekableByteChannel.ReadBehavior {
    private static final ClientLogger LOGGER = new ClientLogger(StorageSeekableByteChannelBlobReadBehavior.class);
    private final BlobClientBase client;
    private final BlobRequestConditions requestConditions;
    private long resourceLength;
    private ByteBuffer initialBuffer;
    private Long initialBufferPosition;

    StorageSeekableByteChannelBlobReadBehavior(BlobClientBase client, ByteBuffer initialBuffer, long initialBufferPosition, long resourceLength, BlobRequestConditions requestConditions) {
        this.client = Objects.requireNonNull(client);
        this.initialBuffer = Objects.requireNonNull(initialBuffer);
        this.initialBufferPosition = initialBufferPosition;
        this.resourceLength = resourceLength;
        this.requestConditions = requestConditions;
    }

    BlobClientBase getClient() {
        return this.client;
    }

    BlobRequestConditions getRequestConditions() {
        return this.requestConditions;
    }

    @Override
    public int read(ByteBuffer dst, long sourceOffset) throws IOException {
        int n;
        if (dst.remaining() <= 0) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException("'dst.remaining()' must be positive."));
        }
        if (this.initialBufferPosition != null && this.initialBuffer != null && this.initialBufferPosition == sourceOffset) {
            return this.readFromCache(dst);
        }
        this.initialBuffer = null;
        this.initialBufferPosition = null;
        int initialPosition = dst.position();
        ByteBufferBackedOutputStreamUtil dstStream = new ByteBufferBackedOutputStreamUtil(dst);
        try {
            BlobDownloadResponse response = this.client.downloadStreamWithResponse(dstStream, new BlobRange(sourceOffset, Long.valueOf(dst.remaining())), null, this.requestConditions, false, null, null);
            this.resourceLength = CoreUtils.extractSizeFromContentRange(((BlobDownloadHeaders)response.getDeserializedHeaders()).getContentRange());
            n = dst.position() - initialPosition;
        }
        catch (Throwable response) {
            try {
                try {
                    dstStream.close();
                }
                catch (Throwable throwable) {
                    response.addSuppressed(throwable);
                }
                throw response;
            }
            catch (BlobStorageException e) {
                if (e.getErrorCode() == BlobErrorCode.INVALID_RANGE) {
                    String contentRange = e.getResponse().getHeaderValue("Content-Range");
                    if (contentRange != null) {
                        this.resourceLength = CoreUtils.extractSizeFromContentRange(contentRange);
                    }
                    return sourceOffset < this.resourceLength ? 0 : -1;
                }
                throw LOGGER.logExceptionAsError(e);
            }
        }
        dstStream.close();
        return n;
    }

    private int readFromCache(ByteBuffer dst) {
        int read = Math.min(dst.remaining(), this.initialBuffer.remaining());
        if (read > 0) {
            ByteBuffer temp = this.initialBuffer.duplicate();
            temp.limit(temp.position() + read);
            dst.put(temp);
        }
        this.initialBuffer = null;
        this.initialBufferPosition = null;
        return read;
    }

    @Override
    public long getResourceLength() {
        return this.resourceLength;
    }
}

