/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.storage.common;

import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Flux;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Mono;
import com.dataiku.dss.shadelibazure.reactor.util.annotation.NonNull;
import java.io.IOException;
import java.io.OutputStream;

public abstract class StorageOutputStream
extends OutputStream {
    private static final ClientLogger LOGGER = new ClientLogger(StorageOutputStream.class);
    private final int writeThreshold;
    protected volatile IOException lastError;

    protected abstract Mono<Void> dispatchWrite(byte[] var1, int var2, long var3);

    protected StorageOutputStream(int writeThreshold) {
        this.writeThreshold = writeThreshold;
    }

    protected void writeInternal(byte[] data, int offset, int length) {
        int chunks = (int)Math.ceil((double)length / (double)this.writeThreshold);
        Flux.range(0, chunks).map(c -> offset + c * this.writeThreshold).concatMap(pos -> this.processChunk(data, (int)pos, offset, length)).then().block();
    }

    private Mono<Void> processChunk(byte[] data, int position, int offset, int length) {
        int chunkLength = this.writeThreshold;
        if (position + chunkLength > offset + length) {
            chunkLength = offset + length - position;
        }
        return this.dispatchWrite(data, chunkLength, position).doOnError(t -> {
            this.lastError = t instanceof IOException ? (IOException)t : new IOException((Throwable)t);
        });
    }

    protected void checkStreamState() {
        if (this.lastError != null) {
            throw LOGGER.logExceptionAsError(new RuntimeException(this.lastError.getMessage()));
        }
    }

    @Override
    public void flush() {
        this.checkStreamState();
    }

    @Override
    public void write(@NonNull byte[] data) {
        this.write(data, 0, data.length);
    }

    @Override
    public void write(@NonNull byte[] data, int offset, int length) {
        if (offset < 0 || length < 0 || length > data.length - offset) {
            throw LOGGER.logExceptionAsError(new IndexOutOfBoundsException());
        }
        this.writeInternal(data, offset, length);
    }

    @Override
    public void write(int byteVal) {
        this.write(new byte[]{(byte)(byteVal & 0xFF)});
    }

    @Override
    public synchronized void close() throws IOException {
        try {
            this.checkStreamState();
            this.flush();
        }
        finally {
            this.lastError = new IOException("Stream is already closed.");
        }
    }
}

