/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.storage.common;

import com.dataiku.dss.shadelibazure.com.azure.core.credential.AzureNamedKeyCredential;
import com.dataiku.dss.shadelibazure.com.azure.core.http.HttpHeader;
import com.dataiku.dss.shadelibazure.com.azure.core.http.HttpHeaderName;
import com.dataiku.dss.shadelibazure.com.azure.core.http.HttpHeaders;
import com.dataiku.dss.shadelibazure.com.azure.core.http.HttpPipeline;
import com.dataiku.dss.shadelibazure.com.azure.core.http.policy.HttpPipelinePolicy;
import com.dataiku.dss.shadelibazure.com.azure.core.util.Context;
import com.dataiku.dss.shadelibazure.com.azure.core.util.CoreUtils;
import com.dataiku.dss.shadelibazure.com.azure.core.util.Header;
import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.storage.common.Utility;
import com.dataiku.dss.shadelibazure.com.azure.storage.common.implementation.StorageImplUtils;
import com.dataiku.dss.shadelibazure.com.azure.storage.common.policy.StorageSharedKeyCredentialPolicy;
import java.net.URL;
import java.text.Collator;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;

public final class StorageSharedKeyCredential {
    private static final ClientLogger LOGGER = new ClientLogger(StorageSharedKeyCredential.class);
    private static final ThreadLocal<Collator> THREAD_LOCAL_COLLATOR = ThreadLocal.withInitial(() -> Collator.getInstance(Locale.ROOT));
    private static final Context LOG_STRING_TO_SIGN_CONTEXT = new Context("Azure-Storage-Log-String-To-Sign", true);
    private static final String ACCOUNT_KEY = "accountkey";
    private static final String ACCOUNT_NAME = "accountname";
    private static final HttpHeaderName X_MS_DATE = HttpHeaderName.fromString("x-ms-date");
    private final AzureNamedKeyCredential azureNamedKeyCredential;

    public StorageSharedKeyCredential(String accountName, String accountKey) {
        Objects.requireNonNull(accountName, "'accountName' cannot be null.");
        Objects.requireNonNull(accountKey, "'accountKey' cannot be null.");
        this.azureNamedKeyCredential = new AzureNamedKeyCredential(accountName, accountKey);
    }

    private StorageSharedKeyCredential(AzureNamedKeyCredential azureNamedKeyCredential) {
        Objects.requireNonNull(azureNamedKeyCredential, "'azureNamedKeyCredential' cannot be null.");
        this.azureNamedKeyCredential = azureNamedKeyCredential;
    }

    public static StorageSharedKeyCredential fromConnectionString(String connectionString) {
        String accountName = null;
        String accountKey = null;
        for (String connectionStringPiece : connectionString.split(";")) {
            String[] kvp = connectionStringPiece.split("=", 2);
            if (kvp.length < 2) continue;
            if (ACCOUNT_NAME.equalsIgnoreCase(kvp[0])) {
                accountName = kvp[1];
                continue;
            }
            if (!ACCOUNT_KEY.equalsIgnoreCase(kvp[0])) continue;
            accountKey = kvp[1];
        }
        if (CoreUtils.isNullOrEmpty(accountName) || CoreUtils.isNullOrEmpty(accountKey)) {
            throw new IllegalArgumentException("Connection string must contain 'AccountName' and 'AccountKey'.");
        }
        return new StorageSharedKeyCredential(accountName, accountKey);
    }

    public static StorageSharedKeyCredential fromAzureNamedKeyCredential(AzureNamedKeyCredential azureNamedKeyCredential) {
        return new StorageSharedKeyCredential(azureNamedKeyCredential);
    }

    public String getAccountName() {
        return this.azureNamedKeyCredential.getAzureNamedKey().getName();
    }

    public String generateAuthorizationHeader(URL requestURL, String httpMethod, Map<String, String> headers) {
        return this.generateAuthorizationHeader(requestURL, httpMethod, headers, false);
    }

    public String generateAuthorizationHeader(URL requestURL, String httpMethod, Map<String, String> headers, boolean logStringToSign) {
        return this.generateAuthorizationHeader(requestURL, httpMethod, new HttpHeaders(headers), logStringToSign);
    }

    public String generateAuthorizationHeader(URL requestURL, String httpMethod, HttpHeaders headers, boolean logStringToSign) {
        String signature = StorageImplUtils.computeHMac256(this.azureNamedKeyCredential.getAzureNamedKey().getKey(), this.buildStringToSign(requestURL, httpMethod, headers, logStringToSign));
        return "SharedKey " + this.azureNamedKeyCredential.getAzureNamedKey().getName() + ":" + signature;
    }

    public String computeHmac256(String stringToSign) {
        return StorageImplUtils.computeHMac256(this.azureNamedKeyCredential.getAzureNamedKey().getKey(), stringToSign);
    }

    private String buildStringToSign(URL requestURL, String httpMethod, HttpHeaders headers, boolean logStringToSign) {
        String contentLength = headers.getValue(HttpHeaderName.CONTENT_LENGTH);
        contentLength = "0".equals(contentLength) ? "" : contentLength;
        String dateHeader = headers.getValue(X_MS_DATE) != null ? "" : this.getStandardHeaderValue(headers, HttpHeaderName.DATE);
        Collator collator = THREAD_LOCAL_COLLATOR.get();
        String stringToSign = String.join((CharSequence)"\n", httpMethod, this.getStandardHeaderValue(headers, HttpHeaderName.CONTENT_ENCODING), this.getStandardHeaderValue(headers, HttpHeaderName.CONTENT_LANGUAGE), contentLength, this.getStandardHeaderValue(headers, HttpHeaderName.CONTENT_MD5), this.getStandardHeaderValue(headers, HttpHeaderName.CONTENT_TYPE), dateHeader, this.getStandardHeaderValue(headers, HttpHeaderName.IF_MODIFIED_SINCE), this.getStandardHeaderValue(headers, HttpHeaderName.IF_MATCH), this.getStandardHeaderValue(headers, HttpHeaderName.IF_NONE_MATCH), this.getStandardHeaderValue(headers, HttpHeaderName.IF_UNMODIFIED_SINCE), this.getStandardHeaderValue(headers, HttpHeaderName.RANGE), StorageSharedKeyCredential.getAdditionalXmsHeaders(headers, collator), this.getCanonicalizedResource(requestURL, collator));
        if (logStringToSign) {
            StorageImplUtils.logStringToSign(LOGGER, stringToSign, LOG_STRING_TO_SIGN_CONTEXT);
        }
        return stringToSign;
    }

    private String getStandardHeaderValue(HttpHeaders headers, HttpHeaderName headerName) {
        HttpHeader header = headers.get(headerName);
        return header == null ? "" : header.getValue();
    }

    private static String getAdditionalXmsHeaders(HttpHeaders headers, Collator collator) {
        ArrayList<HttpHeader> xmsHeaders = new ArrayList<HttpHeader>();
        int stringBuilderSize = 0;
        for (HttpHeader header : headers) {
            String string = header.getName();
            if (!"x-ms-".regionMatches(true, 0, string, 0, 5)) continue;
            String headerValue = header.getValue();
            stringBuilderSize += string.length() + headerValue.length();
            xmsHeaders.add(header);
        }
        if (xmsHeaders.isEmpty()) {
            return "";
        }
        StringBuilder canonicalizedHeaders = new StringBuilder(stringBuilderSize + 2 * xmsHeaders.size() - 1);
        xmsHeaders.sort((o1, o2) -> collator.compare(o1.getName(), o2.getName()));
        for (Header header : xmsHeaders) {
            if (canonicalizedHeaders.length() > 0) {
                canonicalizedHeaders.append('\n');
            }
            canonicalizedHeaders.append(header.getName().toLowerCase(Locale.ROOT)).append(':').append(header.getValue());
        }
        return canonicalizedHeaders.toString();
    }

    private String getCanonicalizedResource(URL requestURL, Collator collator) {
        String query;
        String resourcePath = this.azureNamedKeyCredential.getAzureNamedKey().getName();
        String absolutePath = requestURL.getPath();
        if (CoreUtils.isNullOrEmpty(absolutePath)) {
            absolutePath = "/";
        }
        if (CoreUtils.isNullOrEmpty(query = requestURL.getQuery())) {
            return "/" + resourcePath + absolutePath;
        }
        int stringBuilderSize = 1 + resourcePath.length() + absolutePath.length() + query.length();
        TreeMap pieces = new TreeMap(collator);
        StorageImplUtils.parseQueryParameters(query).forEachRemaining(kvp -> {
            String key = Utility.urlDecode((String)kvp.getKey()).toLowerCase(Locale.ROOT);
            pieces.compute(key, (k, values2) -> {
                if (values2 == null) {
                    values2 = new ArrayList<String>();
                }
                for (String value : ((String)kvp.getValue()).split(",")) {
                    values2.add(Utility.urlDecode(value));
                }
                return values2;
            });
        });
        StringBuilder canonicalizedResource = new StringBuilder(stringBuilderSize += pieces.size()).append('/').append(resourcePath).append(absolutePath);
        for (Map.Entry queryParam : pieces.entrySet()) {
            List queryParamValues = (List)queryParam.getValue();
            queryParamValues.sort(collator);
            canonicalizedResource.append('\n').append((String)queryParam.getKey()).append(':');
            int size = queryParamValues.size();
            for (int i = 0; i < size; ++i) {
                String queryParamValue = (String)queryParamValues.get(i);
                if (i > 0) {
                    canonicalizedResource.append(',');
                }
                canonicalizedResource.append(queryParamValue);
            }
        }
        return canonicalizedResource.toString();
    }

    public static StorageSharedKeyCredential getSharedKeyCredentialFromPipeline(HttpPipeline httpPipeline) {
        for (int i = 0; i < httpPipeline.getPolicyCount(); ++i) {
            HttpPipelinePolicy httpPipelinePolicy = httpPipeline.getPolicy(i);
            if (!(httpPipelinePolicy instanceof StorageSharedKeyCredentialPolicy)) continue;
            StorageSharedKeyCredentialPolicy storageSharedKeyCredentialPolicy = (StorageSharedKeyCredentialPolicy)httpPipelinePolicy;
            return storageSharedKeyCredentialPolicy.sharedKeyCredential();
        }
        return null;
    }
}

