/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.storage.common.implementation;

import com.dataiku.dss.shadelibazure.reactor.core.publisher.Flux;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public final class BufferAggregator {
    private final long limit;
    private long length = 0L;
    private List<ByteBuffer> buffers = new LinkedList<ByteBuffer>();

    BufferAggregator(long limit) {
        this.limit = limit;
    }

    long remainingCapacity() {
        return this.limit - this.length;
    }

    public long length() {
        return this.length;
    }

    void append(ByteBuffer byteBuffer) {
        this.buffers.add(byteBuffer);
        this.length += (long)byteBuffer.remaining();
    }

    void reset() {
        this.length = 0L;
        this.buffers = new LinkedList<ByteBuffer>();
    }

    public Flux<ByteBuffer> asFlux() {
        return Flux.fromIterable(this.buffers);
    }

    public byte[] getFirstNBytes(int numBytes) {
        if (numBytes < 0 || (long)numBytes > this.length) {
            throw new IllegalArgumentException("numBytes is outside the range of this aggregator");
        }
        ByteBuffer data = ByteBuffer.allocate(numBytes);
        Iterator<ByteBuffer> bufferIterator = this.buffers.iterator();
        while (data.hasRemaining()) {
            ByteBuffer source2 = bufferIterator.next();
            if (data.remaining() < source2.remaining()) {
                int readAmount = data.remaining();
                ByteBuffer smallSource = source2.duplicate();
                smallSource.limit(source2.position() + readAmount);
                data.put(smallSource);
                source2.position(source2.position() + readAmount);
                continue;
            }
            data.put(source2);
        }
        this.length -= (long)data.array().length;
        return data.array();
    }
}

