/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.storage.common.policy;

import com.dataiku.dss.shadelibazure.com.azure.core.http.HttpHeader;
import com.dataiku.dss.shadelibazure.com.azure.core.http.HttpHeaders;
import com.dataiku.dss.shadelibazure.com.azure.core.http.HttpPipelineCallContext;
import com.dataiku.dss.shadelibazure.com.azure.core.http.HttpPipelineNextPolicy;
import com.dataiku.dss.shadelibazure.com.azure.core.http.HttpPipelineNextSyncPolicy;
import com.dataiku.dss.shadelibazure.com.azure.core.http.HttpResponse;
import com.dataiku.dss.shadelibazure.com.azure.core.http.policy.HttpPipelinePolicy;
import com.dataiku.dss.shadelibazure.com.azure.core.util.CoreUtils;
import com.dataiku.dss.shadelibazure.com.azure.core.util.FluxUtil;
import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Mono;

public class MetadataValidationPolicy
implements HttpPipelinePolicy {
    private static final ClientLogger LOGGER = new ClientLogger(MetadataValidationPolicy.class);
    private static final String X_MS_META = "x-ms-meta-";
    private static final int X_MS_META_LENGTH = "x-ms-meta-".length();

    @Override
    public HttpResponse processSync(HttpPipelineCallContext context, HttpPipelineNextSyncPolicy next) {
        MetadataValidationPolicy.validateMetadataHeaders(context.getHttpRequest().getHeaders());
        return next.processSync();
    }

    @Override
    public Mono<HttpResponse> process(HttpPipelineCallContext context, HttpPipelineNextPolicy next) {
        try {
            MetadataValidationPolicy.validateMetadataHeaders(context.getHttpRequest().getHeaders());
        }
        catch (IllegalArgumentException ex) {
            return FluxUtil.monoError(LOGGER, (RuntimeException)ex);
        }
        return next.process();
    }

    static void validateMetadataHeaders(HttpHeaders headers) {
        for (HttpHeader header : headers) {
            String name = header.getName();
            if (!X_MS_META.regionMatches(true, 0, name, 0, X_MS_META_LENGTH)) continue;
            boolean hasWhitespace = name.length() > X_MS_META_LENGTH && MetadataValidationPolicy.checkWhitespace(name, X_MS_META_LENGTH, name.length() - 1);
            String value = header.getValue();
            if (!(hasWhitespace |= hasWhitespace || !CoreUtils.isNullOrEmpty(value) && MetadataValidationPolicy.checkWhitespace(value, 0, value.length() - 1))) continue;
            throw LOGGER.logExceptionAsError(new IllegalArgumentException("Metadata keys and values can not contain leading or trailing whitespace. Please remove or encode them."));
        }
    }

    private static boolean checkWhitespace(String str, int leadIndex, int trailIndex) {
        return Character.isWhitespace(str.charAt(leadIndex)) || Character.isWhitespace(str.charAt(trailIndex));
    }
}

