/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.storage.common.policy;

import com.dataiku.dss.shadelibazure.com.azure.core.http.HttpHeader;
import com.dataiku.dss.shadelibazure.com.azure.core.http.HttpHeaderName;
import com.dataiku.dss.shadelibazure.com.azure.core.http.HttpPipelineCallContext;
import com.dataiku.dss.shadelibazure.com.azure.core.http.HttpPipelineNextPolicy;
import com.dataiku.dss.shadelibazure.com.azure.core.http.HttpPipelineNextSyncPolicy;
import com.dataiku.dss.shadelibazure.com.azure.core.http.HttpResponse;
import com.dataiku.dss.shadelibazure.com.azure.core.http.policy.HttpPipelinePolicy;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Mono;

public class ScrubEtagPolicy
implements HttpPipelinePolicy {
    @Override
    public HttpResponse processSync(HttpPipelineCallContext context, HttpPipelineNextSyncPolicy next) {
        HttpResponse response = next.processSync();
        return this.scrubETagHeader(response);
    }

    @Override
    public Mono<HttpResponse> process(HttpPipelineCallContext context, HttpPipelineNextPolicy next) {
        return next.process().flatMap(response -> Mono.just(this.scrubETagHeader((HttpResponse)response)));
    }

    private HttpResponse scrubETagHeader(HttpResponse unprocessedResponse) {
        HttpHeader eTagHeader = unprocessedResponse.getHeaders().get(HttpHeaderName.ETAG);
        if (eTagHeader == null) {
            return unprocessedResponse;
        }
        String etag = eTagHeader.getValue();
        boolean startsWithQuote = etag.startsWith("\"");
        boolean endsWithQuote = etag.endsWith("\"");
        if (startsWithQuote && endsWithQuote) {
            unprocessedResponse.getHeaders().set(HttpHeaderName.ETAG, etag.substring(1, etag.length() - 1));
        } else if (startsWithQuote) {
            unprocessedResponse.getHeaders().set(HttpHeaderName.ETAG, etag.substring(1));
        } else if (endsWithQuote) {
            unprocessedResponse.getHeaders().set(HttpHeaderName.ETAG, etag.substring(0, etag.length() - 1));
        }
        return unprocessedResponse;
    }
}

