/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.storage.file.datalake;

import com.dataiku.dss.shadelibazure.com.azure.core.annotation.ReturnType;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.ServiceClient;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.ServiceMethod;
import com.dataiku.dss.shadelibazure.com.azure.core.credential.AzureSasCredential;
import com.dataiku.dss.shadelibazure.com.azure.core.http.HttpPipeline;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedIterable;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedResponse;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedResponseBase;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.Response;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.ResponseBase;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.SimpleResponse;
import com.dataiku.dss.shadelibazure.com.azure.core.util.Context;
import com.dataiku.dss.shadelibazure.com.azure.storage.blob.specialized.BlockBlobClient;
import com.dataiku.dss.shadelibazure.com.azure.storage.blob.specialized.SpecializedBlobClientBuilder;
import com.dataiku.dss.shadelibazure.com.azure.storage.common.Utility;
import com.dataiku.dss.shadelibazure.com.azure.storage.common.implementation.StorageImplUtils;
import com.dataiku.dss.shadelibazure.com.azure.storage.file.datalake.DataLakeDirectoryAsyncClient;
import com.dataiku.dss.shadelibazure.com.azure.storage.file.datalake.DataLakeFileClient;
import com.dataiku.dss.shadelibazure.com.azure.storage.file.datalake.DataLakePathClient;
import com.dataiku.dss.shadelibazure.com.azure.storage.file.datalake.DataLakePathClientBuilder;
import com.dataiku.dss.shadelibazure.com.azure.storage.file.datalake.DataLakeServiceVersion;
import com.dataiku.dss.shadelibazure.com.azure.storage.file.datalake.Transforms;
import com.dataiku.dss.shadelibazure.com.azure.storage.file.datalake.implementation.models.CpkInfo;
import com.dataiku.dss.shadelibazure.com.azure.storage.file.datalake.implementation.models.FileSystemsListPathsHeaders;
import com.dataiku.dss.shadelibazure.com.azure.storage.file.datalake.implementation.models.PathList;
import com.dataiku.dss.shadelibazure.com.azure.storage.file.datalake.implementation.models.PathResourceType;
import com.dataiku.dss.shadelibazure.com.azure.storage.file.datalake.implementation.util.DataLakeImplUtils;
import com.dataiku.dss.shadelibazure.com.azure.storage.file.datalake.implementation.util.TransformUtils;
import com.dataiku.dss.shadelibazure.com.azure.storage.file.datalake.models.CustomerProvidedKey;
import com.dataiku.dss.shadelibazure.com.azure.storage.file.datalake.models.DataLakeRequestConditions;
import com.dataiku.dss.shadelibazure.com.azure.storage.file.datalake.models.DataLakeStorageException;
import com.dataiku.dss.shadelibazure.com.azure.storage.file.datalake.models.PathHttpHeaders;
import com.dataiku.dss.shadelibazure.com.azure.storage.file.datalake.models.PathInfo;
import com.dataiku.dss.shadelibazure.com.azure.storage.file.datalake.models.PathItem;
import com.dataiku.dss.shadelibazure.com.azure.storage.file.datalake.options.DataLakePathCreateOptions;
import com.dataiku.dss.shadelibazure.com.azure.storage.file.datalake.options.DataLakePathDeleteOptions;
import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.function.BiFunction;
import java.util.stream.Collectors;

@ServiceClient(builder=DataLakePathClientBuilder.class)
public class DataLakeDirectoryClient
extends DataLakePathClient {
    private final DataLakeDirectoryAsyncClient dataLakeDirectoryAsyncClient;

    DataLakeDirectoryClient(DataLakeDirectoryAsyncClient dataLakeDirectoryAsyncClient, BlockBlobClient blockBlobClient, HttpPipeline pipeline, String url, DataLakeServiceVersion serviceVersion, String accountName, String fileSystemName, String directoryName, AzureSasCredential sasToken, CpkInfo customerProvidedKey, boolean isTokenCredentialAuthenticated) {
        super(dataLakeDirectoryAsyncClient, blockBlobClient, pipeline, url, serviceVersion, accountName, fileSystemName, directoryName, PathResourceType.DIRECTORY, sasToken, customerProvidedKey, isTokenCredentialAuthenticated);
        this.dataLakeDirectoryAsyncClient = dataLakeDirectoryAsyncClient;
    }

    DataLakeDirectoryClient(DataLakePathClient dataLakePathClient) {
        super(dataLakePathClient.dataLakePathAsyncClient, dataLakePathClient.blockBlobClient, dataLakePathClient.getHttpPipeline(), dataLakePathClient.getAccountUrl(), dataLakePathClient.getServiceVersion(), dataLakePathClient.getAccountName(), dataLakePathClient.getFileSystemName(), Utility.urlEncode(dataLakePathClient.pathName), PathResourceType.DIRECTORY, dataLakePathClient.getSasToken(), dataLakePathClient.getCpkInfo(), dataLakePathClient.isTokenCredentialAuthenticated());
        this.dataLakeDirectoryAsyncClient = new DataLakeDirectoryAsyncClient(dataLakePathClient.dataLakePathAsyncClient);
    }

    public String getDirectoryUrl() {
        return this.getPathUrl();
    }

    public String getDirectoryPath() {
        return this.getObjectPath();
    }

    public String getDirectoryName() {
        return this.getObjectName();
    }

    @Override
    public DataLakeDirectoryClient getCustomerProvidedKeyClient(CustomerProvidedKey customerProvidedKey) {
        CpkInfo finalCustomerProvidedKey = null;
        if (customerProvidedKey != null) {
            finalCustomerProvidedKey = new CpkInfo().setEncryptionKey(customerProvidedKey.getKey()).setEncryptionKeySha256(customerProvidedKey.getKeySha256()).setEncryptionAlgorithm(customerProvidedKey.getEncryptionAlgorithm());
        }
        return new DataLakeDirectoryClient(this.dataLakeDirectoryAsyncClient.getCustomerProvidedKeyAsyncClient(customerProvidedKey), this.blockBlobClient.getCustomerProvidedKeyClient(Transforms.toBlobCustomerProvidedKey(customerProvidedKey)), this.getHttpPipeline(), this.getAccountUrl(), this.getServiceVersion(), this.getAccountName(), this.getFileSystemName(), this.getObjectPath(), this.getSasToken(), finalCustomerProvidedKey, this.isTokenCredentialAuthenticated());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete() {
        this.deleteWithResponse(false, (DataLakeRequestConditions)null, (Duration)null, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void deleteRecursively() {
        this.deleteRecursivelyWithResponse(null, null, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteRecursivelyWithResponse(DataLakeRequestConditions requestConditions, Duration timeout2, Context context) {
        return this.deleteWithResponse(true, requestConditions, timeout2, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteWithResponse(boolean recursive, DataLakeRequestConditions requestConditions, Duration timeout2, Context context) {
        return super.deleteWithResponse(recursive, requestConditions, timeout2, context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public boolean deleteIfExists() {
        return this.deleteIfExistsWithResponse(new DataLakePathDeleteOptions(), null, Context.NONE).getValue();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Boolean> deleteIfExistsWithResponse(DataLakePathDeleteOptions options, Duration timeout2, Context context) {
        return super.deleteIfExistsWithResponse(options, timeout2, context);
    }

    public DataLakeFileClient getFileClient(String fileName) {
        Objects.requireNonNull(fileName, "'fileName' can not be set to null");
        String pathPrefix = this.getObjectPath().isEmpty() ? "" : this.getObjectPath() + "/";
        BlockBlobClient blockBlobClient = this.dataLakeDirectoryAsyncClient.prepareBuilderAppendPath(pathPrefix + fileName).buildBlockBlobClient();
        return new DataLakeFileClient(this.dataLakeDirectoryAsyncClient.getFileAsyncClient(fileName), blockBlobClient, this.getHttpPipeline(), this.getAccountUrl(), this.getServiceVersion(), this.getAccountName(), this.getFileSystemName(), pathPrefix + fileName, this.getSasToken(), this.getCpkInfo(), this.isTokenCredentialAuthenticated());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public DataLakeFileClient createFile(String fileName) {
        return this.createFile(fileName, false);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public DataLakeFileClient createFile(String fileName, boolean overwrite) {
        DataLakeRequestConditions requestConditions = new DataLakeRequestConditions();
        if (!overwrite) {
            requestConditions.setIfNoneMatch("*");
        }
        return this.createFileWithResponse(fileName, new DataLakePathCreateOptions().setRequestConditions(requestConditions), null, null).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<DataLakeFileClient> createFileWithResponse(String fileName, String permissions, String umask, PathHttpHeaders headers, Map<String, String> metadata, DataLakeRequestConditions requestConditions, Duration timeout2, Context context) {
        DataLakePathCreateOptions options = new DataLakePathCreateOptions().setPermissions(permissions).setUmask(umask).setPathHttpHeaders(headers).setMetadata(metadata).setRequestConditions(requestConditions);
        return this.createFileWithResponse(fileName, options, timeout2, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<DataLakeFileClient> createFileWithResponse(String fileName, DataLakePathCreateOptions options, Duration timeout2, Context context) {
        DataLakeFileClient dataLakeFileClient = this.getFileClient(fileName);
        Response<PathInfo> response = dataLakeFileClient.createWithResponse(options, timeout2, context);
        return new SimpleResponse<DataLakeFileClient>(response, dataLakeFileClient);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public DataLakeFileClient createFileIfNotExists(String fileName) {
        return this.createFileIfNotExistsWithResponse(fileName, new DataLakePathCreateOptions(), null, null).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<DataLakeFileClient> createFileIfNotExistsWithResponse(String fileName, DataLakePathCreateOptions options, Duration timeout2, Context context) {
        DataLakeFileClient dataLakeFileClient = this.getFileClient(fileName);
        Response<PathInfo> response = dataLakeFileClient.createIfNotExistsWithResponse(options, timeout2, context);
        return new SimpleResponse<DataLakeFileClient>(response, dataLakeFileClient);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void deleteFile(String fileName) {
        this.deleteFileWithResponse(fileName, null, null, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteFileWithResponse(String fileName, DataLakeRequestConditions requestConditions, Duration timeout2, Context context) {
        return this.getFileClient(fileName).deleteWithResponse(requestConditions, timeout2, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public boolean deleteFileIfExists(String fileName) {
        return this.deleteFileIfExistsWithResponse(fileName, new DataLakePathDeleteOptions().setRequestConditions(new DataLakeRequestConditions()), null, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Boolean> deleteFileIfExistsWithResponse(String fileName, DataLakePathDeleteOptions options, Duration timeout2, Context context) {
        return this.getFileClient(fileName).deleteIfExistsWithResponse(options, timeout2, context);
    }

    public DataLakeDirectoryClient getSubdirectoryClient(String subdirectoryName) {
        Objects.requireNonNull(subdirectoryName, "'subdirectoryName' can not be set to null");
        String pathPrefix = this.getObjectPath().isEmpty() ? "" : this.getObjectPath() + "/";
        BlockBlobClient blockBlobClient = this.prepareBuilderAppendPath(pathPrefix + subdirectoryName).buildBlockBlobClient();
        return new DataLakeDirectoryClient(this.dataLakeDirectoryAsyncClient.getSubdirectoryAsyncClient(subdirectoryName), blockBlobClient, this.getHttpPipeline(), this.getAccountUrl(), this.getServiceVersion(), this.getAccountName(), this.getFileSystemName(), pathPrefix + subdirectoryName, this.getSasToken(), this.getCpkInfo(), this.isTokenCredentialAuthenticated());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public DataLakeDirectoryClient createSubdirectory(String subdirectoryName) {
        return this.createSubdirectory(subdirectoryName, false);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public DataLakeDirectoryClient createSubdirectory(String subdirectoryName, boolean overwrite) {
        DataLakeRequestConditions requestConditions = new DataLakeRequestConditions();
        if (!overwrite) {
            requestConditions.setIfNoneMatch("*");
        }
        return this.createSubdirectoryWithResponse(subdirectoryName, new DataLakePathCreateOptions().setRequestConditions(requestConditions), null, null).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<DataLakeDirectoryClient> createSubdirectoryWithResponse(String subdirectoryName, String permissions, String umask, PathHttpHeaders headers, Map<String, String> metadata, DataLakeRequestConditions requestConditions, Duration timeout2, Context context) {
        DataLakePathCreateOptions options = new DataLakePathCreateOptions().setPermissions(permissions).setUmask(umask).setPathHttpHeaders(headers).setMetadata(metadata).setRequestConditions(requestConditions);
        return this.createSubdirectoryWithResponse(subdirectoryName, options, timeout2, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<DataLakeDirectoryClient> createSubdirectoryWithResponse(String subdirectoryName, DataLakePathCreateOptions options, Duration timeout2, Context context) {
        DataLakeDirectoryClient dataLakeDirectoryClient = this.getSubdirectoryClient(subdirectoryName);
        Response<PathInfo> response = dataLakeDirectoryClient.createWithResponse(options, timeout2, context);
        return new SimpleResponse<DataLakeDirectoryClient>(response, dataLakeDirectoryClient);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public DataLakeDirectoryClient createSubdirectoryIfNotExists(String subdirectoryName) {
        return this.createSubdirectoryIfNotExistsWithResponse(subdirectoryName, new DataLakePathCreateOptions(), null, null).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<DataLakeDirectoryClient> createSubdirectoryIfNotExistsWithResponse(String subdirectoryName, DataLakePathCreateOptions options, Duration timeout2, Context context) {
        DataLakeDirectoryClient dataLakeDirectoryClient = this.getSubdirectoryClient(subdirectoryName);
        Response<PathInfo> response = dataLakeDirectoryClient.createIfNotExistsWithResponse(options, timeout2, context);
        return new SimpleResponse<DataLakeDirectoryClient>(response, dataLakeDirectoryClient);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void deleteSubdirectory(String subdirectoryName) {
        this.deleteSubdirectoryWithResponse(subdirectoryName, false, null, null, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteSubdirectoryWithResponse(String subdirectoryName, boolean recursive, DataLakeRequestConditions requestConditions, Duration timeout2, Context context) {
        DataLakeDirectoryClient dataLakeDirectoryClient = this.getSubdirectoryClient(subdirectoryName);
        return dataLakeDirectoryClient.deleteWithResponse(recursive, requestConditions, timeout2, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public boolean deleteSubdirectoryIfExists(String subdirectoryName) {
        return this.deleteSubdirectoryIfExistsWithResponse(subdirectoryName, new DataLakePathDeleteOptions().setIsRecursive(false).setRequestConditions(new DataLakeRequestConditions()), null, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Boolean> deleteSubdirectoryIfExistsWithResponse(String subdirectoryName, DataLakePathDeleteOptions options, Duration timeout2, Context context) {
        DataLakeDirectoryClient dataLakeDirectoryClient = this.getSubdirectoryClient(subdirectoryName);
        return dataLakeDirectoryClient.deleteIfExistsWithResponse(options, timeout2, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public DataLakeDirectoryClient rename(String destinationFileSystem, String destinationPath) {
        return this.renameWithResponse(destinationFileSystem, destinationPath, null, null, null, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<DataLakeDirectoryClient> renameWithResponse(String destinationFileSystem, String destinationPath, DataLakeRequestConditions sourceRequestConditions, DataLakeRequestConditions destinationRequestConditions, Duration timeout2, Context context) {
        Response<DataLakePathClient> response = this.renameWithResponseWithTimeout(destinationFileSystem, destinationPath, sourceRequestConditions, destinationRequestConditions, timeout2, context);
        return new SimpleResponse<DataLakeDirectoryClient>(response, new DataLakeDirectoryClient(response.getValue()));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<PathItem> listPaths() {
        return this.listPaths(false, false, null, null);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<PathItem> listPaths(boolean recursive, boolean userPrincipleNameReturned, Integer maxResults, Duration timeout2) {
        BiFunction retriever = (marker, pageSize) -> {
            Callable<ResponseBase> operation = () -> this.fileSystemDataLakeStorage.getFileSystems().listPathsWithResponse(recursive, null, null, (String)marker, this.getDirectoryPath(), pageSize == null ? maxResults : pageSize, userPrincipleNameReturned, Context.NONE);
            ResponseBase response = StorageImplUtils.sendRequest(operation, timeout2, DataLakeStorageException.class);
            List value = response.getValue() == null ? Collections.emptyList() : ((PathList)response.getValue()).getPaths().stream().map(Transforms::toPathItem).collect(Collectors.toList());
            return new PagedResponseBase(response.getRequest(), response.getStatusCode(), response.getHeaders(), value, ((FileSystemsListPathsHeaders)response.getDeserializedHeaders()).getXMsContinuation(), (FileSystemsListPathsHeaders)response.getDeserializedHeaders());
        };
        return new PagedIterable<PathItem>(pageSize -> (PagedResponse)retriever.apply((String)null, (Integer)pageSize), retriever);
    }

    SpecializedBlobClientBuilder prepareBuilderAppendPath(String pathName) {
        String blobUrl = DataLakeImplUtils.endpointToDesiredEndpoint(this.getPathUrl(), "blob", "dfs");
        return new SpecializedBlobClientBuilder().pipeline(this.getHttpPipeline()).serviceVersion(TransformUtils.toBlobServiceVersion(this.getServiceVersion())).endpoint(blobUrl).blobName(pathName);
    }
}

