/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.storage.file.datalake;

import com.dataiku.dss.shadelibazure.com.azure.core.annotation.ReturnType;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.ServiceClient;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.ServiceMethod;
import com.dataiku.dss.shadelibazure.com.azure.core.credential.AzureSasCredential;
import com.dataiku.dss.shadelibazure.com.azure.core.http.HttpPipeline;
import com.dataiku.dss.shadelibazure.com.azure.core.http.HttpResponse;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedFlux;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedResponse;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedResponseBase;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.Response;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.ResponseBase;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.SimpleResponse;
import com.dataiku.dss.shadelibazure.com.azure.core.util.Context;
import com.dataiku.dss.shadelibazure.com.azure.core.util.CoreUtils;
import com.dataiku.dss.shadelibazure.com.azure.core.util.FluxUtil;
import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.storage.blob.BlobContainerAsyncClient;
import com.dataiku.dss.shadelibazure.com.azure.storage.blob.BlobContainerClientBuilder;
import com.dataiku.dss.shadelibazure.com.azure.storage.blob.BlobUrlParts;
import com.dataiku.dss.shadelibazure.com.azure.storage.blob.models.BlobContainerAccessPolicies;
import com.dataiku.dss.shadelibazure.com.azure.storage.blob.models.BlobContainerProperties;
import com.dataiku.dss.shadelibazure.com.azure.storage.blob.options.BlobContainerCreateOptions;
import com.dataiku.dss.shadelibazure.com.azure.storage.blob.specialized.BlockBlobAsyncClient;
import com.dataiku.dss.shadelibazure.com.azure.storage.common.implementation.SasImplUtils;
import com.dataiku.dss.shadelibazure.com.azure.storage.common.implementation.StorageImplUtils;
import com.dataiku.dss.shadelibazure.com.azure.storage.file.datalake.DataLakeDirectoryAsyncClient;
import com.dataiku.dss.shadelibazure.com.azure.storage.file.datalake.DataLakeFileAsyncClient;
import com.dataiku.dss.shadelibazure.com.azure.storage.file.datalake.DataLakeFileSystemClientBuilder;
import com.dataiku.dss.shadelibazure.com.azure.storage.file.datalake.DataLakePathAsyncClient;
import com.dataiku.dss.shadelibazure.com.azure.storage.file.datalake.DataLakeServiceVersion;
import com.dataiku.dss.shadelibazure.com.azure.storage.file.datalake.Transforms;
import com.dataiku.dss.shadelibazure.com.azure.storage.file.datalake.implementation.AzureDataLakeStorageRestAPIImpl;
import com.dataiku.dss.shadelibazure.com.azure.storage.file.datalake.implementation.AzureDataLakeStorageRestAPIImplBuilder;
import com.dataiku.dss.shadelibazure.com.azure.storage.file.datalake.implementation.models.FileSystemsListBlobHierarchySegmentHeaders;
import com.dataiku.dss.shadelibazure.com.azure.storage.file.datalake.implementation.models.FileSystemsListPathsHeaders;
import com.dataiku.dss.shadelibazure.com.azure.storage.file.datalake.implementation.models.ListBlobsHierarchySegmentResponse;
import com.dataiku.dss.shadelibazure.com.azure.storage.file.datalake.implementation.models.ListBlobsShowOnly;
import com.dataiku.dss.shadelibazure.com.azure.storage.file.datalake.implementation.models.PathList;
import com.dataiku.dss.shadelibazure.com.azure.storage.file.datalake.implementation.models.PathResourceType;
import com.dataiku.dss.shadelibazure.com.azure.storage.file.datalake.implementation.models.PathsUndeleteHeaders;
import com.dataiku.dss.shadelibazure.com.azure.storage.file.datalake.implementation.util.DataLakeImplUtils;
import com.dataiku.dss.shadelibazure.com.azure.storage.file.datalake.implementation.util.DataLakeSasImplUtil;
import com.dataiku.dss.shadelibazure.com.azure.storage.file.datalake.implementation.util.TransformUtils;
import com.dataiku.dss.shadelibazure.com.azure.storage.file.datalake.models.DataLakeRequestConditions;
import com.dataiku.dss.shadelibazure.com.azure.storage.file.datalake.models.DataLakeSignedIdentifier;
import com.dataiku.dss.shadelibazure.com.azure.storage.file.datalake.models.DataLakeStorageException;
import com.dataiku.dss.shadelibazure.com.azure.storage.file.datalake.models.FileSystemAccessPolicies;
import com.dataiku.dss.shadelibazure.com.azure.storage.file.datalake.models.FileSystemProperties;
import com.dataiku.dss.shadelibazure.com.azure.storage.file.datalake.models.ListPathsOptions;
import com.dataiku.dss.shadelibazure.com.azure.storage.file.datalake.models.PathDeletedItem;
import com.dataiku.dss.shadelibazure.com.azure.storage.file.datalake.models.PathHttpHeaders;
import com.dataiku.dss.shadelibazure.com.azure.storage.file.datalake.models.PathItem;
import com.dataiku.dss.shadelibazure.com.azure.storage.file.datalake.models.PublicAccessType;
import com.dataiku.dss.shadelibazure.com.azure.storage.file.datalake.models.UserDelegationKey;
import com.dataiku.dss.shadelibazure.com.azure.storage.file.datalake.options.DataLakePathCreateOptions;
import com.dataiku.dss.shadelibazure.com.azure.storage.file.datalake.options.DataLakePathDeleteOptions;
import com.dataiku.dss.shadelibazure.com.azure.storage.file.datalake.sas.DataLakeServiceSasSignatureValues;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Mono;
import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@ServiceClient(builder=DataLakeFileSystemClientBuilder.class, isAsync=true)
public class DataLakeFileSystemAsyncClient {
    public static final String ROOT_FILESYSTEM_NAME = "$root";
    public static final String ROOT_DIRECTORY_NAME = "";
    private static final ClientLogger LOGGER = new ClientLogger(DataLakeFileSystemAsyncClient.class);
    private final AzureDataLakeStorageRestAPIImpl azureDataLakeStorage;
    private final AzureDataLakeStorageRestAPIImpl blobDataLakeStorageFs;
    private final BlobContainerAsyncClient blobContainerAsyncClient;
    private final String accountName;
    private final String fileSystemName;
    private final DataLakeServiceVersion serviceVersion;
    private final AzureSasCredential sasToken;
    private final boolean isTokenCredentialAuthenticated;

    DataLakeFileSystemAsyncClient(HttpPipeline pipeline, String url, DataLakeServiceVersion serviceVersion, String accountName, String fileSystemName, BlobContainerAsyncClient blobContainerAsyncClient, AzureSasCredential sasToken, boolean isTokenCredentialAuthenticated) {
        this.azureDataLakeStorage = new AzureDataLakeStorageRestAPIImplBuilder().pipeline(pipeline).url(url).fileSystem(fileSystemName).version(serviceVersion.getVersion()).buildClient();
        String blobUrl = DataLakeImplUtils.endpointToDesiredEndpoint(url, "blob", "dfs");
        this.blobDataLakeStorageFs = new AzureDataLakeStorageRestAPIImplBuilder().pipeline(pipeline).url(blobUrl).fileSystem(fileSystemName).version(serviceVersion.getVersion()).buildClient();
        this.serviceVersion = serviceVersion;
        this.accountName = accountName;
        this.fileSystemName = fileSystemName;
        this.blobContainerAsyncClient = blobContainerAsyncClient;
        this.sasToken = sasToken;
        this.isTokenCredentialAuthenticated = isTokenCredentialAuthenticated;
    }

    public DataLakeFileAsyncClient getFileAsyncClient(String fileName) {
        Objects.requireNonNull(fileName, "'fileName' can not be set to null");
        BlockBlobAsyncClient blockBlobAsyncClient = this.blobContainerAsyncClient.getBlobAsyncClient(fileName, null).getBlockBlobAsyncClient();
        return new DataLakeFileAsyncClient(this.getHttpPipeline(), this.getAccountUrl(), this.getServiceVersion(), this.getAccountName(), this.getFileSystemName(), fileName, blockBlobAsyncClient, this.sasToken, Transforms.fromBlobCpkInfo(this.blobContainerAsyncClient.getCustomerProvidedKey()), this.isTokenCredentialAuthenticated);
    }

    public DataLakeDirectoryAsyncClient getDirectoryAsyncClient(String directoryName) {
        Objects.requireNonNull(directoryName, "'directoryName' can not be set to null");
        BlockBlobAsyncClient blockBlobAsyncClient = this.blobContainerAsyncClient.getBlobAsyncClient(directoryName, null).getBlockBlobAsyncClient();
        return new DataLakeDirectoryAsyncClient(this.getHttpPipeline(), this.getAccountUrl(), this.getServiceVersion(), this.getAccountName(), this.getFileSystemName(), directoryName, blockBlobAsyncClient, this.sasToken, Transforms.fromBlobCpkInfo(this.blobContainerAsyncClient.getCustomerProvidedKey()), this.isTokenCredentialAuthenticated);
    }

    DataLakeDirectoryAsyncClient getRootDirectoryAsyncClient() {
        return this.getDirectoryAsyncClient(ROOT_DIRECTORY_NAME);
    }

    public String getAccountUrl() {
        return this.azureDataLakeStorage.getUrl();
    }

    public String getFileSystemUrl() {
        return this.azureDataLakeStorage.getUrl() + "/" + this.fileSystemName;
    }

    public String getFileSystemName() {
        return this.fileSystemName;
    }

    public String getAccountName() {
        return this.accountName;
    }

    public DataLakeServiceVersion getServiceVersion() {
        return this.serviceVersion;
    }

    public HttpPipeline getHttpPipeline() {
        return this.azureDataLakeStorage.getHttpPipeline();
    }

    BlobContainerAsyncClient getBlobContainerAsyncClient() {
        return this.blobContainerAsyncClient;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> create() {
        return this.createWithResponse(null, null).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> createWithResponse(Map<String, String> metadata, PublicAccessType accessType) {
        return this.blobContainerAsyncClient.createWithResponse(metadata, Transforms.toBlobPublicAccessType(accessType)).onErrorMap(DataLakeImplUtils::transformBlobStorageException);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Boolean> createIfNotExists() {
        return this.createIfNotExistsWithResponse(null, null).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Boolean>> createIfNotExistsWithResponse(Map<String, String> metadata, PublicAccessType accessType) {
        try {
            BlobContainerCreateOptions options = new BlobContainerCreateOptions().setMetadata(metadata).setPublicAccessType(Transforms.toBlobPublicAccessType(accessType));
            return this.blobContainerAsyncClient.createIfNotExistsWithResponse(options).map(response -> new SimpleResponse<Boolean>((Response<?>)response, true)).onErrorMap(DataLakeImplUtils::transformBlobStorageException);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError(LOGGER, ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> delete() {
        return this.deleteWithResponse(null).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteWithResponse(DataLakeRequestConditions requestConditions) {
        return this.blobContainerAsyncClient.deleteWithResponse(Transforms.toBlobRequestConditions(requestConditions)).onErrorMap(DataLakeImplUtils::transformBlobStorageException);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Boolean> deleteIfExists() {
        return this.deleteIfExistsWithResponse(new DataLakePathDeleteOptions()).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Boolean>> deleteIfExistsWithResponse(DataLakePathDeleteOptions options) {
        try {
            options = options == null ? new DataLakePathDeleteOptions() : options;
            return this.blobContainerAsyncClient.deleteIfExistsWithResponse(Transforms.toBlobRequestConditions(options.getRequestConditions())).map(response -> new SimpleResponse<Boolean>((Response<?>)response, true)).onErrorMap(DataLakeImplUtils::transformBlobStorageException);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError(LOGGER, ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<FileSystemProperties> getProperties() {
        return this.getPropertiesWithResponse(null).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<FileSystemProperties>> getPropertiesWithResponse(String leaseId) {
        return this.blobContainerAsyncClient.getPropertiesWithResponse(leaseId).onErrorMap(DataLakeImplUtils::transformBlobStorageException).map(response -> new SimpleResponse<FileSystemProperties>((Response<?>)response, Transforms.toFileSystemProperties((BlobContainerProperties)response.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Boolean> exists() {
        return this.existsWithResponse().flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Boolean>> existsWithResponse() {
        return this.blobContainerAsyncClient.existsWithResponse().onErrorMap(DataLakeImplUtils::transformBlobStorageException);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> setMetadata(Map<String, String> metadata) {
        return this.setMetadataWithResponse(metadata, null).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> setMetadataWithResponse(Map<String, String> metadata, DataLakeRequestConditions requestConditions) {
        return this.blobContainerAsyncClient.setMetadataWithResponse(metadata, Transforms.toBlobRequestConditions(requestConditions)).onErrorMap(DataLakeImplUtils::transformBlobStorageException);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<PathItem> listPaths() {
        return this.listPaths(new ListPathsOptions());
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<PathItem> listPaths(ListPathsOptions options) {
        try {
            return this.listPathsWithOptionalTimeout(options, null);
        }
        catch (RuntimeException ex) {
            return FluxUtil.pagedFluxError(LOGGER, ex);
        }
    }

    PagedFlux<PathItem> listPathsWithOptionalTimeout(ListPathsOptions options, Duration timeout2) {
        BiFunction func = (marker, pageSize) -> {
            ListPathsOptions finalOptions = pageSize != null ? (options == null ? new ListPathsOptions().setMaxResults((Integer)pageSize) : new ListPathsOptions().setMaxResults((Integer)pageSize).setPath(options.getPath()).setRecursive(options.isRecursive()).setUserPrincipalNameReturned(options.isUserPrincipalNameReturned())) : options;
            return this.listPathsSegment((String)marker, finalOptions, timeout2).map(response -> {
                List value = response.getValue() == null ? Collections.emptyList() : ((PathList)response.getValue()).getPaths().stream().map(Transforms::toPathItem).collect(Collectors.toList());
                return new PagedResponseBase(response.getRequest(), response.getStatusCode(), response.getHeaders(), value, ((FileSystemsListPathsHeaders)response.getDeserializedHeaders()).getXMsContinuation(), (FileSystemsListPathsHeaders)response.getDeserializedHeaders());
            });
        };
        return new PagedFlux<PathItem>(pageSize -> (Mono)func.apply((String)null, (Integer)pageSize), func);
    }

    private Mono<ResponseBase<FileSystemsListPathsHeaders, PathList>> listPathsSegment(String marker, ListPathsOptions options, Duration timeout2) {
        options = options == null ? new ListPathsOptions() : options;
        return StorageImplUtils.applyOptionalTimeout(this.azureDataLakeStorage.getFileSystems().listPathsWithResponseAsync(options.isRecursive(), null, null, marker, options.getPath(), options.getMaxResults(), options.isUserPrincipalNameReturned(), Context.NONE), timeout2);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<PathDeletedItem> listDeletedPaths() {
        return this.listDeletedPaths(null);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<PathDeletedItem> listDeletedPaths(String prefix) {
        try {
            return new PagedFlux<PathDeletedItem>(pageSize -> FluxUtil.withContext(context -> this.listDeletedPaths(null, (Integer)pageSize, prefix, null, (Context)context)), (marker, pageSize) -> FluxUtil.withContext(context -> this.listDeletedPaths((String)marker, (Integer)pageSize, prefix, null, (Context)context)));
        }
        catch (RuntimeException ex) {
            return FluxUtil.pagedFluxError(LOGGER, ex);
        }
    }

    PagedFlux<PathDeletedItem> listDeletedPathsWithOptionalTimeout(String prefix, Duration timeout2, Context context) {
        return new PagedFlux<PathDeletedItem>(pageSize -> this.listDeletedPaths(null, (Integer)pageSize, prefix, timeout2, context), (marker, pageSize) -> this.listDeletedPaths((String)marker, (Integer)pageSize, prefix, timeout2, context));
    }

    private Mono<PagedResponse<PathDeletedItem>> listDeletedPaths(String marker, Integer pageSize, String prefix, Duration timeout2, Context context) {
        return this.listDeletedPathsSegment(marker, prefix, pageSize, timeout2, context).map(response -> {
            List value = ((ListBlobsHierarchySegmentResponse)response.getValue()).getSegment() == null ? Collections.emptyList() : Stream.concat(((ListBlobsHierarchySegmentResponse)response.getValue()).getSegment().getBlobItems().stream().map(Transforms::toPathDeletedItem), ((ListBlobsHierarchySegmentResponse)response.getValue()).getSegment().getBlobPrefixes().stream().map(Transforms::toPathDeletedItem)).collect(Collectors.toList());
            return new PagedResponseBase(response.getRequest(), response.getStatusCode(), response.getHeaders(), value, ((ListBlobsHierarchySegmentResponse)response.getValue()).getNextMarker(), (FileSystemsListBlobHierarchySegmentHeaders)response.getDeserializedHeaders());
        });
    }

    private Mono<ResponseBase<FileSystemsListBlobHierarchySegmentHeaders, ListBlobsHierarchySegmentResponse>> listDeletedPathsSegment(String marker, String prefix, Integer maxResults, Duration timeout2, Context context) {
        context = context == null ? Context.NONE : context;
        return StorageImplUtils.applyOptionalTimeout(this.blobDataLakeStorageFs.getFileSystems().listBlobHierarchySegmentWithResponseAsync(prefix, null, marker, maxResults, null, ListBlobsShowOnly.DELETED, null, null, context), timeout2);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<DataLakeFileAsyncClient> createFile(String fileName) {
        return this.createFile(fileName, false);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<DataLakeFileAsyncClient> createFile(String fileName, boolean overwrite) {
        DataLakeRequestConditions requestConditions = new DataLakeRequestConditions();
        if (!overwrite) {
            requestConditions.setIfNoneMatch("*");
        }
        return this.createFileWithResponse(fileName, new DataLakePathCreateOptions().setRequestConditions(requestConditions)).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<DataLakeFileAsyncClient>> createFileWithResponse(String fileName, String permissions, String umask, PathHttpHeaders headers, Map<String, String> metadata, DataLakeRequestConditions requestConditions) {
        DataLakePathCreateOptions options = new DataLakePathCreateOptions().setPermissions(permissions).setUmask(umask).setPathHttpHeaders(headers).setMetadata(metadata).setRequestConditions(requestConditions);
        return this.createFileWithResponse(fileName, options);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<DataLakeFileAsyncClient>> createFileWithResponse(String fileName, DataLakePathCreateOptions options) {
        try {
            DataLakeFileAsyncClient dataLakeFileAsyncClient = this.getFileAsyncClient(fileName);
            return dataLakeFileAsyncClient.createWithResponse(options).map(response -> new SimpleResponse<DataLakeFileAsyncClient>((Response<?>)response, dataLakeFileAsyncClient));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError(LOGGER, ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<DataLakeFileAsyncClient> createFileIfNotExists(String fileName) {
        return this.createFileIfNotExistsWithResponse(fileName, new DataLakePathCreateOptions()).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<DataLakeFileAsyncClient>> createFileIfNotExistsWithResponse(String fileName, DataLakePathCreateOptions options) {
        options = options == null ? new DataLakePathCreateOptions() : options;
        options.setRequestConditions(new DataLakeRequestConditions().setIfNoneMatch("*"));
        try {
            return this.createFileWithResponse(fileName, options).onErrorResume(t -> t instanceof DataLakeStorageException && ((DataLakeStorageException)t).getStatusCode() == 409, t -> {
                HttpResponse response = ((DataLakeStorageException)t).getResponse();
                return Mono.just(new SimpleResponse<DataLakeFileAsyncClient>(response.getRequest(), response.getStatusCode(), response.getHeaders(), this.getFileAsyncClient(fileName)));
            });
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError(LOGGER, ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteFile(String fileName) {
        return this.deleteFileWithResponse(fileName, null).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteFileWithResponse(String fileName, DataLakeRequestConditions requestConditions) {
        DataLakeFileAsyncClient dataLakeFileAsyncClient;
        try {
            dataLakeFileAsyncClient = this.getFileAsyncClient(fileName);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError(LOGGER, ex);
        }
        return dataLakeFileAsyncClient.deleteWithResponse(requestConditions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Boolean> deleteFileIfExists(String fileName) {
        return this.deleteFileIfExistsWithResponse(fileName, new DataLakePathDeleteOptions()).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Boolean>> deleteFileIfExistsWithResponse(String fileName, DataLakePathDeleteOptions options) {
        try {
            return this.getFileAsyncClient(fileName).deleteIfExistsWithResponse(options);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError(LOGGER, ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<DataLakeDirectoryAsyncClient> createDirectory(String directoryName) {
        return this.createDirectory(directoryName, false);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<DataLakeDirectoryAsyncClient> createDirectory(String directoryName, boolean overwrite) {
        DataLakeRequestConditions requestConditions = new DataLakeRequestConditions();
        if (!overwrite) {
            requestConditions.setIfNoneMatch("*");
        }
        return this.createDirectoryWithResponse(directoryName, new DataLakePathCreateOptions().setRequestConditions(requestConditions)).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<DataLakeDirectoryAsyncClient>> createDirectoryWithResponse(String directoryName, String permissions, String umask, PathHttpHeaders headers, Map<String, String> metadata, DataLakeRequestConditions requestConditions) {
        DataLakePathCreateOptions options = new DataLakePathCreateOptions().setPermissions(permissions).setUmask(umask).setPathHttpHeaders(headers).setMetadata(metadata).setRequestConditions(requestConditions);
        try {
            return this.createDirectoryWithResponse(directoryName, options);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError(LOGGER, ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<DataLakeDirectoryAsyncClient>> createDirectoryWithResponse(String directoryName, DataLakePathCreateOptions options) {
        try {
            DataLakeDirectoryAsyncClient dataLakeDirectoryAsyncClient = this.getDirectoryAsyncClient(directoryName);
            return dataLakeDirectoryAsyncClient.createWithResponse(options).map(response -> new SimpleResponse<DataLakeDirectoryAsyncClient>((Response<?>)response, dataLakeDirectoryAsyncClient));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError(LOGGER, ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<DataLakeDirectoryAsyncClient> createDirectoryIfNotExists(String directoryName) {
        return this.createDirectoryIfNotExistsWithResponse(directoryName, new DataLakePathCreateOptions()).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<DataLakeDirectoryAsyncClient>> createDirectoryIfNotExistsWithResponse(String directoryName, DataLakePathCreateOptions options) {
        options = options == null ? new DataLakePathCreateOptions() : options;
        options.setRequestConditions(new DataLakeRequestConditions().setIfNoneMatch("*"));
        try {
            return this.createDirectoryWithResponse(directoryName, options).onErrorResume(t -> t instanceof DataLakeStorageException && ((DataLakeStorageException)t).getStatusCode() == 409, t -> {
                HttpResponse response = ((DataLakeStorageException)t).getResponse();
                return Mono.just(new SimpleResponse<DataLakeDirectoryAsyncClient>(response.getRequest(), response.getStatusCode(), response.getHeaders(), this.getDirectoryAsyncClient(directoryName)));
            });
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError(LOGGER, ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteDirectory(String directoryName) {
        return this.deleteDirectoryWithResponse(directoryName, false, null).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteDirectoryWithResponse(String directoryName, boolean recursive, DataLakeRequestConditions requestConditions) {
        DataLakeDirectoryAsyncClient dataLakeDirectoryAsyncClient;
        try {
            dataLakeDirectoryAsyncClient = this.getDirectoryAsyncClient(directoryName);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError(LOGGER, ex);
        }
        return dataLakeDirectoryAsyncClient.deleteWithResponse(recursive, requestConditions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Boolean> deleteDirectoryIfExists(String directoryName) {
        return this.deleteDirectoryIfExistsWithResponse(directoryName, new DataLakePathDeleteOptions()).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Boolean>> deleteDirectoryIfExistsWithResponse(String directoryName, DataLakePathDeleteOptions options) {
        try {
            return this.getDirectoryAsyncClient(directoryName).deleteIfExistsWithResponse(options);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError(LOGGER, ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<DataLakePathAsyncClient> undeletePath(String deletedPath, String deletionId) {
        return this.undeletePathWithResponse(deletedPath, deletionId).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<DataLakePathAsyncClient>> undeletePathWithResponse(String deletedPath, String deletionId) {
        try {
            return FluxUtil.withContext(context -> this.undeletePathWithResponse(deletedPath, deletionId, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError(LOGGER, ex);
        }
    }

    Mono<Response<DataLakePathAsyncClient>> undeletePathWithResponse(String deletedPath, String deletionId, Context context) {
        Objects.requireNonNull(deletedPath);
        Objects.requireNonNull(deletionId);
        context = context == null ? Context.NONE : context;
        String blobUrl = DataLakeImplUtils.endpointToDesiredEndpoint(this.blobDataLakeStorageFs.getUrl(), "blob", "dfs");
        AzureDataLakeStorageRestAPIImpl blobDataLakeStoragePath = new AzureDataLakeStorageRestAPIImplBuilder().pipeline(this.blobDataLakeStorageFs.getHttpPipeline()).url(blobUrl).fileSystem(this.blobDataLakeStorageFs.getFileSystem()).path(deletedPath).version(this.serviceVersion.getVersion()).buildClient();
        return blobDataLakeStoragePath.getPaths().undeleteWithResponseAsync(null, String.format("?%s=%s", "deletionid", deletionId), null, context).onErrorMap(DataLakeImplUtils::transformBlobStorageException).map(response -> {
            DataLakePathAsyncClient client = new DataLakePathAsyncClient(this.getHttpPipeline(), this.getAccountUrl(), this.serviceVersion, this.accountName, this.fileSystemName, deletedPath, PathResourceType.fromString(((PathsUndeleteHeaders)response.getDeserializedHeaders()).getXMsResourceType()), this.blobContainerAsyncClient.getBlobAsyncClient(deletedPath, null).getBlockBlobAsyncClient(), this.sasToken, Transforms.fromBlobCpkInfo(this.blobContainerAsyncClient.getCustomerProvidedKey()), this.isTokenCredentialAuthenticated);
            if (PathResourceType.DIRECTORY.equals((Object)client.pathResourceType)) {
                return new SimpleResponse<DataLakeDirectoryAsyncClient>((Response<?>)response, new DataLakeDirectoryAsyncClient(client));
            }
            if (PathResourceType.FILE.equals((Object)client.pathResourceType)) {
                return new SimpleResponse<DataLakeFileAsyncClient>((Response<?>)response, new DataLakeFileAsyncClient(client));
            }
            throw LOGGER.logExceptionAsError(new IllegalStateException("'pathClient' expected to be either a file or directory client."));
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> setAccessPolicy(PublicAccessType accessType, List<DataLakeSignedIdentifier> identifiers) {
        return this.setAccessPolicyWithResponse(accessType, identifiers, null).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> setAccessPolicyWithResponse(PublicAccessType accessType, List<DataLakeSignedIdentifier> identifiers, DataLakeRequestConditions requestConditions) {
        return this.blobContainerAsyncClient.setAccessPolicyWithResponse(Transforms.toBlobPublicAccessType(accessType), Transforms.toBlobIdentifierList(identifiers), Transforms.toBlobRequestConditions(requestConditions)).onErrorMap(DataLakeImplUtils::transformBlobStorageException);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<FileSystemAccessPolicies> getAccessPolicy() {
        return this.getAccessPolicyWithResponse(null).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<FileSystemAccessPolicies>> getAccessPolicyWithResponse(String leaseId) {
        return this.blobContainerAsyncClient.getAccessPolicyWithResponse(leaseId).onErrorMap(DataLakeImplUtils::transformBlobStorageException).map(response -> new SimpleResponse<FileSystemAccessPolicies>((Response<?>)response, Transforms.toFileSystemAccessPolicies((BlobContainerAccessPolicies)response.getValue())));
    }

    BlobContainerClientBuilder prepareBuilderReplacePath(String destinationFileSystem) {
        if (CoreUtils.isNullOrEmpty(destinationFileSystem)) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException("'destinationFileSystem' can not be set to null"));
        }
        String newBlobEndpoint = BlobUrlParts.parse(DataLakeImplUtils.endpointToDesiredEndpoint(this.getFileSystemUrl(), "blob", "dfs")).setContainerName(destinationFileSystem).toUrl().toString();
        return new BlobContainerClientBuilder().pipeline(this.getHttpPipeline()).endpoint(newBlobEndpoint).serviceVersion(TransformUtils.toBlobServiceVersion(this.getServiceVersion()));
    }

    public String generateUserDelegationSas(DataLakeServiceSasSignatureValues dataLakeServiceSasSignatureValues, UserDelegationKey userDelegationKey) {
        return this.generateUserDelegationSas(dataLakeServiceSasSignatureValues, userDelegationKey, this.getAccountName(), Context.NONE);
    }

    public String generateUserDelegationSas(DataLakeServiceSasSignatureValues dataLakeServiceSasSignatureValues, UserDelegationKey userDelegationKey, String accountName, Context context) {
        return this.generateUserDelegationSas(dataLakeServiceSasSignatureValues, userDelegationKey, accountName, null, context);
    }

    public String generateUserDelegationSas(DataLakeServiceSasSignatureValues dataLakeServiceSasSignatureValues, UserDelegationKey userDelegationKey, String accountName, Consumer<String> stringToSignHandler, Context context) {
        return new DataLakeSasImplUtil(dataLakeServiceSasSignatureValues, this.getFileSystemName()).generateUserDelegationSas(userDelegationKey, accountName, stringToSignHandler, context);
    }

    public String generateSas(DataLakeServiceSasSignatureValues dataLakeServiceSasSignatureValues) {
        return this.generateSas(dataLakeServiceSasSignatureValues, Context.NONE);
    }

    public String generateSas(DataLakeServiceSasSignatureValues dataLakeServiceSasSignatureValues, Context context) {
        return this.generateSas(dataLakeServiceSasSignatureValues, null, context);
    }

    public String generateSas(DataLakeServiceSasSignatureValues dataLakeServiceSasSignatureValues, Consumer<String> stringToSignHandler, Context context) {
        return new DataLakeSasImplUtil(dataLakeServiceSasSignatureValues, this.getFileSystemName()).generateSas(SasImplUtils.extractSharedKeyCredential(this.getHttpPipeline()), stringToSignHandler, context);
    }
}

