/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.storage.file.datalake.models;

import com.dataiku.dss.shadelibazure.com.azure.storage.common.implementation.StorageImplUtils;
import com.dataiku.dss.shadelibazure.com.azure.storage.file.datalake.models.AccessControlType;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class PathRemoveAccessControlEntry {
    private boolean defaultScope;
    private AccessControlType accessControlType = new AccessControlType();
    private String entityId;

    public boolean isDefaultScope() {
        return this.defaultScope;
    }

    public PathRemoveAccessControlEntry setDefaultScope(boolean defaultScope) {
        this.defaultScope = defaultScope;
        return this;
    }

    public AccessControlType getAccessControlType() {
        return this.accessControlType;
    }

    public PathRemoveAccessControlEntry setAccessControlType(AccessControlType accessControlType) {
        this.accessControlType = accessControlType;
        return this;
    }

    public String getEntityId() {
        return this.entityId;
    }

    public PathRemoveAccessControlEntry setEntityId(String entityId) {
        this.entityId = entityId;
        return this;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        if (this.defaultScope) {
            builder.append("default");
            builder.append(":");
        }
        builder.append(this.accessControlType.toString().toLowerCase(Locale.ROOT));
        builder.append(':');
        builder.append(this.entityId == null ? "" : this.entityId);
        return builder.toString();
    }

    public static PathRemoveAccessControlEntry parse(String str) {
        PathRemoveAccessControlEntry res = new PathRemoveAccessControlEntry();
        String[] parts = str.split(":");
        int indexOffset = 0;
        StorageImplUtils.assertInBounds("parts.length", parts.length, 1L, 3L);
        if (parts.length == 3) {
            if (!parts[0].equals("default")) {
                throw new IllegalArgumentException("Scope must be default or otherwise omitted");
            }
            res.defaultScope = true;
            indexOffset = 1;
        }
        res.accessControlType = AccessControlType.fromString(parts[indexOffset]);
        res.entityId = 1 + indexOffset < parts.length && !parts[1 + indexOffset].equals("") ? parts[1 + indexOffset] : null;
        return res;
    }

    public static String serializeList(List<PathRemoveAccessControlEntry> acl) {
        StringBuilder sb = new StringBuilder();
        for (PathRemoveAccessControlEntry entry : acl) {
            sb.append(entry.toString());
            sb.append(',');
        }
        sb.deleteCharAt(sb.length() - 1);
        return sb.toString();
    }

    public static List<PathRemoveAccessControlEntry> parseList(String str) {
        String[] strs = str.split(",");
        ArrayList<PathRemoveAccessControlEntry> acl = new ArrayList<PathRemoveAccessControlEntry>(strs.length);
        for (String entry : strs) {
            acl.add(PathRemoveAccessControlEntry.parse(entry));
        }
        return acl;
    }
}

