/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.storage.file.datalake.models;

import com.dataiku.dss.shadelibazure.com.azure.storage.common.implementation.StorageImplUtils;

public class RolePermissions {
    private static final String ROLE_PERMISSIONS_FORMAT_ERROR = "Invalid format for role permissions";
    private boolean readPermission = false;
    private boolean writePermission = false;
    private boolean executePermission = false;

    public RolePermissions() {
    }

    RolePermissions(RolePermissions other) {
        this.readPermission = other.readPermission;
        this.writePermission = other.writePermission;
        this.executePermission = other.executePermission;
    }

    public static RolePermissions parseOctal(int octal) {
        RolePermissions res = new RolePermissions();
        StorageImplUtils.assertInBounds("octal", octal, 0L, 7L);
        if (octal / 4 > 0) {
            res.readPermission = true;
        }
        if ((octal %= 4) / 2 > 0) {
            res.writePermission = true;
        }
        if ((octal %= 2) > 0) {
            res.executePermission = true;
        }
        return res;
    }

    public static RolePermissions parseSymbolic(String str, boolean allowStickyBit) {
        StorageImplUtils.assertNotNull("str", str);
        StorageImplUtils.assertInBounds("str.length", str.length(), 3L, 3L);
        RolePermissions res = new RolePermissions();
        IllegalArgumentException ex = new IllegalArgumentException(ROLE_PERMISSIONS_FORMAT_ERROR);
        if (str.charAt(0) == 'r') {
            res.readPermission = true;
        } else if (str.charAt(0) != '-') {
            throw ex;
        }
        if (str.charAt(1) == 'w') {
            res.writePermission = true;
        } else if (str.charAt(1) != '-') {
            throw ex;
        }
        if (str.charAt(2) == 'x') {
            res.executePermission = true;
        } else if (allowStickyBit) {
            if (str.charAt(2) == 't') {
                res.executePermission = true;
            } else if (str.charAt(2) != 'T' && str.charAt(2) != '-') {
                throw ex;
            }
        } else if (str.charAt(2) != '-') {
            throw ex;
        }
        return res;
    }

    public String toOctal() {
        int res = 0;
        if (this.readPermission) {
            res |= 4;
        }
        if (this.writePermission) {
            res |= 2;
        }
        if (this.executePermission) {
            res |= 1;
        }
        return "" + res;
    }

    public String toSymbolic() {
        StringBuilder sb = new StringBuilder();
        if (this.readPermission) {
            sb.append('r');
        } else {
            sb.append('-');
        }
        if (this.writePermission) {
            sb.append('w');
        } else {
            sb.append('-');
        }
        if (this.executePermission) {
            sb.append('x');
        } else {
            sb.append('-');
        }
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RolePermissions that = (RolePermissions)o;
        if (this.readPermission != that.readPermission) {
            return false;
        }
        if (this.writePermission != that.writePermission) {
            return false;
        }
        return this.executePermission == that.executePermission;
    }

    public int hashCode() {
        int result = this.readPermission ? 1 : 0;
        result = 31 * result + (this.writePermission ? 1 : 0);
        result = 31 * result + (this.executePermission ? 1 : 0);
        return result;
    }

    public boolean hasReadPermission() {
        return this.readPermission;
    }

    public boolean hasWritePermission() {
        return this.writePermission;
    }

    public boolean hasExecutePermission() {
        return this.executePermission;
    }

    public RolePermissions setReadPermission(boolean hasReadPermission) {
        this.readPermission = hasReadPermission;
        return this;
    }

    public RolePermissions setWritePermission(boolean hasWritePermission) {
        this.writePermission = hasWritePermission;
        return this;
    }

    public RolePermissions setExecutePermission(boolean hasExecutePermission) {
        this.executePermission = hasExecutePermission;
        return this;
    }
}

