/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.storage.file.share.models;

import com.dataiku.dss.shadelibazure.com.azure.core.http.HttpHeaderName;
import com.dataiku.dss.shadelibazure.com.azure.core.http.HttpHeaders;
import com.dataiku.dss.shadelibazure.com.azure.storage.file.share.implementation.accesshelpers.FilePosixPropertiesHelper;
import com.dataiku.dss.shadelibazure.com.azure.storage.file.share.models.NfsFileType;

public final class FilePosixProperties {
    private String fileMode;
    private String owner;
    private String group;
    private final NfsFileType fileType;
    private final Long linkCount;

    public FilePosixProperties() {
        this.fileType = null;
        this.linkCount = null;
    }

    public String getFileMode() {
        return this.fileMode;
    }

    public String getOwner() {
        return this.owner;
    }

    public String getGroup() {
        return this.group;
    }

    public NfsFileType getFileType() {
        return this.fileType;
    }

    public Long getLinkCount() {
        return this.linkCount;
    }

    public FilePosixProperties setFileMode(String fileMode) {
        this.fileMode = fileMode;
        return this;
    }

    public FilePosixProperties setOwner(String owner) {
        this.owner = owner;
        return this;
    }

    public FilePosixProperties setGroup(String group) {
        this.group = group;
        return this;
    }

    FilePosixProperties(HttpHeaders httpHeaders) {
        Long linkCountValue;
        String tempFileMode = httpHeaders.getValue(HttpHeaderName.fromString("x-ms-mode"));
        String tempOwner = httpHeaders.getValue(HttpHeaderName.fromString("x-ms-owner"));
        String tempGroup = httpHeaders.getValue(HttpHeaderName.fromString("x-ms-group"));
        String tempFileType = httpHeaders.getValue(HttpHeaderName.fromString("x-ms-file-file-type"));
        String tempLinkCount = httpHeaders.getValue(HttpHeaderName.fromString("x-ms-link-count"));
        try {
            linkCountValue = tempLinkCount == null ? null : Long.valueOf(tempLinkCount);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Unable to convert value of header x-ms-link-count \"" + tempLinkCount + "\" to Long. ", e);
        }
        this.fileMode = tempFileMode;
        this.owner = tempOwner;
        this.group = tempGroup;
        this.fileType = NfsFileType.fromString(tempFileType);
        this.linkCount = linkCountValue;
    }

    static {
        FilePosixPropertiesHelper.setAccessor(FilePosixProperties::new);
    }
}

