/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.storage.file.share.models;

import com.dataiku.dss.shadelibazure.com.azure.storage.common.implementation.StorageImplUtils;
import com.dataiku.dss.shadelibazure.com.azure.storage.file.share.models.FileLastWrittenMode;
import com.dataiku.dss.shadelibazure.com.azure.storage.file.share.models.ShareRequestConditions;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Flux;
import java.io.InputStream;
import java.nio.ByteBuffer;

public final class ShareFileUploadRangeOptions {
    private final Flux<ByteBuffer> dataFlux;
    private final InputStream dataStream;
    private final long length;
    private Long offset;
    private ShareRequestConditions requestConditions;
    private FileLastWrittenMode lastWrittenMode;

    public ShareFileUploadRangeOptions(Flux<ByteBuffer> dataFlux, long length) {
        StorageImplUtils.assertNotNull("dataFlux", dataFlux);
        StorageImplUtils.assertInBounds("length", length, 0L, Long.MAX_VALUE);
        this.dataFlux = dataFlux;
        this.dataStream = null;
        this.length = length;
    }

    public ShareFileUploadRangeOptions(InputStream dataStream, long length) {
        StorageImplUtils.assertNotNull("dataStream", length);
        StorageImplUtils.assertInBounds("length", length, 1L, Long.MAX_VALUE);
        this.dataStream = dataStream;
        this.length = length;
        this.dataFlux = null;
    }

    public Flux<ByteBuffer> getDataFlux() {
        return this.dataFlux;
    }

    public InputStream getDataStream() {
        return this.dataStream;
    }

    public long getLength() {
        return this.length;
    }

    public Long getOffset() {
        return this.offset;
    }

    public ShareFileUploadRangeOptions setOffset(Long offset) {
        this.offset = offset;
        return this;
    }

    public ShareRequestConditions getRequestConditions() {
        return this.requestConditions;
    }

    public ShareFileUploadRangeOptions setRequestConditions(ShareRequestConditions requestConditions) {
        this.requestConditions = requestConditions;
        return this;
    }

    public FileLastWrittenMode getLastWrittenMode() {
        return this.lastWrittenMode;
    }

    public ShareFileUploadRangeOptions setLastWrittenMode(FileLastWrittenMode lastWrittenMode) {
        this.lastWrittenMode = lastWrittenMode;
        return this;
    }
}

