/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.storage.file.share.models;

import com.dataiku.dss.shadelibazure.com.azure.core.util.CoreUtils;
import com.dataiku.dss.shadelibazure.com.azure.storage.file.share.models.ShareProperties;
import com.dataiku.dss.shadelibazure.com.azure.xml.XmlReader;
import com.dataiku.dss.shadelibazure.com.azure.xml.XmlSerializable;
import com.dataiku.dss.shadelibazure.com.azure.xml.XmlToken;
import com.dataiku.dss.shadelibazure.com.azure.xml.XmlWriter;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;

public final class ShareItem
implements XmlSerializable<ShareItem> {
    private String name;
    private String snapshot;
    private Boolean deleted;
    private String version;
    private ShareProperties properties;
    private Map<String, String> metadata;

    public String getName() {
        return this.name;
    }

    public ShareItem setName(String name) {
        this.name = name;
        return this;
    }

    public String getSnapshot() {
        return this.snapshot;
    }

    public ShareItem setSnapshot(String snapshot) {
        this.snapshot = snapshot;
        return this;
    }

    public Boolean isDeleted() {
        return this.deleted;
    }

    public ShareItem setDeleted(Boolean deleted) {
        this.deleted = deleted;
        return this;
    }

    public String getVersion() {
        return this.version;
    }

    public ShareItem setVersion(String version) {
        this.version = version;
        return this;
    }

    public ShareProperties getProperties() {
        return this.properties;
    }

    public ShareItem setProperties(ShareProperties properties) {
        this.properties = properties;
        return this;
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public ShareItem setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
        return this;
    }

    @Override
    public XmlWriter toXml(XmlWriter xmlWriter) throws XMLStreamException {
        return this.toXml(xmlWriter, null);
    }

    @Override
    public XmlWriter toXml(XmlWriter xmlWriter, String rootElementName) throws XMLStreamException {
        rootElementName = CoreUtils.isNullOrEmpty(rootElementName) ? "Share" : rootElementName;
        xmlWriter.writeStartElement(rootElementName);
        xmlWriter.writeStringElement("Name", this.name);
        xmlWriter.writeStringElement("Snapshot", this.snapshot);
        xmlWriter.writeBooleanElement("Deleted", this.deleted);
        xmlWriter.writeStringElement("Version", this.version);
        xmlWriter.writeXml(this.properties, "Properties");
        if (this.metadata != null) {
            xmlWriter.writeStartElement("Metadata");
            for (Map.Entry<String, String> entry : this.metadata.entrySet()) {
                xmlWriter.writeStringElement(entry.getKey(), entry.getValue());
            }
            xmlWriter.writeEndElement();
        }
        return xmlWriter.writeEndElement();
    }

    public static ShareItem fromXml(XmlReader xmlReader) throws XMLStreamException {
        return ShareItem.fromXml(xmlReader, null);
    }

    public static ShareItem fromXml(XmlReader xmlReader, String rootElementName) throws XMLStreamException {
        String finalRootElementName = CoreUtils.isNullOrEmpty(rootElementName) ? "Share" : rootElementName;
        return xmlReader.readObject(finalRootElementName, reader -> {
            ShareItem deserializedShareItem = new ShareItem();
            while (reader.nextElement() != XmlToken.END_ELEMENT) {
                QName elementName = reader.getElementName();
                if ("Name".equals(elementName.getLocalPart())) {
                    deserializedShareItem.name = reader.getStringElement();
                    continue;
                }
                if ("Snapshot".equals(elementName.getLocalPart())) {
                    deserializedShareItem.snapshot = reader.getStringElement();
                    continue;
                }
                if ("Deleted".equals(elementName.getLocalPart())) {
                    deserializedShareItem.deleted = reader.getNullableElement(Boolean::parseBoolean);
                    continue;
                }
                if ("Version".equals(elementName.getLocalPart())) {
                    deserializedShareItem.version = reader.getStringElement();
                    continue;
                }
                if ("Properties".equals(elementName.getLocalPart())) {
                    deserializedShareItem.properties = ShareProperties.fromXml(reader, "Properties");
                    continue;
                }
                if ("Metadata".equals(elementName.getLocalPart())) {
                    while (reader.nextElement() != XmlToken.END_ELEMENT) {
                        if (deserializedShareItem.metadata == null) {
                            deserializedShareItem.metadata = new LinkedHashMap<String, String>();
                        }
                        deserializedShareItem.metadata.put(reader.getElementName().getLocalPart(), reader.getStringElement());
                    }
                    continue;
                }
                reader.skipElement();
            }
            return deserializedShareItem;
        });
    }
}

