/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.storage.internal.avro.implementation.schema.primitive;

import com.dataiku.dss.shadelibazure.com.azure.storage.internal.avro.implementation.AvroParserState;
import com.dataiku.dss.shadelibazure.com.azure.storage.internal.avro.implementation.schema.AvroSchema;
import com.dataiku.dss.shadelibazure.com.azure.storage.internal.avro.implementation.schema.AvroSimpleSchema;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.List;
import java.util.function.Consumer;

public class AvroDoubleSchema
extends AvroSimpleSchema {
    public AvroDoubleSchema(AvroParserState state, Consumer<Object> onResult) {
        super(state, onResult);
    }

    @Override
    public void pushToStack() {
        this.state.pushToStack(this);
    }

    @Override
    public void progress() {
        List<ByteBuffer> buffers = this.state.read(8L);
        byte[] doubleBytes = AvroSchema.getBytes(buffers);
        long doubleLong = ByteBuffer.wrap(doubleBytes).order(ByteOrder.LITTLE_ENDIAN).getLong();
        this.result = Double.longBitsToDouble(doubleLong);
        this.done = true;
    }

    @Override
    public boolean canProgress() {
        return this.state.sizeGreaterThan(8L);
    }
}

