/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.microsoft.aad.msal4jextensions;

import java.nio.file.Path;

public class PersistenceSettings {
    private String cacheFileName;
    private Path cacheDirectoryPath;
    private String keychainService;
    private String keychainAccount;
    private String keyringCollection;
    private String keyringSchemaName;
    private String keyringSecretLabel;
    private String keyringAttribute1Key;
    private String keyringAttribute1Value;
    private String keyringAttribute2Key;
    private String keyringAttribute2Value;
    private boolean linuxUseUnprotectedFileAsCacheStorage;
    private int lockRetryDelayMilliseconds;
    private int lockRetryNumber;

    private PersistenceSettings(String cacheFileName, Path cacheDirectoryPath, String keychainService, String keychainAccount, String keyringCollection, String keyringSchemaName, String keyringSecretLabel, String keyringAttribute1Key, String keyringAttribute1Value, String keyringAttribute2Key, String keyringAttribute2Value, boolean linuxUseUnprotectedFileAsCacheStorage, int lockRetryDelayMilliseconds, int lockRetryNumber) {
        this.cacheFileName = cacheFileName;
        this.cacheDirectoryPath = cacheDirectoryPath;
        this.keychainService = keychainService;
        this.keychainAccount = keychainAccount;
        this.keyringCollection = keyringCollection;
        this.keyringSchemaName = keyringSchemaName;
        this.keyringSecretLabel = keyringSecretLabel;
        this.keyringAttribute1Key = keyringAttribute1Key;
        this.keyringAttribute1Value = keyringAttribute1Value;
        this.keyringAttribute2Key = keyringAttribute2Key;
        this.keyringAttribute2Value = keyringAttribute2Value;
        this.linuxUseUnprotectedFileAsCacheStorage = linuxUseUnprotectedFileAsCacheStorage;
        this.lockRetryDelayMilliseconds = lockRetryDelayMilliseconds;
        this.lockRetryNumber = lockRetryNumber;
    }

    public String getCacheFileName() {
        return this.cacheFileName;
    }

    public Path getCacheDirectoryPath() {
        return this.cacheDirectoryPath;
    }

    public String getKeychainService() {
        return this.keychainService;
    }

    public String getKeychainAccount() {
        return this.keychainAccount;
    }

    public String getKeyringCollection() {
        return this.keyringCollection;
    }

    public String getKeyringSchemaName() {
        return this.keyringSchemaName;
    }

    public String getKeyringSecretLabel() {
        return this.keyringSecretLabel;
    }

    public String getKeyringAttribute1Key() {
        return this.keyringAttribute1Key;
    }

    public String getKeyringAttribute1Value() {
        return this.keyringAttribute1Value;
    }

    public String getKeyringAttribute2Key() {
        return this.keyringAttribute2Key;
    }

    public String getKeyringAttribute2Value() {
        return this.keyringAttribute2Value;
    }

    public boolean isOnLinuxUseUnprotectedFileAsCacheStorage() {
        return this.linuxUseUnprotectedFileAsCacheStorage;
    }

    public int getLockRetryDelayMilliseconds() {
        return this.lockRetryDelayMilliseconds;
    }

    public int getLockRetryNumber() {
        return this.lockRetryNumber;
    }

    private static void validateArgument(String parameter, String value) {
        if (value == null || value.isEmpty()) {
            throw new IllegalArgumentException(parameter + " null or Empty");
        }
    }

    private static void validateNotNull(String parameter, Path path) {
        if (path == null) {
            throw new IllegalArgumentException(parameter + " can not be null");
        }
    }

    public static Builder builder(String cacheFileName, Path cacheDirectoryPath) {
        return new Builder(cacheFileName, cacheDirectoryPath);
    }

    public static class Builder {
        private String cacheFileName;
        private Path cacheDirectoryPath;
        private String keychainService;
        private String keychainAccount;
        private String keyringCollection;
        private String keyringSchemaName;
        private String keyringSecretLabel;
        private String keyringAttributeKey1;
        private String keyringAttributeValue1;
        private String keyringAttributeKey2;
        private String keyringAttributeValue2;
        private boolean linuxUseUnprotectedFileAsCacheStorage = false;
        private int lockRetryDelayMilliseconds = 100;
        private int lockRetryNumber = 60;

        private Builder(String cacheFileName, Path cacheDirectoryPath) {
            PersistenceSettings.validateArgument("cacheFileName", cacheFileName);
            PersistenceSettings.validateNotNull("cacheDirectoryPath", cacheDirectoryPath);
            this.cacheFileName = cacheFileName;
            this.cacheDirectoryPath = cacheDirectoryPath;
        }

        public Builder setMacKeychain(String service, String account) {
            PersistenceSettings.validateArgument("service", service);
            PersistenceSettings.validateArgument("account", account);
            this.keychainAccount = account;
            this.keychainService = service;
            return this;
        }

        public Builder setLinuxKeyring(String collection, String schemaName, String secretLabel, String attributeKey1, String attributeValue1, String attributeKey2, String attributeValue2) {
            PersistenceSettings.validateArgument("schemaName", schemaName);
            this.keyringCollection = collection;
            this.keyringSchemaName = schemaName;
            this.keyringSecretLabel = secretLabel;
            this.keyringAttributeKey1 = attributeKey1;
            this.keyringAttributeValue1 = attributeValue1;
            this.keyringAttributeKey2 = attributeKey2;
            this.keyringAttributeValue2 = attributeValue2;
            return this;
        }

        public Builder setLinuxUseUnprotectedFileAsCacheStorage(boolean useUnprotectedFileAsCacheStorage) {
            this.linuxUseUnprotectedFileAsCacheStorage = useUnprotectedFileAsCacheStorage;
            return this;
        }

        public Builder setLockRetry(int delayMilliseconds, int retryNumber) {
            if (this.lockRetryDelayMilliseconds < 1) {
                throw new IllegalArgumentException("delayMilliseconds value should be more than 0");
            }
            if (this.lockRetryNumber < 1) {
                throw new IllegalArgumentException("retryNumber value should be more than 0");
            }
            this.lockRetryDelayMilliseconds = delayMilliseconds;
            this.lockRetryNumber = retryNumber;
            return this;
        }

        public PersistenceSettings build() {
            if (this.keyringSchemaName != null && this.linuxUseUnprotectedFileAsCacheStorage) {
                throw new IllegalArgumentException("Only one type of persistence can be used on Linux - KeyRing or Unprotected file");
            }
            return new PersistenceSettings(this.cacheFileName, this.cacheDirectoryPath, this.keychainService, this.keychainAccount, this.keyringCollection, this.keyringSchemaName, this.keyringSecretLabel, this.keyringAttributeKey1, this.keyringAttributeValue1, this.keyringAttributeKey2, this.keyringAttributeValue2, this.linuxUseUnprotectedFileAsCacheStorage, this.lockRetryDelayMilliseconds, this.lockRetryNumber);
        }
    }
}

