/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.microsoft.graph.httpcore;

import com.dataiku.dss.shadelibazure.com.microsoft.graph.authentication.IAuthenticationProvider;
import com.dataiku.dss.shadelibazure.com.microsoft.graph.httpcore.AuthenticationHandler;
import com.dataiku.dss.shadelibazure.com.microsoft.graph.httpcore.RedirectHandler;
import com.dataiku.dss.shadelibazure.com.microsoft.graph.httpcore.RetryHandler;
import com.dataiku.dss.shadelibazure.com.microsoft.graph.httpcore.TelemetryHandler;
import com.dataiku.dss.shadelibazure.javax.annotation.Nonnull;
import com.dataiku.dss.shadelibazure.javax.annotation.Nullable;
import com.dataiku.dss.shadelibazure.okhttp3.Interceptor;
import com.dataiku.dss.shadelibazure.okhttp3.OkHttpClient;
import java.util.Objects;

public class HttpClients {
    private HttpClients() {
    }

    @Nonnull
    public static OkHttpClient.Builder custom() {
        return new OkHttpClient.Builder().addInterceptor(new TelemetryHandler()).followRedirects(false).followSslRedirects(false);
    }

    @Nonnull
    public static OkHttpClient createDefault(@Nonnull IAuthenticationProvider auth) {
        Objects.requireNonNull(auth, "parameter auth cannot be null");
        return HttpClients.custom().addInterceptor(new AuthenticationHandler(auth)).addInterceptor(new RetryHandler()).addInterceptor(new RedirectHandler()).build();
    }

    @Nonnull
    public static OkHttpClient createFromInterceptors(@Nullable Interceptor[] interceptors) {
        OkHttpClient.Builder builder = HttpClients.custom();
        if (interceptors != null) {
            for (Interceptor interceptor : interceptors) {
                if (interceptor == null) continue;
                builder.addInterceptor(interceptor);
            }
        }
        return builder.build();
    }
}

