/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.microsoft.graph.serializer;

import com.dataiku.dss.shadelibazure.com.google.gson.Gson;
import com.dataiku.dss.shadelibazure.com.google.gson.GsonBuilder;
import com.dataiku.dss.shadelibazure.com.google.gson.JsonDeserializer;
import com.dataiku.dss.shadelibazure.com.google.gson.JsonPrimitive;
import com.dataiku.dss.shadelibazure.com.google.gson.JsonSerializer;
import com.dataiku.dss.shadelibazure.com.microsoft.graph.core.DateOnly;
import com.dataiku.dss.shadelibazure.com.microsoft.graph.core.TimeOfDay;
import com.dataiku.dss.shadelibazure.com.microsoft.graph.http.BaseCollectionPage;
import com.dataiku.dss.shadelibazure.com.microsoft.graph.http.BaseCollectionResponse;
import com.dataiku.dss.shadelibazure.com.microsoft.graph.logger.ILogger;
import com.dataiku.dss.shadelibazure.com.microsoft.graph.serializer.ByteArraySerializer;
import com.dataiku.dss.shadelibazure.com.microsoft.graph.serializer.CollectionPageSerializer;
import com.dataiku.dss.shadelibazure.com.microsoft.graph.serializer.CollectionResponseDeserializer;
import com.dataiku.dss.shadelibazure.com.microsoft.graph.serializer.EdmNativeTypeSerializer;
import com.dataiku.dss.shadelibazure.com.microsoft.graph.serializer.EnumSetSerializer;
import com.dataiku.dss.shadelibazure.com.microsoft.graph.serializer.FallbackTypeAdapterFactory;
import com.dataiku.dss.shadelibazure.com.microsoft.graph.serializer.OffsetDateTimeSerializer;
import com.dataiku.dss.shadelibazure.javax.annotation.Nonnull;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.text.ParseException;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.GregorianCalendar;
import java.util.Objects;
import java.util.UUID;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.Duration;

final class GsonFactory {
    protected static String PARSING_MESSAGE = "Parsing issue on ";

    private GsonFactory() {
    }

    @Nonnull
    public static Gson getGsonInstance(@Nonnull ILogger logger) {
        return GsonFactory.getGsonInstance(logger, false);
    }

    @Nonnull
    public static Gson getGsonInstance(@Nonnull ILogger logger, boolean serializeNulls) {
        Objects.requireNonNull(logger, "parameter logger cannot be null");
        JsonSerializer<OffsetDateTime> calendarJsonSerializer = (src, typeOfSrc, context) -> {
            if (src == null) {
                return null;
            }
            try {
                return new JsonPrimitive(OffsetDateTimeSerializer.serialize(src));
            }
            catch (Exception e) {
                logger.logError(PARSING_MESSAGE + src, e);
                return null;
            }
        };
        JsonDeserializer<OffsetDateTime> calendarJsonDeserializer = (json, typeOfT, context) -> {
            if (json == null) {
                return null;
            }
            try {
                return OffsetDateTimeSerializer.deserialize(json.getAsString());
            }
            catch (ParseException e) {
                logger.logError(PARSING_MESSAGE + json.getAsString(), e);
                return null;
            }
        };
        JsonSerializer<byte[]> byteArrayJsonSerializer = (src, typeOfSrc, context) -> {
            if (src == null) {
                return null;
            }
            try {
                return new JsonPrimitive(ByteArraySerializer.serialize(src));
            }
            catch (Exception e) {
                logger.logError(PARSING_MESSAGE + Arrays.toString(src), e);
                return null;
            }
        };
        JsonDeserializer<byte[]> byteArrayJsonDeserializer = (json, typeOfT, context) -> {
            if (json == null) {
                return null;
            }
            try {
                return ByteArraySerializer.deserialize(json.getAsString());
            }
            catch (ParseException e) {
                logger.logError(PARSING_MESSAGE + json.getAsString(), e);
                return null;
            }
        };
        JsonSerializer<DateOnly> dateJsonSerializer = (src, typeOfSrc, context) -> {
            if (src == null) {
                return null;
            }
            return new JsonPrimitive(src.toString());
        };
        JsonDeserializer<DateOnly> dateJsonDeserializer = (json, typeOfT, context) -> {
            if (json == null) {
                return null;
            }
            try {
                return DateOnly.parse(json.getAsString());
            }
            catch (ParseException e) {
                logger.logError(PARSING_MESSAGE + json.getAsString(), e);
                return null;
            }
        };
        EnumSetSerializer eSetSerializer = new EnumSetSerializer(logger);
        JsonSerializer<EnumSet> enumSetJsonSerializer = (src, typeOfSrc, context) -> {
            if (src == null || src.isEmpty()) {
                return null;
            }
            return eSetSerializer.serialize((EnumSet<?>)src);
        };
        JsonDeserializer<EnumSet> enumSetJsonDeserializer = (json, typeOfT, context) -> {
            if (json == null) {
                return null;
            }
            return eSetSerializer.deserialize(typeOfT, json.getAsString());
        };
        JsonSerializer<Duration> durationJsonSerializer = (src, typeOfSrc, context) -> new JsonPrimitive(src.toString());
        JsonDeserializer<Duration> durationJsonDeserializer = (json, typeOfT, context) -> {
            try {
                return DatatypeFactory.newInstance().newDuration(json.getAsString());
            }
            catch (Exception e) {
                return null;
            }
        };
        JsonSerializer<BaseCollectionPage> collectionPageSerializer = (src, typeOfSrc, context) -> CollectionPageSerializer.serialize(src, logger);
        JsonDeserializer<BaseCollectionPage> collectionPageDeserializer = (json, typeOfT, context) -> CollectionPageSerializer.deserialize(json, typeOfT, logger);
        JsonDeserializer<BaseCollectionResponse> collectionResponseDeserializer = (json, typeOfT, context) -> CollectionResponseDeserializer.deserialize(json, typeOfT, logger);
        JsonDeserializer<TimeOfDay> timeOfDayJsonDeserializer = (json, typeOfT, context) -> {
            try {
                return TimeOfDay.parse(json.getAsString());
            }
            catch (Exception e) {
                return null;
            }
        };
        JsonSerializer<TimeOfDay> timeOfDayJsonSerializer = (src, typeOfSrc, context) -> new JsonPrimitive(src.toString());
        JsonDeserializer<Boolean> booleanJsonDeserializer = (json, typeOfT, context) -> EdmNativeTypeSerializer.deserialize(json, Boolean.class, logger);
        JsonDeserializer<String> stringJsonDeserializer = (json, typeOfT, context) -> EdmNativeTypeSerializer.deserialize(json, String.class, logger);
        JsonDeserializer<BigDecimal> bigDecimalJsonDeserializer = (json, typeOfT, context) -> EdmNativeTypeSerializer.deserialize(json, BigDecimal.class, logger);
        JsonDeserializer<Integer> integerJsonDeserializer = (json, typeOfT, context) -> EdmNativeTypeSerializer.deserialize(json, Integer.class, logger);
        JsonDeserializer<Long> longJsonDeserializer = (json, typeOfT, context) -> EdmNativeTypeSerializer.deserialize(json, Long.class, logger);
        JsonDeserializer<UUID> uuidJsonDeserializer = (json, typeOfT, context) -> EdmNativeTypeSerializer.deserialize(json, UUID.class, logger);
        JsonDeserializer<Float> floatJsonDeserializer = (json, typeOfT, context) -> EdmNativeTypeSerializer.deserialize(json, Float.class, logger);
        GsonBuilder builder = new GsonBuilder();
        if (serializeNulls) {
            builder.serializeNulls();
        }
        return builder.excludeFieldsWithoutExposeAnnotation().registerTypeAdapter((Type)((Object)Boolean.class), booleanJsonDeserializer).registerTypeAdapter((Type)((Object)String.class), stringJsonDeserializer).registerTypeAdapter((Type)((Object)Float.class), floatJsonDeserializer).registerTypeAdapter((Type)((Object)Integer.class), integerJsonDeserializer).registerTypeAdapter((Type)((Object)BigDecimal.class), bigDecimalJsonDeserializer).registerTypeAdapter((Type)((Object)UUID.class), uuidJsonDeserializer).registerTypeAdapter((Type)((Object)Long.class), longJsonDeserializer).registerTypeAdapter((Type)((Object)OffsetDateTime.class), calendarJsonSerializer).registerTypeAdapter((Type)((Object)OffsetDateTime.class), calendarJsonDeserializer).registerTypeAdapter((Type)((Object)GregorianCalendar.class), calendarJsonSerializer).registerTypeAdapter((Type)((Object)GregorianCalendar.class), calendarJsonDeserializer).registerTypeAdapter((Type)((Object)byte[].class), byteArrayJsonDeserializer).registerTypeAdapter((Type)((Object)byte[].class), byteArrayJsonSerializer).registerTypeAdapter((Type)((Object)DateOnly.class), dateJsonSerializer).registerTypeAdapter((Type)((Object)DateOnly.class), dateJsonDeserializer).registerTypeAdapter((Type)((Object)EnumSet.class), enumSetJsonSerializer).registerTypeAdapter((Type)((Object)EnumSet.class), enumSetJsonDeserializer).registerTypeAdapter((Type)((Object)Duration.class), durationJsonSerializer).registerTypeAdapter((Type)((Object)Duration.class), durationJsonDeserializer).registerTypeHierarchyAdapter(BaseCollectionPage.class, collectionPageSerializer).registerTypeHierarchyAdapter(BaseCollectionPage.class, collectionPageDeserializer).registerTypeHierarchyAdapter(BaseCollectionResponse.class, collectionResponseDeserializer).registerTypeAdapter((Type)((Object)TimeOfDay.class), timeOfDayJsonDeserializer).registerTypeAdapter((Type)((Object)TimeOfDay.class), timeOfDayJsonSerializer).registerTypeAdapterFactory(new FallbackTypeAdapterFactory(logger)).create();
    }
}

