/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.microsoft.graph.serializer;

import com.dataiku.dss.shadelibazure.javax.annotation.Nonnull;
import com.dataiku.dss.shadelibazure.javax.annotation.Nullable;
import java.text.ParseException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Objects;
import java.util.regex.Pattern;

public final class OffsetDateTimeSerializer {
    private static final Pattern missingColonPattern = Pattern.compile("([-+])(\\d{2})(\\d{2})");
    private static final Pattern missingOffsetPattern = Pattern.compile(".*\\d{2}$");

    private OffsetDateTimeSerializer() {
    }

    @Nullable
    public static OffsetDateTime deserialize(@Nonnull String strVal) throws ParseException {
        Objects.requireNonNull(strVal, "parameter strVal cannot be null");
        String[] sections = strVal.split("T");
        return OffsetDateTime.parse(missingColonPattern.matcher(sections.length == 2 && !sections[1].contains("+") && !sections[1].contains("-") && missingOffsetPattern.matcher(strVal).matches() ? strVal + "Z" : strVal).replaceAll("$1$2:$3"), DateTimeFormatter.ISO_OFFSET_DATE_TIME);
    }

    @Nonnull
    public static String serialize(@Nonnull OffsetDateTime src) {
        Objects.requireNonNull(src, "parameter src cannot be null");
        return src.format(DateTimeFormatter.ISO_OFFSET_DATE_TIME);
    }
}

