/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.nimbusds.oauth2.sdk;

import com.dataiku.dss.shadelibazure.com.nimbusds.oauth2.sdk.AuthorizationGrant;
import com.dataiku.dss.shadelibazure.com.nimbusds.oauth2.sdk.GrantType;
import com.dataiku.dss.shadelibazure.com.nimbusds.oauth2.sdk.OAuth2Error;
import com.dataiku.dss.shadelibazure.com.nimbusds.oauth2.sdk.ParseException;
import com.dataiku.dss.shadelibazure.com.nimbusds.oauth2.sdk.token.RefreshToken;
import com.dataiku.dss.shadelibazure.com.nimbusds.oauth2.sdk.util.MultivaluedMapUtils;
import com.dataiku.dss.shadelibazure.com.nimbusds.oauth2.sdk.util.StringUtils;
import com.dataiku.dss.shadelibazure.net.jcip.annotations.Immutable;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@Immutable
public class RefreshTokenGrant
extends AuthorizationGrant {
    public static final GrantType GRANT_TYPE = GrantType.REFRESH_TOKEN;
    private final RefreshToken refreshToken;

    public RefreshTokenGrant(RefreshToken refreshToken) {
        super(GRANT_TYPE);
        this.refreshToken = Objects.requireNonNull(refreshToken);
    }

    public RefreshToken getRefreshToken() {
        return this.refreshToken;
    }

    @Override
    public Map<String, List<String>> toParameters() {
        LinkedHashMap<String, List<String>> params = new LinkedHashMap<String, List<String>>();
        params.put("grant_type", Collections.singletonList(GRANT_TYPE.getValue()));
        params.put("refresh_token", Collections.singletonList(this.refreshToken.getValue()));
        return params;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RefreshTokenGrant grant = (RefreshTokenGrant)o;
        return this.refreshToken.equals(grant.refreshToken);
    }

    public int hashCode() {
        return this.refreshToken.hashCode();
    }

    public static RefreshTokenGrant parse(Map<String, List<String>> params) throws ParseException {
        GrantType.ensure(GRANT_TYPE, params);
        String refreshTokenString = MultivaluedMapUtils.getFirstValue(params, "refresh_token");
        if (StringUtils.isBlank(refreshTokenString)) {
            String msg = "Missing or empty refresh_token parameter";
            throw new ParseException(msg, OAuth2Error.INVALID_REQUEST.appendDescription(": " + msg));
        }
        return new RefreshTokenGrant(new RefreshToken(refreshTokenString));
    }
}

