/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.nimbusds.oauth2.sdk.auth.verifier;

import com.dataiku.dss.shadelibazure.com.nimbusds.jose.proc.SecurityContext;
import com.dataiku.dss.shadelibazure.com.nimbusds.jwt.JWTClaimsSet;
import com.dataiku.dss.shadelibazure.com.nimbusds.jwt.proc.BadJWTException;
import com.dataiku.dss.shadelibazure.com.nimbusds.oauth2.sdk.assertions.jwt.JWTAssertionDetailsVerifier;
import com.dataiku.dss.shadelibazure.com.nimbusds.oauth2.sdk.auth.verifier.JWTAudienceCheck;
import com.dataiku.dss.shadelibazure.com.nimbusds.oauth2.sdk.id.Audience;
import com.dataiku.dss.shadelibazure.net.jcip.annotations.Immutable;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@Immutable
class JWTAuthenticationClaimsSetVerifier
extends JWTAssertionDetailsVerifier {
    private static final BadJWTException ISS_SUB_MISMATCH_EXCEPTION = new BadJWTException("Issuer and subject JWT claims don't match");
    private final JWTAudienceCheck audCheck;

    public JWTAuthenticationClaimsSetVerifier(Set<Audience> aud) {
        this(aud, JWTAudienceCheck.LEGACY, -1L);
    }

    public JWTAuthenticationClaimsSetVerifier(Set<Audience> aud, long expMaxAhead) {
        this(aud, JWTAudienceCheck.LEGACY, expMaxAhead);
    }

    public JWTAuthenticationClaimsSetVerifier(Set<Audience> aud, JWTAudienceCheck audCheck, long expMaxAhead) {
        super(aud, expMaxAhead);
        if (JWTAudienceCheck.STRICT.equals((Object)Objects.requireNonNull(audCheck)) && aud.size() != 1) {
            throw new IllegalArgumentException("When strict the JWT audience must be single-valued");
        }
        this.audCheck = Objects.requireNonNull(audCheck);
    }

    public JWTAudienceCheck getAudienceCheck() {
        return this.audCheck;
    }

    @Override
    public void verify(JWTClaimsSet claimsSet, SecurityContext securityContext) throws BadJWTException {
        List<String> audList;
        super.verify(claimsSet, securityContext);
        if (!claimsSet.getIssuer().equals(claimsSet.getSubject())) {
            throw ISS_SUB_MISMATCH_EXCEPTION;
        }
        if (JWTAudienceCheck.STRICT.equals((Object)this.audCheck) && (audList = claimsSet.getAudience()).size() != 1) {
            throw new BadJWTException("JWT multi-valued audience rejected: " + audList);
        }
    }
}

