/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.nimbusds.openid.connect.sdk.federation.api;

import com.dataiku.dss.shadelibazure.com.nimbusds.oauth2.sdk.ParseException;
import com.dataiku.dss.shadelibazure.com.nimbusds.oauth2.sdk.http.HTTPResponse;
import com.dataiku.dss.shadelibazure.com.nimbusds.openid.connect.sdk.federation.api.FetchEntityStatementResponse;
import com.dataiku.dss.shadelibazure.com.nimbusds.openid.connect.sdk.federation.entities.EntityStatement;
import com.dataiku.dss.shadelibazure.net.jcip.annotations.Immutable;

@Immutable
public class FetchEntityStatementSuccessResponse
extends FetchEntityStatementResponse {
    private final EntityStatement entityStatement;

    public FetchEntityStatementSuccessResponse(EntityStatement entityStatement) {
        if (entityStatement == null) {
            throw new IllegalArgumentException("The federation entity statement must not be null");
        }
        this.entityStatement = entityStatement;
    }

    public EntityStatement getEntityStatement() {
        return this.entityStatement;
    }

    @Override
    public boolean indicatesSuccess() {
        return true;
    }

    @Override
    public HTTPResponse toHTTPResponse() {
        HTTPResponse httpResponse = new HTTPResponse(200);
        httpResponse.setEntityContentType(EntityStatement.CONTENT_TYPE);
        httpResponse.setContent(this.getEntityStatement().getSignedStatement().serialize());
        return httpResponse;
    }

    public static FetchEntityStatementSuccessResponse parse(HTTPResponse httpResponse) throws ParseException {
        httpResponse.ensureStatusCode(200);
        httpResponse.ensureEntityContentType(EntityStatement.CONTENT_TYPE);
        return new FetchEntityStatementSuccessResponse(EntityStatement.parse(httpResponse.getBody()));
    }
}

