/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.nimbusds.openid.connect.sdk.federation.entities;

import com.dataiku.dss.shadelibazure.com.nimbusds.oauth2.sdk.ParseException;
import com.dataiku.dss.shadelibazure.com.nimbusds.oauth2.sdk.util.JSONObjectUtils;
import com.dataiku.dss.shadelibazure.net.minidev.json.JSONObject;
import java.net.URI;
import java.util.List;

public class FederationEntityMetadata {
    private URI federationFetchEndpoint;
    private URI federationListEndpoint;
    private URI federationResolveEndpoint;
    private URI federationTrustMarkStatusEndpoint;
    private String organizationName;
    private List<String> contacts;
    private URI logoURI;
    private URI policyURI;
    private URI homepageURI;

    public FederationEntityMetadata() {
    }

    public FederationEntityMetadata(URI federationFetchEndpoint) {
        this.federationFetchEndpoint = federationFetchEndpoint;
    }

    public URI getFederationFetchEndpointURI() {
        return this.federationFetchEndpoint;
    }

    public void setFederationFetchEndpointURI(URI federationFetchEndpoint) {
        this.federationFetchEndpoint = federationFetchEndpoint;
    }

    public URI getFederationListEndpointURI() {
        return this.federationListEndpoint;
    }

    public void setFederationListEndpointURI(URI federationListEndpoint) {
        this.federationListEndpoint = federationListEndpoint;
    }

    public URI getFederationResolveEndpointURI() {
        return this.federationResolveEndpoint;
    }

    public void setFederationResolveEndpointURI(URI federationResolveEndpoint) {
        this.federationResolveEndpoint = federationResolveEndpoint;
    }

    public URI getFederationTrustMarkStatusEndpointURI() {
        return this.federationTrustMarkStatusEndpoint;
    }

    public void setFederationTrustMarkStatusEndpointURI(URI federationTrustMarkStatusEndpoint) {
        this.federationTrustMarkStatusEndpoint = federationTrustMarkStatusEndpoint;
    }

    public String getOrganizationName() {
        return this.organizationName;
    }

    public void setOrganizationName(String organizationName) {
        this.organizationName = organizationName;
    }

    public List<String> getContacts() {
        return this.contacts;
    }

    public void setContacts(List<String> contacts) {
        this.contacts = contacts;
    }

    public URI getLogoURI() {
        return this.logoURI;
    }

    public void setLogoURI(URI logoURI) {
        this.logoURI = logoURI;
    }

    public URI getPolicyURI() {
        return this.policyURI;
    }

    public void setPolicyURI(URI policyURI) {
        this.policyURI = policyURI;
    }

    public URI getHomepageURI() {
        return this.homepageURI;
    }

    public void setHomepageURI(URI homepageURI) {
        this.homepageURI = homepageURI;
    }

    public JSONObject toJSONObject() {
        JSONObject o = new JSONObject();
        if (this.getFederationFetchEndpointURI() != null) {
            o.put("federation_fetch_endpoint", this.getFederationFetchEndpointURI().toString());
        }
        if (this.getFederationListEndpointURI() != null) {
            o.put("federation_list_endpoint", this.getFederationListEndpointURI().toString());
        }
        if (this.getFederationResolveEndpointURI() != null) {
            o.put("federation_resolve_endpoint", this.getFederationResolveEndpointURI().toString());
        }
        if (this.getFederationTrustMarkStatusEndpointURI() != null) {
            o.put("federation_trust_mark_status_endpoint", this.getFederationTrustMarkStatusEndpointURI().toString());
        }
        if (this.getOrganizationName() != null) {
            o.put("organization_name", this.getOrganizationName());
        }
        if (this.getContacts() != null) {
            o.put("contacts", this.getContacts());
        }
        if (this.getLogoURI() != null) {
            o.put("logo_uri", this.getLogoURI().toString());
        }
        if (this.getPolicyURI() != null) {
            o.put("policy_uri", this.getPolicyURI().toString());
        }
        if (this.getHomepageURI() != null) {
            o.put("homepage_uri", this.getHomepageURI().toString());
        }
        return o;
    }

    public static FederationEntityMetadata parse(JSONObject jsonObject) throws ParseException {
        FederationEntityMetadata metadata = new FederationEntityMetadata(JSONObjectUtils.getURI(jsonObject, "federation_fetch_endpoint", null));
        metadata.setFederationListEndpointURI(JSONObjectUtils.getURI(jsonObject, "federation_list_endpoint", null));
        metadata.setFederationResolveEndpointURI(JSONObjectUtils.getURI(jsonObject, "federation_resolve_endpoint", null));
        metadata.setFederationTrustMarkStatusEndpointURI(JSONObjectUtils.getURI(jsonObject, "federation_trust_mark_status_endpoint", null));
        metadata.setOrganizationName(JSONObjectUtils.getString(jsonObject, "organization_name", null));
        metadata.setContacts(JSONObjectUtils.getStringList(jsonObject, "contacts", null));
        metadata.setLogoURI(JSONObjectUtils.getURI(jsonObject, "logo_uri", null));
        metadata.setPolicyURI(JSONObjectUtils.getURI(jsonObject, "policy_uri", null));
        metadata.setHomepageURI(JSONObjectUtils.getURI(jsonObject, "homepage_uri", null));
        return metadata;
    }

    public static FederationEntityMetadata parse(String json) throws ParseException {
        return FederationEntityMetadata.parse(JSONObjectUtils.parse(json));
    }
}

