/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.org.apache.iceberg.azure.adlsv2;

import com.dataiku.dss.shadelib.org.apache.iceberg.io.InputFile;
import com.dataiku.dss.shadelib.org.apache.iceberg.io.SeekableInputStream;
import com.dataiku.dss.shadelib.org.apache.iceberg.metrics.MetricsContext;
import com.dataiku.dss.shadelibazure.com.azure.storage.file.datalake.DataLakeFileClient;
import com.dataiku.dss.shadelibazure.org.apache.iceberg.azure.AzureProperties;
import com.dataiku.dss.shadelibazure.org.apache.iceberg.azure.adlsv2.ADLSInputStream;
import com.dataiku.dss.shadelibazure.org.apache.iceberg.azure.adlsv2.BaseADLSFile;

class ADLSInputFile
extends BaseADLSFile
implements InputFile {
    private Long fileSize;

    ADLSInputFile(String location, DataLakeFileClient fileClient, AzureProperties azureProperties, MetricsContext metrics) {
        this(location, null, fileClient, azureProperties, metrics);
    }

    ADLSInputFile(String location, Long fileSize, DataLakeFileClient fileClient, AzureProperties azureProperties, MetricsContext metrics) {
        super(location, fileClient, azureProperties, metrics);
        this.fileSize = fileSize != null && fileSize > 0L ? fileSize : null;
    }

    public long getLength() {
        if (this.fileSize == null) {
            this.fileSize = this.fileClient().getProperties().getFileSize();
        }
        return this.fileSize;
    }

    public SeekableInputStream newStream() {
        return new ADLSInputStream(this.fileClient(), this.fileSize, this.azureProperties(), this.metrics());
    }
}

