/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.reactor.core.publisher;

import com.dataiku.dss.shadelibazure.reactor.core.CoreSubscriber;
import com.dataiku.dss.shadelibazure.reactor.core.Disposable;
import com.dataiku.dss.shadelibazure.reactor.core.Fuseable;
import com.dataiku.dss.shadelibazure.reactor.core.Scannable;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.ConnectableFlux;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Flux;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.InternalProducerAttr;
import com.dataiku.dss.shadelibazure.reactor.util.annotation.Nullable;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.function.Consumer;

final class FluxAutoConnectFuseable<T>
extends Flux<T>
implements Scannable,
Fuseable {
    final ConnectableFlux<? extends T> source;
    final Consumer<? super Disposable> cancelSupport;
    volatile int remaining;
    static final AtomicIntegerFieldUpdater<FluxAutoConnectFuseable> REMAINING = AtomicIntegerFieldUpdater.newUpdater(FluxAutoConnectFuseable.class, "remaining");

    FluxAutoConnectFuseable(ConnectableFlux<? extends T> source2, int n, Consumer<? super Disposable> cancelSupport) {
        if (n <= 0) {
            throw new IllegalArgumentException("n > required but it was " + n);
        }
        this.source = ConnectableFlux.from(Objects.requireNonNull(source2, "source"));
        this.cancelSupport = Objects.requireNonNull(cancelSupport, "cancelSupport");
        REMAINING.lazySet(this, n);
    }

    @Override
    public void subscribe(CoreSubscriber<? super T> actual) {
        this.source.subscribe(actual);
        if (this.remaining > 0 && REMAINING.decrementAndGet(this) == 0) {
            this.source.connect(this.cancelSupport);
        }
    }

    @Override
    public int getPrefetch() {
        return this.source.getPrefetch();
    }

    @Override
    @Nullable
    public Object scanUnsafe(Scannable.Attr key) {
        if (key == Scannable.Attr.PREFETCH) {
            return this.getPrefetch();
        }
        if (key == Scannable.Attr.PARENT) {
            return this.source;
        }
        if (key == Scannable.Attr.CAPACITY) {
            return this.remaining;
        }
        if (key == Scannable.Attr.RUN_STYLE) {
            return Scannable.Attr.RunStyle.SYNC;
        }
        if (key == InternalProducerAttr.INSTANCE) {
            return true;
        }
        return null;
    }
}

