/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.reactor.core.publisher;

import com.dataiku.dss.shadelibazure.org.reactivestreams.Subscription;
import com.dataiku.dss.shadelibazure.reactor.core.CoreSubscriber;
import com.dataiku.dss.shadelibazure.reactor.core.Scannable;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Flux;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.InnerOperator;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.InternalFluxOperator;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Operators;
import com.dataiku.dss.shadelibazure.reactor.core.scheduler.Scheduler;
import com.dataiku.dss.shadelibazure.reactor.util.annotation.Nullable;
import java.util.Objects;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;

final class FluxCancelOn<T>
extends InternalFluxOperator<T, T> {
    final Scheduler scheduler;

    public FluxCancelOn(Flux<T> source2, Scheduler scheduler) {
        super(source2);
        this.scheduler = Objects.requireNonNull(scheduler, "scheduler");
    }

    @Override
    public CoreSubscriber<? super T> subscribeOrReturn(CoreSubscriber<? super T> actual) {
        return new CancelSubscriber<T>(actual, this.scheduler);
    }

    @Override
    public Object scanUnsafe(Scannable.Attr key) {
        if (key == Scannable.Attr.RUN_ON) {
            return this.scheduler;
        }
        if (key == Scannable.Attr.RUN_STYLE) {
            return Scannable.Attr.RunStyle.ASYNC;
        }
        return super.scanUnsafe(key);
    }

    static final class CancelSubscriber<T>
    implements InnerOperator<T, T>,
    Runnable {
        final CoreSubscriber<? super T> actual;
        final Scheduler scheduler;
        Subscription s;
        volatile int cancelled = 0;
        static final AtomicIntegerFieldUpdater<CancelSubscriber> CANCELLED = AtomicIntegerFieldUpdater.newUpdater(CancelSubscriber.class, "cancelled");

        CancelSubscriber(CoreSubscriber<? super T> actual, Scheduler scheduler) {
            this.actual = actual;
            this.scheduler = scheduler;
        }

        @Override
        public void onSubscribe(Subscription s2) {
            if (Operators.validate(this.s, s2)) {
                this.s = s2;
                this.actual.onSubscribe(this);
            }
        }

        @Override
        @Nullable
        public Object scanUnsafe(Scannable.Attr key) {
            if (key == Scannable.Attr.PARENT) {
                return this.s;
            }
            if (key == Scannable.Attr.CANCELLED) {
                return this.cancelled == 1;
            }
            if (key == Scannable.Attr.RUN_ON) {
                return this.scheduler;
            }
            if (key == Scannable.Attr.RUN_STYLE) {
                return Scannable.Attr.RunStyle.ASYNC;
            }
            return InnerOperator.super.scanUnsafe(key);
        }

        @Override
        public CoreSubscriber<? super T> actual() {
            return this.actual;
        }

        @Override
        public void run() {
            this.s.cancel();
        }

        @Override
        public void onNext(T t) {
            this.actual.onNext(t);
        }

        @Override
        public void onError(Throwable t) {
            this.actual.onError(t);
        }

        @Override
        public void onComplete() {
            this.actual.onComplete();
        }

        @Override
        public void request(long n) {
            this.s.request(n);
        }

        @Override
        public void cancel() {
            if (CANCELLED.compareAndSet(this, 0, 1)) {
                try {
                    this.scheduler.schedule(this);
                }
                catch (RejectedExecutionException ree) {
                    throw Operators.onRejectedExecution(ree, this.actual.currentContext());
                }
            }
        }
    }
}

