/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.reactor.core.publisher;

import com.dataiku.dss.shadelibazure.io.micrometer.context.ContextSnapshot;
import com.dataiku.dss.shadelibazure.org.reactivestreams.Subscription;
import com.dataiku.dss.shadelibazure.reactor.core.CoreSubscriber;
import com.dataiku.dss.shadelibazure.reactor.core.Fuseable;
import com.dataiku.dss.shadelibazure.reactor.core.Scannable;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.ContextPropagation;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Flux;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.FluxOperator;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.InnerOperator;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.InternalProducerAttr;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Operators;
import com.dataiku.dss.shadelibazure.reactor.util.annotation.Nullable;
import com.dataiku.dss.shadelibazure.reactor.util.context.Context;
import java.util.Objects;
import java.util.function.Function;

final class FluxContextWriteRestoringThreadLocals<T>
extends FluxOperator<T, T> {
    final Function<Context, Context> doOnContext;

    FluxContextWriteRestoringThreadLocals(Flux<? extends T> source2, Function<Context, Context> doOnContext) {
        super(source2);
        this.doOnContext = Objects.requireNonNull(doOnContext, "doOnContext");
    }

    @Override
    public void subscribe(CoreSubscriber<? super T> actual) {
        Context c = this.doOnContext.apply(actual.currentContext());
        try (ContextSnapshot.Scope ignored = ContextPropagation.setThreadLocals(c);){
            this.source.subscribe(new ContextWriteRestoringThreadLocalsSubscriber<T>(actual, c));
        }
    }

    @Override
    public Object scanUnsafe(Scannable.Attr key) {
        if (key == Scannable.Attr.RUN_STYLE) {
            return Scannable.Attr.RunStyle.SYNC;
        }
        if (key == InternalProducerAttr.INSTANCE) {
            return true;
        }
        return super.scanUnsafe(key);
    }

    static class ContextWriteRestoringThreadLocalsSubscriber<T>
    implements Fuseable.ConditionalSubscriber<T>,
    InnerOperator<T, T> {
        final CoreSubscriber<? super T> actual;
        final Fuseable.ConditionalSubscriber<? super T> actualConditional;
        final Context context;
        Subscription s;

        ContextWriteRestoringThreadLocalsSubscriber(CoreSubscriber<? super T> actual, Context context) {
            this.actual = actual;
            this.context = context;
            this.actualConditional = actual instanceof Fuseable.ConditionalSubscriber ? (Fuseable.ConditionalSubscriber)actual : null;
        }

        @Override
        @Nullable
        public Object scanUnsafe(Scannable.Attr key) {
            if (key == Scannable.Attr.PARENT) {
                return this.s;
            }
            if (key == Scannable.Attr.RUN_STYLE) {
                return Scannable.Attr.RunStyle.SYNC;
            }
            return InnerOperator.super.scanUnsafe(key);
        }

        @Override
        public Context currentContext() {
            return this.context;
        }

        @Override
        public void onSubscribe(Subscription s2) {
            try (ContextSnapshot.Scope ignored = ContextPropagation.setThreadLocals(this.actual.currentContext());){
                if (Operators.validate(this.s, s2)) {
                    this.s = s2;
                    this.actual.onSubscribe(this);
                }
            }
        }

        @Override
        public void onNext(T t) {
            try (ContextSnapshot.Scope ignored = ContextPropagation.setThreadLocals(this.actual.currentContext());){
                this.actual.onNext(t);
            }
        }

        @Override
        public boolean tryOnNext(T t) {
            try (ContextSnapshot.Scope ignored = ContextPropagation.setThreadLocals(this.actual.currentContext());){
                if (this.actualConditional != null) {
                    boolean bl = this.actualConditional.tryOnNext(t);
                    return bl;
                }
                this.actual.onNext(t);
                boolean bl = true;
                return bl;
            }
        }

        @Override
        public void onError(Throwable t) {
            try (ContextSnapshot.Scope ignored = ContextPropagation.setThreadLocals(this.actual.currentContext());){
                this.actual.onError(t);
            }
        }

        @Override
        public void onComplete() {
            try (ContextSnapshot.Scope ignored = ContextPropagation.setThreadLocals(this.actual.currentContext());){
                this.actual.onComplete();
            }
        }

        @Override
        public CoreSubscriber<? super T> actual() {
            return this.actual;
        }

        @Override
        public void request(long n) {
            try (ContextSnapshot.Scope ignored = ContextPropagation.setThreadLocals(this.context);){
                this.s.request(n);
            }
        }

        @Override
        public void cancel() {
            try (ContextSnapshot.Scope ignored = ContextPropagation.setThreadLocals(this.context);){
                this.s.cancel();
            }
        }
    }
}

