/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.reactor.core.publisher;

import com.dataiku.dss.shadelibazure.reactor.core.CorePublisher;
import com.dataiku.dss.shadelibazure.reactor.core.CoreSubscriber;
import com.dataiku.dss.shadelibazure.reactor.core.Scannable;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.InternalProducerAttr;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Mono;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.MonoOperator;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Operators;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.OptimizableOperator;
import com.dataiku.dss.shadelibazure.reactor.util.annotation.Nullable;

abstract class InternalMonoOperator<I, O>
extends MonoOperator<I, O>
implements Scannable,
OptimizableOperator<O, I> {
    @Nullable
    final OptimizableOperator<?, I> optimizableOperator;

    protected InternalMonoOperator(Mono<? extends I> source2) {
        super(source2);
        OptimizableOperator optimSource;
        this.optimizableOperator = source2 instanceof OptimizableOperator ? (optimSource = (OptimizableOperator)((Object)source2)) : null;
    }

    @Override
    public Object scanUnsafe(Scannable.Attr key) {
        if (key == InternalProducerAttr.INSTANCE) {
            return true;
        }
        return super.scanUnsafe(key);
    }

    @Override
    public final void subscribe(CoreSubscriber<? super O> subscriber) {
        OptimizableOperator<Object, Object> operator = this;
        try {
            while (true) {
                if ((subscriber = operator.subscribeOrReturn(subscriber)) == null) {
                    return;
                }
                OptimizableOperator newSource2 = operator.nextOptimizableSource();
                if (newSource2 == null) {
                    CorePublisher operatorSource = operator.source();
                    subscriber = Operators.restoreContextOnSubscriberIfPublisherNonInternal(operatorSource, subscriber);
                    operatorSource.subscribe(subscriber);
                    return;
                }
                operator = newSource2;
            }
        }
        catch (Throwable e) {
            Operators.reportThrowInSubscribe(subscriber, e);
            return;
        }
    }

    @Override
    @Nullable
    public abstract CoreSubscriber<? super I> subscribeOrReturn(CoreSubscriber<? super O> var1) throws Throwable;

    @Override
    public final CorePublisher<? extends I> source() {
        return this.source;
    }

    @Override
    public final OptimizableOperator<?, ? extends I> nextOptimizableSource() {
        return this.optimizableOperator;
    }
}

