/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.reactor.core.publisher;

import com.dataiku.dss.shadelibazure.io.micrometer.context.ContextSnapshot;
import com.dataiku.dss.shadelibazure.reactor.core.CoreSubscriber;
import com.dataiku.dss.shadelibazure.reactor.core.Scannable;
import com.dataiku.dss.shadelibazure.reactor.core.observability.SignalListener;
import com.dataiku.dss.shadelibazure.reactor.core.observability.SignalListenerFactory;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.ContextPropagation;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.FluxTapRestoringThreadLocals;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.InternalProducerAttr;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Mono;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.MonoOperator;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Operators;
import com.dataiku.dss.shadelibazure.reactor.util.annotation.Nullable;
import com.dataiku.dss.shadelibazure.reactor.util.context.Context;

final class MonoTapRestoringThreadLocals<T, STATE>
extends MonoOperator<T, T> {
    final SignalListenerFactory<T, STATE> tapFactory;
    final STATE commonTapState;

    MonoTapRestoringThreadLocals(Mono<? extends T> source2, SignalListenerFactory<T, STATE> tapFactory) {
        super(source2);
        this.tapFactory = tapFactory;
        this.commonTapState = tapFactory.initializePublisherState(source2);
    }

    @Override
    public void subscribe(CoreSubscriber<? super T> actual) {
        Context alteredContext;
        SignalListener<T> signalListener;
        try {
            signalListener = this.tapFactory.createListener(this.source, actual.currentContext().readOnly(), this.commonTapState);
        }
        catch (Throwable generatorError) {
            Operators.error(actual, generatorError);
            return;
        }
        try {
            signalListener.doFirst();
        }
        catch (Throwable listenerError) {
            signalListener.handleListenerError(listenerError);
            Operators.error(actual, listenerError);
            return;
        }
        try {
            alteredContext = signalListener.addToContext(actual.currentContext());
        }
        catch (Throwable e) {
            signalListener.handleListenerError(new IllegalStateException("Unable to augment tap Context at construction via addToContext", e));
            alteredContext = actual.currentContext();
        }
        try (ContextSnapshot.Scope ignored = ContextPropagation.setThreadLocals(alteredContext);){
            this.source.subscribe(new FluxTapRestoringThreadLocals.TapSubscriber<T>(actual, signalListener, alteredContext));
        }
    }

    @Override
    @Nullable
    public Object scanUnsafe(Scannable.Attr key) {
        if (key == Scannable.Attr.PREFETCH) {
            return -1;
        }
        if (key == Scannable.Attr.RUN_STYLE) {
            return Scannable.Attr.RunStyle.SYNC;
        }
        if (key == InternalProducerAttr.INSTANCE) {
            return true;
        }
        return super.scanUnsafe(key);
    }
}

