/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.reactor.netty.http.client;

import com.dataiku.dss.shadelibazure.io.netty.channel.Channel;
import com.dataiku.dss.shadelibazure.io.netty.channel.ChannelHandler;
import com.dataiku.dss.shadelibazure.io.netty.channel.ChannelHandlerContext;
import com.dataiku.dss.shadelibazure.io.netty.channel.ChannelInboundHandlerAdapter;
import com.dataiku.dss.shadelibazure.io.netty.channel.ChannelInitializer;
import com.dataiku.dss.shadelibazure.io.netty.incubator.codec.http3.Http3;
import com.dataiku.dss.shadelibazure.io.netty.incubator.codec.quic.QuicClientCodecBuilder;
import com.dataiku.dss.shadelibazure.io.netty.incubator.codec.quic.QuicSslContext;
import com.dataiku.dss.shadelibazure.io.netty.incubator.codec.quic.QuicSslEngine;
import com.dataiku.dss.shadelibazure.reactor.netty.Connection;
import com.dataiku.dss.shadelibazure.reactor.netty.ConnectionObserver;
import com.dataiku.dss.shadelibazure.reactor.netty.channel.ChannelOperations;
import com.dataiku.dss.shadelibazure.reactor.netty.http.Http3SettingsSpec;
import com.dataiku.dss.shadelibazure.reactor.netty.http.client.HttpClientConfig;
import com.dataiku.dss.shadelibazure.reactor.netty.tcp.SslProvider;
import com.dataiku.dss.shadelibazure.reactor.util.annotation.Nullable;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SNIHostName;
import javax.net.ssl.SNIServerName;

final class Http3ChannelInitializer
extends ChannelInitializer<Channel> {
    final Http3SettingsSpec http3Settings;
    final ChannelHandler loggingHandler;
    final ConnectionObserver obs;
    final ChannelOperations.OnSetup opsFactory;
    final ChannelInitializer<Channel> quicChannelInitializer;
    final SocketAddress remoteAddress;
    final SslProvider sslProvider;

    Http3ChannelInitializer(HttpClientConfig config, ChannelInitializer<Channel> quicChannelInitializer, ConnectionObserver obs, @Nullable SocketAddress remoteAddress) {
        this.http3Settings = config.http3SettingsSpec();
        this.loggingHandler = config.loggingHandler();
        this.obs = obs;
        this.opsFactory = config.channelOperationsProvider();
        this.quicChannelInitializer = quicChannelInitializer;
        this.remoteAddress = remoteAddress;
        this.sslProvider = config.sslProvider;
    }

    @Override
    protected void initChannel(Channel channel) {
        QuicClientCodecBuilder quicClientCodecBuilder = Http3.newQuicClientCodecBuilder();
        quicClientCodecBuilder.sslEngineProvider(ch -> {
            QuicSslEngine engine;
            if (!(this.sslProvider.getSslContext() instanceof QuicSslContext)) {
                throw new IllegalArgumentException("The configured SslContext is not QuicSslContext");
            }
            QuicSslContext quicSslContext = (QuicSslContext)this.sslProvider.getSslContext();
            if (this.remoteAddress instanceof InetSocketAddress) {
                InetSocketAddress sniInfo = (InetSocketAddress)this.remoteAddress;
                if (this.sslProvider.getServerNames() != null && !this.sslProvider.getServerNames().isEmpty()) {
                    SNIServerName serverName = this.sslProvider.getServerNames().get(0);
                    String serverNameStr = serverName instanceof SNIHostName ? ((SNIHostName)serverName).getAsciiName() : new String(serverName.getEncoded(), StandardCharsets.US_ASCII);
                    engine = quicSslContext.newEngine(ch.alloc(), serverNameStr, sniInfo.getPort());
                } else {
                    engine = quicSslContext.newEngine(ch.alloc(), sniInfo.getHostString(), sniInfo.getPort());
                }
            } else {
                engine = quicSslContext.newEngine(ch.alloc());
            }
            return engine;
        });
        if (this.http3Settings != null) {
            ((QuicClientCodecBuilder)((QuicClientCodecBuilder)((QuicClientCodecBuilder)quicClientCodecBuilder.initialMaxData(this.http3Settings.maxData())).initialMaxStreamDataBidirectionalLocal(this.http3Settings.maxStreamDataBidirectionalLocal())).initialMaxStreamDataBidirectionalRemote(this.http3Settings.maxStreamDataBidirectionalRemote())).initialMaxStreamsBidirectional(this.http3Settings.maxStreamsBidirectional());
            if (this.http3Settings.idleTimeout() != null) {
                quicClientCodecBuilder.maxIdleTimeout(this.http3Settings.idleTimeout().toMillis(), TimeUnit.MILLISECONDS);
            }
        }
        if (this.loggingHandler != null) {
            channel.pipeline().addLast("com.dataiku.dss.shadelibazure.reactor.left.loggingHandler", this.loggingHandler);
        }
        channel.pipeline().addLast(quicClientCodecBuilder.build());
        channel.pipeline().addLast("com.dataiku.dss.shadelibazure.reactor.left.httpTrafficHandler", (ChannelHandler)new HttpTrafficHandler(this.obs, this.quicChannelInitializer));
        ChannelOperations.addReactiveBridge(channel, this.opsFactory, this.obs);
        channel.config().setAutoRead(true);
    }

    static class HttpTrafficHandler
    extends ChannelInboundHandlerAdapter {
        final ConnectionObserver listener;
        final ChannelHandler quicChannelInitializer;

        HttpTrafficHandler(ConnectionObserver listener, ChannelHandler quicChannelInitializer) {
            this.listener = listener;
            this.quicChannelInitializer = quicChannelInitializer;
        }

        @Override
        public void channelActive(ChannelHandlerContext ctx) throws Exception {
            if (ctx.channel().isActive()) {
                Connection c = Connection.from(ctx.channel());
                this.listener.onStateChange(c, ConnectionObserver.State.CONNECTED);
                this.listener.onStateChange(c, ConnectionObserver.State.CONFIGURED);
            }
        }
    }
}

