/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.reactor.netty.http.client;

import com.dataiku.dss.shadelibazure.io.netty.channel.Channel;
import com.dataiku.dss.shadelibazure.io.netty.channel.ChannelHandler;
import com.dataiku.dss.shadelibazure.io.netty.channel.ChannelInitializer;
import com.dataiku.dss.shadelibazure.io.netty.channel.ChannelPipeline;
import com.dataiku.dss.shadelibazure.io.netty.handler.codec.http.HttpContentDecompressor;
import com.dataiku.dss.shadelibazure.io.netty.handler.logging.LoggingHandler;
import com.dataiku.dss.shadelibazure.io.netty.incubator.codec.http3.Http3ClientConnectionHandler;
import com.dataiku.dss.shadelibazure.io.netty.incubator.codec.http3.Http3FrameToHttpObjectCodec;
import com.dataiku.dss.shadelibazure.io.netty.incubator.codec.quic.QuicStreamChannel;
import com.dataiku.dss.shadelibazure.reactor.netty.ConnectionObserver;
import com.dataiku.dss.shadelibazure.reactor.netty.ReactorNetty;
import com.dataiku.dss.shadelibazure.reactor.netty.channel.ChannelMetricsRecorder;
import com.dataiku.dss.shadelibazure.reactor.netty.channel.ChannelOperations;
import com.dataiku.dss.shadelibazure.reactor.netty.http.client.AbstractHttpClientMetricsHandler;
import com.dataiku.dss.shadelibazure.reactor.netty.http.client.ContextAwareHttpClientMetricsHandler;
import com.dataiku.dss.shadelibazure.reactor.netty.http.client.ContextAwareHttpClientMetricsRecorder;
import com.dataiku.dss.shadelibazure.reactor.netty.http.client.Http2ConnectionProvider;
import com.dataiku.dss.shadelibazure.reactor.netty.http.client.Http2Pool;
import com.dataiku.dss.shadelibazure.reactor.netty.http.client.Http3ConnectionProvider;
import com.dataiku.dss.shadelibazure.reactor.netty.http.client.Http3StreamBridgeClientHandler;
import com.dataiku.dss.shadelibazure.reactor.netty.http.client.HttpClientMetricsHandler;
import com.dataiku.dss.shadelibazure.reactor.netty.http.client.HttpClientMetricsRecorder;
import com.dataiku.dss.shadelibazure.reactor.netty.http.client.HttpClientOperations;
import com.dataiku.dss.shadelibazure.reactor.netty.http.client.MicrometerHttpClientMetricsHandler;
import com.dataiku.dss.shadelibazure.reactor.netty.http.client.MicrometerHttpClientMetricsRecorder;
import com.dataiku.dss.shadelibazure.reactor.util.Logger;
import com.dataiku.dss.shadelibazure.reactor.util.Loggers;
import com.dataiku.dss.shadelibazure.reactor.util.annotation.Nullable;
import java.net.SocketAddress;
import java.util.function.Function;

final class Http3Codec
extends ChannelInitializer<QuicStreamChannel> {
    static final Logger log = Loggers.getLogger(Http3Codec.class);
    final ConnectionObserver obs;
    final ChannelOperations.OnSetup opsFactory;
    final boolean acceptGzip;
    final LoggingHandler loggingHandler;
    final ChannelMetricsRecorder metricsRecorder;
    final SocketAddress remoteAddress;
    final Function<String, String> uriTagValue;
    final boolean validate;
    static final Http3StreamBridgeClientHandler HTTP_3_STREAM_BRIDGE_CLIENT_HANDLER = new Http3StreamBridgeClientHandler();

    Http3Codec(ConnectionObserver obs, ChannelOperations.OnSetup opsFactory, boolean acceptGzip, @Nullable LoggingHandler loggingHandler, @Nullable ChannelMetricsRecorder metricsRecorder, SocketAddress remoteAddress, Function<String, String> uriTagValue, boolean validate) {
        this.obs = obs;
        this.opsFactory = opsFactory;
        this.acceptGzip = acceptGzip;
        this.loggingHandler = loggingHandler;
        this.metricsRecorder = metricsRecorder;
        this.remoteAddress = remoteAddress;
        this.uriTagValue = uriTagValue;
        this.validate = validate;
    }

    @Override
    protected void initChannel(QuicStreamChannel ch) {
        if (HttpClientOperations.log.isDebugEnabled()) {
            HttpClientOperations.log.debug(ReactorNetty.format((Channel)ch, "New HTTP/3 stream"));
        }
        ChannelPipeline pipeline = ch.pipeline();
        if (this.loggingHandler != null) {
            pipeline.addLast("com.dataiku.dss.shadelibazure.reactor.left.loggingHandler", (ChannelHandler)this.loggingHandler);
        }
        pipeline.addLast("com.dataiku.dss.shadelibazure.reactor.left.h3ToHttp11Codec", (ChannelHandler)new Http3FrameToHttpObjectCodec(false, this.validate)).addLast("com.dataiku.dss.shadelibazure.reactor.left.httpTrafficHandler", (ChannelHandler)HTTP_3_STREAM_BRIDGE_CLIENT_HANDLER);
        if (this.acceptGzip) {
            pipeline.addLast("com.dataiku.dss.shadelibazure.reactor.left.httpDecompressor", (ChannelHandler)new HttpContentDecompressor(false, 0));
        }
        ChannelOperations.addReactiveBridge((Channel)ch, this.opsFactory, this.obs);
        if (this.metricsRecorder != null && this.metricsRecorder instanceof HttpClientMetricsRecorder) {
            AbstractHttpClientMetricsHandler handler = this.metricsRecorder instanceof MicrometerHttpClientMetricsRecorder ? new MicrometerHttpClientMetricsHandler((MicrometerHttpClientMetricsRecorder)this.metricsRecorder, this.remoteAddress, null, this.uriTagValue) : (this.metricsRecorder instanceof ContextAwareHttpClientMetricsRecorder ? new ContextAwareHttpClientMetricsHandler((ContextAwareHttpClientMetricsRecorder)this.metricsRecorder, this.remoteAddress, null, this.uriTagValue) : new HttpClientMetricsHandler((HttpClientMetricsRecorder)this.metricsRecorder, this.remoteAddress, null, this.uriTagValue));
            pipeline.addBefore("com.dataiku.dss.shadelibazure.reactor.right.reactiveBridge", "com.dataiku.dss.shadelibazure.reactor.left.httpMetricsHandler", handler);
        }
        if (log.isDebugEnabled()) {
            log.debug(ReactorNetty.format((Channel)ch, "Initialized HTTP/3 stream pipeline {}"), ch.pipeline());
            ConnectionObserver owner = (ConnectionObserver)ch.parent().attr(Http3ConnectionProvider.OWNER).get();
            if (owner instanceof Http3ConnectionProvider.DisposableAcquire) {
                Http3ConnectionProvider.DisposableAcquire da = (Http3ConnectionProvider.DisposableAcquire)owner;
                Http2Pool.Http2PooledRef http2PooledRef = Http2ConnectionProvider.http2PooledRef(da.pooledRef);
                Http2ConnectionProvider.logStreamsState((Channel)ch, http2PooledRef.slot, "Stream opened");
            }
        }
    }

    static ChannelHandler newHttp3ClientConnectionHandler() {
        return new Http3ClientConnectionHandler();
    }
}

