/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.reactor.netty.http.client;

import com.dataiku.dss.shadelibazure.io.netty.resolver.AddressResolverGroup;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Mono;
import com.dataiku.dss.shadelibazure.reactor.netty.Connection;
import com.dataiku.dss.shadelibazure.reactor.netty.ConnectionObserver;
import com.dataiku.dss.shadelibazure.reactor.netty.http.HttpResources;
import com.dataiku.dss.shadelibazure.reactor.netty.http.client.Http2ConnectionProvider;
import com.dataiku.dss.shadelibazure.reactor.netty.http.client.Http3ConnectionProvider;
import com.dataiku.dss.shadelibazure.reactor.netty.http.client.HttpClientConfig;
import com.dataiku.dss.shadelibazure.reactor.netty.resources.ConnectionProvider;
import com.dataiku.dss.shadelibazure.reactor.netty.transport.TransportConfig;
import com.dataiku.dss.shadelibazure.reactor.util.annotation.Nullable;
import java.net.SocketAddress;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.Supplier;

final class HttpConnectionProvider
implements ConnectionProvider {
    final ConnectionProvider http1ConnectionProvider;
    final AtomicReference<ConnectionProvider> http2ConnectionProvider = new AtomicReference();
    final AtomicReference<ConnectionProvider> http3ConnectionProvider = new AtomicReference();
    static final Function<ConnectionProvider, ConnectionProvider> HTTP2_CONNECTION_PROVIDER_FACTORY = Http2ConnectionProvider::new;
    static final Function<ConnectionProvider, ConnectionProvider> HTTP3_CONNECTION_PROVIDER_FACTORY = Http3ConnectionProvider::new;

    @Override
    public Mono<? extends Connection> acquire(TransportConfig config, ConnectionObserver connectionObserver, @Nullable Supplier<? extends SocketAddress> remoteAddress, @Nullable AddressResolverGroup<?> resolverGroup) {
        boolean isHttp3;
        boolean bl = isHttp3 = ((HttpClientConfig)config)._protocols == 8;
        if (((HttpClientConfig)config)._protocols == 4) {
            return this.http1ConnectionProvider().acquire(config, connectionObserver, remoteAddress, resolverGroup);
        }
        if (this.http1ConnectionProvider == null) {
            if (isHttp3) {
                return HttpResources.get().getOrCreateHttp3ConnectionProvider(HTTP3_CONNECTION_PROVIDER_FACTORY).acquire(config, connectionObserver, remoteAddress, resolverGroup);
            }
            return HttpResources.get().getOrCreateHttp2ConnectionProvider(HTTP2_CONNECTION_PROVIDER_FACTORY).acquire(config, connectionObserver, remoteAddress, resolverGroup);
        }
        return isHttp3 ? this.getOrCreateHttp3().acquire(config, connectionObserver, remoteAddress, resolverGroup) : this.getOrCreateHttp2().acquire(config, connectionObserver, remoteAddress, resolverGroup);
    }

    @Override
    public void disposeWhen(SocketAddress address) {
        this.http1ConnectionProvider().disposeWhen(address);
    }

    @Override
    public int maxConnections() {
        return this.http1ConnectionProvider().maxConnections();
    }

    @Override
    @Nullable
    public Map<SocketAddress, Integer> maxConnectionsPerHost() {
        return this.http1ConnectionProvider().maxConnectionsPerHost();
    }

    HttpConnectionProvider() {
        this(null);
    }

    HttpConnectionProvider(@Nullable ConnectionProvider http1ConnectionProvider) {
        this.http1ConnectionProvider = http1ConnectionProvider;
    }

    ConnectionProvider getOrCreateHttp2() {
        ConnectionProvider provider = this.http2ConnectionProvider.get();
        if (provider == null) {
            ConnectionProvider newProvider = HTTP2_CONNECTION_PROVIDER_FACTORY.apply(this.http1ConnectionProvider);
            if (!this.http2ConnectionProvider.compareAndSet(null, newProvider)) {
                newProvider.dispose();
            }
            provider = this.getOrCreateHttp2();
        }
        return provider;
    }

    ConnectionProvider getOrCreateHttp3() {
        ConnectionProvider provider = this.http3ConnectionProvider.get();
        if (provider == null) {
            ConnectionProvider newProvider = HTTP3_CONNECTION_PROVIDER_FACTORY.apply(this.http1ConnectionProvider);
            if (!this.http3ConnectionProvider.compareAndSet(null, newProvider)) {
                newProvider.dispose();
            }
            provider = this.getOrCreateHttp3();
        }
        return provider;
    }

    ConnectionProvider http1ConnectionProvider() {
        return this.http1ConnectionProvider != null ? this.http1ConnectionProvider : HttpResources.get();
    }
}

