/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.reactor.netty.http.client;

import com.dataiku.dss.shadelibazure.io.micrometer.core.instrument.Meter;
import com.dataiku.dss.shadelibazure.io.micrometer.core.instrument.Tags;
import com.dataiku.dss.shadelibazure.io.micrometer.core.instrument.Timer;
import com.dataiku.dss.shadelibazure.reactor.core.Disposable;
import com.dataiku.dss.shadelibazure.reactor.netty.Metrics;
import com.dataiku.dss.shadelibazure.reactor.netty.http.client.Http2ConnectionProviderMeters;
import com.dataiku.dss.shadelibazure.reactor.netty.internal.shaded.reactor.pool.PoolMetricsRecorder;
import java.net.SocketAddress;
import java.util.concurrent.TimeUnit;

final class MicrometerPoolMetricsRecorder
implements Disposable,
PoolMetricsRecorder {
    final Timer pendingSuccessTimer;
    final Timer pendingErrorTimer;

    MicrometerPoolMetricsRecorder(String id, String poolName, SocketAddress remoteAddress) {
        this.pendingSuccessTimer = MicrometerPoolMetricsRecorder.buildTimer(id, poolName, remoteAddress, "SUCCESS");
        this.pendingErrorTimer = MicrometerPoolMetricsRecorder.buildTimer(id, poolName, remoteAddress, "ERROR");
    }

    @Override
    public void recordAllocationSuccessAndLatency(long latencyMs) {
    }

    @Override
    public void recordAllocationFailureAndLatency(long latencyMs) {
    }

    @Override
    public void recordResetLatency(long latencyMs) {
    }

    @Override
    public void recordDestroyLatency(long latencyMs) {
    }

    @Override
    public void recordRecycled() {
    }

    @Override
    public void recordLifetimeDuration(long millisecondsSinceAllocation) {
    }

    @Override
    public void recordIdleTime(long millisecondsIdle) {
    }

    @Override
    public void recordSlowPath() {
    }

    @Override
    public void recordFastPath() {
    }

    @Override
    public void recordPendingSuccessAndLatency(long latencyMs) {
        this.pendingSuccessTimer.record(latencyMs, TimeUnit.MILLISECONDS);
    }

    @Override
    public void recordPendingFailureAndLatency(long latencyMs) {
        this.pendingErrorTimer.record(latencyMs, TimeUnit.MILLISECONDS);
    }

    @Override
    public void dispose() {
        Metrics.REGISTRY.remove((Meter)this.pendingSuccessTimer);
        Metrics.REGISTRY.remove((Meter)this.pendingErrorTimer);
    }

    static Timer buildTimer(String id, String poolName, SocketAddress remoteAddress, String status) {
        return Timer.builder((String)Http2ConnectionProviderMeters.PENDING_STREAMS_TIME.getName()).tags((Iterable)Tags.of((String[])new String[]{Http2ConnectionProviderMeters.PendingStreamsTimeTags.ID.asString(), id, Http2ConnectionProviderMeters.PendingStreamsTimeTags.REMOTE_ADDRESS.asString(), Metrics.formatSocketAddress(remoteAddress), Http2ConnectionProviderMeters.PendingStreamsTimeTags.NAME.asString(), poolName, Http2ConnectionProviderMeters.PendingStreamsTimeTags.STATUS.asString(), status})).register(Metrics.REGISTRY);
    }
}

