/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.reactor.netty.http.client;

import com.dataiku.dss.shadelibazure.io.netty.buffer.ByteBufAllocator;
import com.dataiku.dss.shadelibazure.io.netty.channel.ChannelOption;
import com.dataiku.dss.shadelibazure.org.reactivestreams.Publisher;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Flux;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Mono;
import com.dataiku.dss.shadelibazure.reactor.netty.ByteBufFlux;
import com.dataiku.dss.shadelibazure.reactor.netty.Connection;
import com.dataiku.dss.shadelibazure.reactor.netty.http.client.HttpClient;
import com.dataiku.dss.shadelibazure.reactor.netty.http.client.HttpClientConfig;
import com.dataiku.dss.shadelibazure.reactor.netty.http.client.HttpClientConnect;
import com.dataiku.dss.shadelibazure.reactor.netty.http.client.HttpClientFinalizer;
import com.dataiku.dss.shadelibazure.reactor.netty.http.client.HttpClientRequest;
import com.dataiku.dss.shadelibazure.reactor.netty.http.websocket.WebsocketInbound;
import com.dataiku.dss.shadelibazure.reactor.netty.http.websocket.WebsocketOutbound;
import java.net.URI;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;

final class WebsocketFinalizer
extends HttpClientConnect
implements HttpClient.WebsocketSender {
    WebsocketFinalizer(HttpClientConfig config) {
        super(config);
    }

    @Override
    public HttpClient.WebsocketSender uri(Mono<String> uri) {
        Objects.requireNonNull(uri, "uri");
        HttpClient dup = this.duplicate();
        ((HttpClientConfig)dup.configuration()).deferredConf(config -> uri.map(s2 -> {
            config.uriStr = s2;
            config.uri = null;
            return config;
        }));
        return (WebsocketFinalizer)dup;
    }

    @Override
    public HttpClient.WebsocketSender uri(String uri) {
        Objects.requireNonNull(uri, "uri");
        HttpClient dup = this.duplicate();
        ((HttpClientConfig)dup.configuration()).uriStr = uri;
        ((HttpClientConfig)dup.configuration()).uri = null;
        return (WebsocketFinalizer)dup;
    }

    @Override
    public HttpClient.WebsocketSender uri(URI uri) {
        Objects.requireNonNull(uri, "uri");
        if (!uri.isAbsolute()) {
            throw new IllegalArgumentException("URI is not absolute: " + uri);
        }
        HttpClient dup = this.duplicate();
        ((HttpClientConfig)dup.configuration()).uriStr = null;
        ((HttpClientConfig)dup.configuration()).uri = uri;
        return (WebsocketFinalizer)dup;
    }

    public WebsocketFinalizer send(Function<? super HttpClientRequest, ? extends Publisher<Void>> sender) {
        Objects.requireNonNull(sender, "requestBody");
        HttpClient dup = this.duplicate();
        ((HttpClientConfig)dup.configuration()).body = (req, out) -> (Publisher)sender.apply((HttpClientRequest)req);
        return (WebsocketFinalizer)dup;
    }

    @Override
    public Mono<? extends Connection> connect() {
        return super.connect();
    }

    @Override
    public <V> Flux<V> handle(BiFunction<? super WebsocketInbound, ? super WebsocketOutbound, ? extends Publisher<V>> receiver) {
        Mono<? extends Connection> connector = this.connect();
        return connector.flatMapMany(c -> Flux.from((Publisher)receiver.apply((WebsocketInbound)c, (WebsocketOutbound)c)).doFinally(s2 -> HttpClientFinalizer.discard(c)));
    }

    @Override
    public ByteBufFlux receive() {
        ByteBufAllocator alloc = (ByteBufAllocator)this.configuration().options().get(ChannelOption.ALLOCATOR);
        if (alloc == null) {
            alloc = ByteBufAllocator.DEFAULT;
        }
        Mono<? extends Connection> connector = this.connect();
        return ByteBufFlux.fromInbound(connector.flatMapMany(HttpClientFinalizer.contentReceiver), alloc);
    }

    @Override
    protected HttpClient duplicate() {
        return new WebsocketFinalizer(new HttpClientConfig(this.config));
    }
}

