/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.reactor.netty.http.server;

import com.dataiku.dss.shadelibazure.io.netty.channel.Channel;
import com.dataiku.dss.shadelibazure.io.netty.channel.ChannelHandler;
import com.dataiku.dss.shadelibazure.io.netty.channel.ChannelInitializer;
import com.dataiku.dss.shadelibazure.io.netty.channel.ChannelPipeline;
import com.dataiku.dss.shadelibazure.io.netty.handler.codec.http.HttpRequest;
import com.dataiku.dss.shadelibazure.io.netty.handler.codec.http.cookie.ServerCookieDecoder;
import com.dataiku.dss.shadelibazure.io.netty.handler.codec.http.cookie.ServerCookieEncoder;
import com.dataiku.dss.shadelibazure.io.netty.incubator.codec.http3.Http3FrameToHttpObjectCodec;
import com.dataiku.dss.shadelibazure.io.netty.incubator.codec.http3.Http3ServerConnectionHandler;
import com.dataiku.dss.shadelibazure.io.netty.incubator.codec.quic.QuicStreamChannel;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Mono;
import com.dataiku.dss.shadelibazure.reactor.netty.Connection;
import com.dataiku.dss.shadelibazure.reactor.netty.ConnectionObserver;
import com.dataiku.dss.shadelibazure.reactor.netty.ReactorNetty;
import com.dataiku.dss.shadelibazure.reactor.netty.channel.ChannelMetricsRecorder;
import com.dataiku.dss.shadelibazure.reactor.netty.channel.ChannelOperations;
import com.dataiku.dss.shadelibazure.reactor.netty.http.logging.HttpMessageLogFactory;
import com.dataiku.dss.shadelibazure.reactor.netty.http.server.AbstractHttpServerMetricsHandler;
import com.dataiku.dss.shadelibazure.reactor.netty.http.server.ConnectionInfo;
import com.dataiku.dss.shadelibazure.reactor.netty.http.server.ContextAwareHttpServerMetricsHandler;
import com.dataiku.dss.shadelibazure.reactor.netty.http.server.ContextAwareHttpServerMetricsRecorder;
import com.dataiku.dss.shadelibazure.reactor.netty.http.server.Http3StreamBridgeServerHandler;
import com.dataiku.dss.shadelibazure.reactor.netty.http.server.HttpServerFormDecoderProvider;
import com.dataiku.dss.shadelibazure.reactor.netty.http.server.HttpServerMetricsHandler;
import com.dataiku.dss.shadelibazure.reactor.netty.http.server.HttpServerMetricsRecorder;
import com.dataiku.dss.shadelibazure.reactor.netty.http.server.HttpServerRequest;
import com.dataiku.dss.shadelibazure.reactor.netty.http.server.HttpServerResponse;
import com.dataiku.dss.shadelibazure.reactor.netty.http.server.MicrometerHttpServerMetricsHandler;
import com.dataiku.dss.shadelibazure.reactor.netty.http.server.MicrometerHttpServerMetricsRecorder;
import com.dataiku.dss.shadelibazure.reactor.netty.http.server.SimpleCompressionHandler;
import com.dataiku.dss.shadelibazure.reactor.netty.http.server.compression.HttpCompressionOptionsSpec;
import com.dataiku.dss.shadelibazure.reactor.netty.http.server.logging.AccessLog;
import com.dataiku.dss.shadelibazure.reactor.netty.http.server.logging.AccessLogArgProvider;
import com.dataiku.dss.shadelibazure.reactor.netty.http.server.logging.AccessLogHandlerFactory;
import com.dataiku.dss.shadelibazure.reactor.netty.http.server.logging.error.DefaultErrorLogHandler;
import com.dataiku.dss.shadelibazure.reactor.netty.http.server.logging.error.ErrorLog;
import com.dataiku.dss.shadelibazure.reactor.netty.http.server.logging.error.ErrorLogArgProvider;
import com.dataiku.dss.shadelibazure.reactor.util.Logger;
import com.dataiku.dss.shadelibazure.reactor.util.Loggers;
import com.dataiku.dss.shadelibazure.reactor.util.annotation.Nullable;
import java.time.Duration;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Function;

final class Http3Codec
extends ChannelInitializer<QuicStreamChannel> {
    static final Logger log = Loggers.getLogger(Http3Codec.class);
    final boolean accessLogEnabled;
    final Function<AccessLogArgProvider, AccessLog> accessLog;
    final HttpCompressionOptionsSpec compressionOptions;
    final BiPredicate<HttpServerRequest, HttpServerResponse> compressPredicate;
    final ServerCookieDecoder cookieDecoder;
    final ServerCookieEncoder cookieEncoder;
    final boolean errorLogEnabled;
    final Function<ErrorLogArgProvider, ErrorLog> errorLog;
    final HttpServerFormDecoderProvider formDecoderProvider;
    final BiFunction<ConnectionInfo, HttpRequest, ConnectionInfo> forwardedHeaderHandler;
    final HttpMessageLogFactory httpMessageLogFactory;
    final ConnectionObserver listener;
    final BiFunction<? super Mono<Void>, ? super Connection, ? extends Mono<Void>> mapHandle;
    final Function<String, String> methodTagValue;
    final ChannelMetricsRecorder metricsRecorder;
    final int minCompressionSize;
    final ChannelOperations.OnSetup opsFactory;
    final Duration readTimeout;
    final Duration requestTimeout;
    final Function<String, String> uriTagValue;
    final boolean validate;

    Http3Codec(boolean accessLogEnabled, @Nullable Function<AccessLogArgProvider, AccessLog> accessLog, @Nullable HttpCompressionOptionsSpec compressionOptions, @Nullable BiPredicate<HttpServerRequest, HttpServerResponse> compressPredicate, ServerCookieDecoder decoder, ServerCookieEncoder encoder, boolean errorLogEnabled, @Nullable Function<ErrorLogArgProvider, ErrorLog> errorLog, HttpServerFormDecoderProvider formDecoderProvider, @Nullable BiFunction<ConnectionInfo, HttpRequest, ConnectionInfo> forwardedHeaderHandler, HttpMessageLogFactory httpMessageLogFactory, ConnectionObserver listener, @Nullable BiFunction<? super Mono<Void>, ? super Connection, ? extends Mono<Void>> mapHandle, @Nullable Function<String, String> methodTagValue, @Nullable ChannelMetricsRecorder metricsRecorder, int minCompressionSize, ChannelOperations.OnSetup opsFactory, @Nullable Duration readTimeout, @Nullable Duration requestTimeout, @Nullable Function<String, String> uriTagValue, boolean validate) {
        this.accessLogEnabled = accessLogEnabled;
        this.accessLog = accessLog;
        this.compressionOptions = compressionOptions;
        this.compressPredicate = compressPredicate;
        this.cookieDecoder = decoder;
        this.cookieEncoder = encoder;
        this.errorLogEnabled = errorLogEnabled;
        this.errorLog = errorLog;
        this.formDecoderProvider = formDecoderProvider;
        this.forwardedHeaderHandler = forwardedHeaderHandler;
        this.httpMessageLogFactory = httpMessageLogFactory;
        this.listener = listener;
        this.mapHandle = mapHandle;
        this.methodTagValue = methodTagValue;
        this.metricsRecorder = metricsRecorder;
        this.minCompressionSize = minCompressionSize;
        this.opsFactory = opsFactory;
        this.readTimeout = readTimeout;
        this.requestTimeout = requestTimeout;
        this.uriTagValue = uriTagValue;
        this.validate = validate;
    }

    @Override
    protected void initChannel(QuicStreamChannel channel) {
        boolean alwaysCompress;
        ChannelPipeline p = channel.pipeline();
        if (this.accessLogEnabled) {
            p.addLast("com.dataiku.dss.shadelibazure.reactor.left.accessLogHandler", AccessLogHandlerFactory.H3.create(this.accessLog));
        }
        p.addLast("com.dataiku.dss.shadelibazure.reactor.left.h3ToHttp11Codec", (ChannelHandler)new Http3FrameToHttpObjectCodec(true, this.validate)).addLast("com.dataiku.dss.shadelibazure.reactor.left.httpTrafficHandler", (ChannelHandler)new Http3StreamBridgeServerHandler(this.compressPredicate, this.compressionOptions, this.cookieDecoder, this.cookieEncoder, this.formDecoderProvider, this.forwardedHeaderHandler, this.httpMessageLogFactory, this.listener, this.mapHandle, this.readTimeout, this.requestTimeout));
        boolean bl = alwaysCompress = this.compressPredicate == null && this.minCompressionSize == 0;
        if (alwaysCompress) {
            p.addLast("com.dataiku.dss.shadelibazure.reactor.left.compressionHandler", (ChannelHandler)SimpleCompressionHandler.create(this.compressionOptions));
        }
        ChannelOperations.addReactiveBridge((Channel)channel, this.opsFactory, this.listener);
        if (this.metricsRecorder != null && this.metricsRecorder instanceof HttpServerMetricsRecorder) {
            AbstractHttpServerMetricsHandler handler = this.metricsRecorder instanceof MicrometerHttpServerMetricsRecorder ? new MicrometerHttpServerMetricsHandler((MicrometerHttpServerMetricsRecorder)this.metricsRecorder, this.methodTagValue, this.uriTagValue) : (this.metricsRecorder instanceof ContextAwareHttpServerMetricsRecorder ? new ContextAwareHttpServerMetricsHandler((ContextAwareHttpServerMetricsRecorder)this.metricsRecorder, this.methodTagValue, this.uriTagValue) : new HttpServerMetricsHandler((HttpServerMetricsRecorder)this.metricsRecorder, this.methodTagValue, this.uriTagValue));
            p.addBefore("com.dataiku.dss.shadelibazure.reactor.right.reactiveBridge", "com.dataiku.dss.shadelibazure.reactor.left.httpMetricsHandler", handler);
        }
        if (this.errorLogEnabled) {
            p.addBefore("com.dataiku.dss.shadelibazure.reactor.right.reactiveBridge", "com.dataiku.dss.shadelibazure.reactor.left.errorLogHandler", new DefaultErrorLogHandler(this.errorLog));
        }
        channel.pipeline().remove(this);
        if (log.isDebugEnabled()) {
            log.debug(ReactorNetty.format((Channel)channel, "Initialized HTTP/3 stream pipeline {}"), p);
        }
    }

    static ChannelHandler newHttp3ServerConnectionHandler(boolean accessLogEnabled, @Nullable Function<AccessLogArgProvider, AccessLog> accessLog, @Nullable HttpCompressionOptionsSpec compressionOptions, @Nullable BiPredicate<HttpServerRequest, HttpServerResponse> compressPredicate, ServerCookieDecoder decoder, ServerCookieEncoder encoder, boolean errorLogEnabled, @Nullable Function<ErrorLogArgProvider, ErrorLog> errorLog, HttpServerFormDecoderProvider formDecoderProvider, @Nullable BiFunction<ConnectionInfo, HttpRequest, ConnectionInfo> forwardedHeaderHandler, HttpMessageLogFactory httpMessageLogFactory, ConnectionObserver listener, @Nullable BiFunction<? super Mono<Void>, ? super Connection, ? extends Mono<Void>> mapHandle, @Nullable Function<String, String> methodTagValue, @Nullable ChannelMetricsRecorder metricsRecorder, int minCompressionSize, ChannelOperations.OnSetup opsFactory, @Nullable Duration readTimeout, @Nullable Duration requestTimeout, @Nullable Function<String, String> uriTagValue, boolean validate) {
        return new Http3ServerConnectionHandler((ChannelHandler)new Http3Codec(accessLogEnabled, accessLog, compressionOptions, compressPredicate, decoder, encoder, errorLogEnabled, errorLog, formDecoderProvider, forwardedHeaderHandler, httpMessageLogFactory, listener, mapHandle, methodTagValue, metricsRecorder, minCompressionSize, opsFactory, readTimeout, requestTimeout, uriTagValue, validate));
    }
}

