/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.reactor.netty.http.server;

import com.dataiku.dss.shadelibazure.io.netty.handler.codec.http.HttpRequest;
import com.dataiku.dss.shadelibazure.io.netty.handler.codec.http.HttpVersion;
import com.dataiku.dss.shadelibazure.io.netty.handler.codec.http.cookie.ServerCookieDecoder;
import com.dataiku.dss.shadelibazure.io.netty.handler.codec.http.cookie.ServerCookieEncoder;
import com.dataiku.dss.shadelibazure.io.netty.incubator.codec.quic.QuicChannel;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Mono;
import com.dataiku.dss.shadelibazure.reactor.netty.Connection;
import com.dataiku.dss.shadelibazure.reactor.netty.ConnectionObserver;
import com.dataiku.dss.shadelibazure.reactor.netty.http.logging.HttpMessageLogFactory;
import com.dataiku.dss.shadelibazure.reactor.netty.http.server.ConnectionInfo;
import com.dataiku.dss.shadelibazure.reactor.netty.http.server.HttpServerFormDecoderProvider;
import com.dataiku.dss.shadelibazure.reactor.netty.http.server.HttpServerOperations;
import com.dataiku.dss.shadelibazure.reactor.netty.http.server.HttpServerRequest;
import com.dataiku.dss.shadelibazure.reactor.netty.http.server.HttpServerResponse;
import com.dataiku.dss.shadelibazure.reactor.netty.http.server.compression.HttpCompressionOptionsSpec;
import com.dataiku.dss.shadelibazure.reactor.util.annotation.Nullable;
import java.net.SocketAddress;
import java.time.Duration;
import java.time.ZonedDateTime;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;

final class Http3ServerOperations
extends HttpServerOperations {
    static final HttpVersion H3 = HttpVersion.valueOf("HTTP/3.0");

    Http3ServerOperations(HttpServerOperations replaced) {
        super(replaced);
    }

    Http3ServerOperations(Connection c, ConnectionObserver listener, HttpRequest nettyRequest, @Nullable HttpCompressionOptionsSpec compressionOptions, @Nullable BiPredicate<HttpServerRequest, HttpServerResponse> compressionPredicate, ConnectionInfo connectionInfo, ServerCookieDecoder decoder, ServerCookieEncoder encoder, HttpServerFormDecoderProvider formDecoderProvider, HttpMessageLogFactory httpMessageLogFactory, boolean isHttp2, @Nullable BiFunction<? super Mono<Void>, ? super Connection, ? extends Mono<Void>> mapHandle, @Nullable Duration readTimeout, @Nullable Duration requestTimeout, boolean secured, ZonedDateTime timestamp) {
        super(c, listener, nettyRequest, compressionOptions, compressionPredicate, connectionInfo, decoder, encoder, formDecoderProvider, httpMessageLogFactory, isHttp2, mapHandle, readTimeout, requestTimeout, secured, timestamp, true);
    }

    @Override
    @Nullable
    public SocketAddress connectionHostAddress() {
        return ((QuicChannel)this.channel().parent()).localSocketAddress();
    }

    @Override
    @Nullable
    public SocketAddress connectionRemoteAddress() {
        return ((QuicChannel)this.channel().parent()).remoteSocketAddress();
    }

    @Override
    public String protocol() {
        return H3.text();
    }

    @Override
    public HttpVersion version() {
        if (this.nettyRequest != null) {
            return H3;
        }
        throw new IllegalStateException("request not parsed");
    }
}

