/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.reactor.netty.http.server;

import com.dataiku.dss.shadelibazure.io.netty.buffer.ByteBuf;
import com.dataiku.dss.shadelibazure.io.netty.channel.ChannelDuplexHandler;
import com.dataiku.dss.shadelibazure.io.netty.channel.ChannelFuture;
import com.dataiku.dss.shadelibazure.io.netty.channel.ChannelHandlerContext;
import com.dataiku.dss.shadelibazure.io.netty.channel.ChannelPromise;
import com.dataiku.dss.shadelibazure.io.netty.handler.codec.DecoderResult;
import com.dataiku.dss.shadelibazure.io.netty.handler.codec.http.DefaultFullHttpResponse;
import com.dataiku.dss.shadelibazure.io.netty.handler.codec.http.DefaultHttpContent;
import com.dataiku.dss.shadelibazure.io.netty.handler.codec.http.DefaultHttpResponse;
import com.dataiku.dss.shadelibazure.io.netty.handler.codec.http.DefaultLastHttpContent;
import com.dataiku.dss.shadelibazure.io.netty.handler.codec.http.HttpObject;
import com.dataiku.dss.shadelibazure.io.netty.handler.codec.http.HttpRequest;
import com.dataiku.dss.shadelibazure.io.netty.handler.codec.http.HttpResponse;
import com.dataiku.dss.shadelibazure.io.netty.handler.codec.http.HttpResponseStatus;
import com.dataiku.dss.shadelibazure.io.netty.handler.codec.http.LastHttpContent;
import com.dataiku.dss.shadelibazure.io.netty.handler.codec.http.cookie.ServerCookieDecoder;
import com.dataiku.dss.shadelibazure.io.netty.handler.codec.http.cookie.ServerCookieEncoder;
import com.dataiku.dss.shadelibazure.io.netty.incubator.codec.quic.QuicChannel;
import com.dataiku.dss.shadelibazure.io.netty.incubator.codec.quic.QuicStreamChannel;
import com.dataiku.dss.shadelibazure.io.netty.util.ReferenceCountUtil;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Mono;
import com.dataiku.dss.shadelibazure.reactor.netty.Connection;
import com.dataiku.dss.shadelibazure.reactor.netty.ConnectionObserver;
import com.dataiku.dss.shadelibazure.reactor.netty.ReactorNetty;
import com.dataiku.dss.shadelibazure.reactor.netty.http.logging.HttpMessageArgProviderFactory;
import com.dataiku.dss.shadelibazure.reactor.netty.http.logging.HttpMessageLogFactory;
import com.dataiku.dss.shadelibazure.reactor.netty.http.server.ConnectionInfo;
import com.dataiku.dss.shadelibazure.reactor.netty.http.server.Http3ServerOperations;
import com.dataiku.dss.shadelibazure.reactor.netty.http.server.HttpServerFormDecoderProvider;
import com.dataiku.dss.shadelibazure.reactor.netty.http.server.HttpServerOperations;
import com.dataiku.dss.shadelibazure.reactor.netty.http.server.HttpServerRequest;
import com.dataiku.dss.shadelibazure.reactor.netty.http.server.HttpServerResponse;
import com.dataiku.dss.shadelibazure.reactor.netty.http.server.compression.HttpCompressionOptionsSpec;
import com.dataiku.dss.shadelibazure.reactor.util.annotation.Nullable;
import java.net.SocketAddress;
import java.time.Duration;
import java.time.ZonedDateTime;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;

final class Http3StreamBridgeServerHandler
extends ChannelDuplexHandler {
    final BiPredicate<HttpServerRequest, HttpServerResponse> compress;
    final HttpCompressionOptionsSpec compressionOptions;
    final ServerCookieDecoder cookieDecoder;
    final ServerCookieEncoder cookieEncoder;
    final HttpServerFormDecoderProvider formDecoderProvider;
    final BiFunction<ConnectionInfo, HttpRequest, ConnectionInfo> forwardedHeaderHandler;
    final HttpMessageLogFactory httpMessageLogFactory;
    final ConnectionObserver listener;
    final BiFunction<? super Mono<Void>, ? super Connection, ? extends Mono<Void>> mapHandle;
    final Duration readTimeout;
    final Duration requestTimeout;
    SocketAddress remoteAddress;
    boolean pendingResponse;

    Http3StreamBridgeServerHandler(@Nullable BiPredicate<HttpServerRequest, HttpServerResponse> compress, @Nullable HttpCompressionOptionsSpec compressionOptions, ServerCookieDecoder decoder, ServerCookieEncoder encoder, HttpServerFormDecoderProvider formDecoderProvider, @Nullable BiFunction<ConnectionInfo, HttpRequest, ConnectionInfo> forwardedHeaderHandler, HttpMessageLogFactory httpMessageLogFactory, ConnectionObserver listener, @Nullable BiFunction<? super Mono<Void>, ? super Connection, ? extends Mono<Void>> mapHandle, @Nullable Duration readTimeout, @Nullable Duration requestTimeout) {
        this.compress = compress;
        this.compressionOptions = compressionOptions;
        this.cookieDecoder = decoder;
        this.cookieEncoder = encoder;
        this.formDecoderProvider = formDecoderProvider;
        this.forwardedHeaderHandler = forwardedHeaderHandler;
        this.httpMessageLogFactory = httpMessageLogFactory;
        this.listener = listener;
        this.mapHandle = mapHandle;
        this.readTimeout = readTimeout;
        this.requestTimeout = requestTimeout;
    }

    @Override
    public void handlerAdded(ChannelHandlerContext ctx) {
        if (HttpServerOperations.log.isDebugEnabled()) {
            HttpServerOperations.log.debug(ReactorNetty.format(ctx.channel(), "New HTTP/3 stream"));
        }
    }

    @Override
    public void channelActive(ChannelHandlerContext ctx) {
        ctx.read();
    }

    @Override
    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        assert (ctx.channel().parent() instanceof QuicChannel);
        QuicChannel parent = (QuicChannel)ctx.channel().parent();
        if (this.remoteAddress == null) {
            this.remoteAddress = parent.remoteSocketAddress();
        }
        if (msg instanceof HttpRequest) {
            Http3ServerOperations ops;
            HttpRequest request = (HttpRequest)msg;
            ZonedDateTime timestamp = ZonedDateTime.now(ReactorNetty.ZONE_ID_SYSTEM);
            ConnectionInfo connectionInfo = null;
            try {
                this.pendingResponse = true;
                connectionInfo = ConnectionInfo.from(request, true, parent.localSocketAddress(), this.remoteAddress, this.forwardedHeaderHandler);
                ops = new Http3ServerOperations(Connection.from(ctx.channel()), this.listener, request, this.compressionOptions, this.compress, connectionInfo, this.cookieDecoder, this.cookieEncoder, this.formDecoderProvider, this.httpMessageLogFactory, true, this.mapHandle, this.readTimeout, this.requestTimeout, true, timestamp);
            }
            catch (RuntimeException e) {
                this.pendingResponse = false;
                request.setDecoderResult(DecoderResult.failure(e.getCause() != null ? e.getCause() : e));
                HttpServerOperations.sendDecodingFailures(ctx, this.listener, true, e, msg, this.httpMessageLogFactory, true, timestamp, connectionInfo, this.remoteAddress, true);
                return;
            }
            ops.bind();
            this.listener.onStateChange(ops, ConnectionObserver.State.CONFIGURED);
        } else if (!this.pendingResponse) {
            if (HttpServerOperations.log.isDebugEnabled()) {
                HttpServerOperations.log.debug(ReactorNetty.format(ctx.channel(), "Dropped HTTP content, since response has been sent already: {}"), msg instanceof HttpObject ? this.httpMessageLogFactory.debug(HttpMessageArgProviderFactory.create(msg)) : msg);
            }
            ReferenceCountUtil.release(msg);
            ctx.read();
            return;
        }
        ctx.fireChannelRead(msg);
    }

    @Override
    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) {
        Class<?> msgClass = msg.getClass();
        if (msgClass == DefaultHttpResponse.class) {
            ctx.write(msg, promise);
        } else if (msgClass == DefaultFullHttpResponse.class) {
            ChannelFuture f = ctx.write(msg, promise);
            if (HttpResponseStatus.CONTINUE.code() == ((DefaultFullHttpResponse)msg).status().code()) {
                return;
            }
            this.finalizeResponse(ctx, f);
        } else if (msg == LastHttpContent.EMPTY_LAST_CONTENT || msgClass == DefaultLastHttpContent.class) {
            this.finalizeResponse(ctx, ctx.write(msg, promise));
        } else if (msg instanceof ByteBuf) {
            ctx.write(new DefaultHttpContent((ByteBuf)msg), promise);
        } else if (msg instanceof HttpResponse && HttpResponseStatus.CONTINUE.code() == ((HttpResponse)msg).status().code()) {
            ctx.write(msg, promise);
        } else {
            ChannelFuture f = ctx.write(msg, promise);
            if (msg instanceof LastHttpContent) {
                this.finalizeResponse(ctx, f);
            }
        }
    }

    void finalizeResponse(ChannelHandlerContext ctx, ChannelFuture f) {
        this.pendingResponse = false;
        f.addListener(QuicStreamChannel.SHUTDOWN_OUTPUT);
        ctx.read();
    }
}

