/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.reactor.netty.http.server;

import com.dataiku.dss.shadelibazure.io.netty.buffer.ByteBuf;
import com.dataiku.dss.shadelibazure.io.netty.channel.ChannelHandlerContext;
import com.dataiku.dss.shadelibazure.io.netty.channel.ChannelPromise;
import com.dataiku.dss.shadelibazure.io.netty.handler.codec.DecoderException;
import com.dataiku.dss.shadelibazure.io.netty.handler.codec.compression.CompressionOptions;
import com.dataiku.dss.shadelibazure.io.netty.handler.codec.http.DefaultHttpContent;
import com.dataiku.dss.shadelibazure.io.netty.handler.codec.http.DefaultHttpRequest;
import com.dataiku.dss.shadelibazure.io.netty.handler.codec.http.FullHttpRequest;
import com.dataiku.dss.shadelibazure.io.netty.handler.codec.http.HttpContentCompressor;
import com.dataiku.dss.shadelibazure.io.netty.handler.codec.http.HttpRequest;
import com.dataiku.dss.shadelibazure.io.netty.handler.codec.http.HttpResponse;
import com.dataiku.dss.shadelibazure.io.netty.handler.codec.http.LastHttpContent;
import com.dataiku.dss.shadelibazure.io.netty.util.ReferenceCountUtil;
import com.dataiku.dss.shadelibazure.reactor.netty.http.server.compression.HttpCompressionOptionsSpec;
import com.dataiku.dss.shadelibazure.reactor.util.annotation.Nullable;
import java.util.ArrayList;
import java.util.List;

final class SimpleCompressionHandler
extends HttpContentCompressor {
    boolean decoded;
    HttpRequest request;

    private SimpleCompressionHandler() {
        super((CompressionOptions[])null);
    }

    private SimpleCompressionHandler(CompressionOptions ... options) {
        super(options);
    }

    static SimpleCompressionHandler create(@Nullable HttpCompressionOptionsSpec compressionOptions) {
        return compressionOptions == null ? new SimpleCompressionHandler() : new SimpleCompressionHandler(compressionOptions.adapt());
    }

    @Override
    protected void decode(ChannelHandlerContext ctx, HttpRequest msg, List<Object> out) throws Exception {
        this.decoded = true;
        super.decode(ctx, msg, out);
    }

    @Override
    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        if (msg instanceof ByteBuf) {
            super.write(ctx, new DefaultHttpContent((ByteBuf)msg), promise);
        } else {
            if (!this.decoded && msg instanceof HttpResponse) {
                this.decode(ctx, this.request);
            }
            if (this.decoded && this.request != null && msg instanceof LastHttpContent) {
                this.decoded = false;
                this.request = null;
            }
            super.write(ctx, msg, promise);
        }
    }

    void decode(ChannelHandlerContext ctx, HttpRequest msg) {
        ArrayList<Object> out = new ArrayList<Object>();
        HttpRequest request = msg;
        try {
            if (msg instanceof FullHttpRequest && ((FullHttpRequest)msg).content().refCnt() == 0) {
                request = new DefaultHttpRequest(msg.protocolVersion(), msg.method(), msg.uri(), msg.headers());
            }
            this.decode(ctx, request, (List<Object>)out);
        }
        catch (DecoderException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DecoderException(e);
        }
        finally {
            ReferenceCountUtil.release(request);
            out.clear();
        }
    }
}

