/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.reactor.netty.http.server;

import com.dataiku.dss.shadelibazure.io.netty.buffer.ByteBuf;
import com.dataiku.dss.shadelibazure.io.netty.channel.Channel;
import com.dataiku.dss.shadelibazure.io.netty.channel.ChannelFutureListener;
import com.dataiku.dss.shadelibazure.io.netty.channel.ChannelHandler;
import com.dataiku.dss.shadelibazure.io.netty.channel.ChannelHandlerContext;
import com.dataiku.dss.shadelibazure.io.netty.channel.ChannelPipeline;
import com.dataiku.dss.shadelibazure.io.netty.channel.ChannelPromise;
import com.dataiku.dss.shadelibazure.io.netty.handler.codec.compression.ZlibCodecFactory;
import com.dataiku.dss.shadelibazure.io.netty.handler.codec.http.DefaultFullHttpRequest;
import com.dataiku.dss.shadelibazure.io.netty.handler.codec.http.HttpHeaderNames;
import com.dataiku.dss.shadelibazure.io.netty.handler.codec.http.HttpHeaders;
import com.dataiku.dss.shadelibazure.io.netty.handler.codec.http.HttpRequest;
import com.dataiku.dss.shadelibazure.io.netty.handler.codec.http.HttpServerCodec;
import com.dataiku.dss.shadelibazure.io.netty.handler.codec.http.LastHttpContent;
import com.dataiku.dss.shadelibazure.io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import com.dataiku.dss.shadelibazure.io.netty.handler.codec.http.websocketx.PingWebSocketFrame;
import com.dataiku.dss.shadelibazure.io.netty.handler.codec.http.websocketx.PongWebSocketFrame;
import com.dataiku.dss.shadelibazure.io.netty.handler.codec.http.websocketx.WebSocketCloseStatus;
import com.dataiku.dss.shadelibazure.io.netty.handler.codec.http.websocketx.WebSocketServerHandshaker;
import com.dataiku.dss.shadelibazure.io.netty.handler.codec.http.websocketx.WebSocketServerHandshakerFactory;
import com.dataiku.dss.shadelibazure.io.netty.handler.codec.http.websocketx.extensions.WebSocketServerExtensionHandler;
import com.dataiku.dss.shadelibazure.io.netty.handler.codec.http.websocketx.extensions.compression.DeflateFrameServerExtensionHandshaker;
import com.dataiku.dss.shadelibazure.io.netty.handler.codec.http.websocketx.extensions.compression.PerMessageDeflateServerExtensionHandshaker;
import com.dataiku.dss.shadelibazure.io.netty.util.concurrent.Future;
import com.dataiku.dss.shadelibazure.io.netty.util.concurrent.GenericFutureListener;
import com.dataiku.dss.shadelibazure.org.reactivestreams.Publisher;
import com.dataiku.dss.shadelibazure.org.reactivestreams.Subscriber;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Flux;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Mono;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Sinks;
import com.dataiku.dss.shadelibazure.reactor.netty.FutureMono;
import com.dataiku.dss.shadelibazure.reactor.netty.NettyOutbound;
import com.dataiku.dss.shadelibazure.reactor.netty.ReactorNetty;
import com.dataiku.dss.shadelibazure.reactor.netty.http.server.AbstractHttpServerMetricsHandler;
import com.dataiku.dss.shadelibazure.reactor.netty.http.server.HttpServerMetricsRecorder;
import com.dataiku.dss.shadelibazure.reactor.netty.http.server.HttpServerOperations;
import com.dataiku.dss.shadelibazure.reactor.netty.http.server.MicrometerHttpServerMetricsRecorder;
import com.dataiku.dss.shadelibazure.reactor.netty.http.server.WebsocketServerSpec;
import com.dataiku.dss.shadelibazure.reactor.netty.http.websocket.WebsocketInbound;
import com.dataiku.dss.shadelibazure.reactor.netty.http.websocket.WebsocketOutbound;
import com.dataiku.dss.shadelibazure.reactor.util.annotation.Nullable;
import com.dataiku.dss.shadelibazure.reactor.util.context.Context;
import com.dataiku.dss.shadelibazure.reactor.util.context.ContextView;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;

class WebsocketServerOperations
extends HttpServerOperations
implements WebsocketInbound,
WebsocketOutbound {
    WebSocketServerHandshaker handshakerHttp11;
    ChannelPromise handshakerResult;
    final Sinks.One<WebSocketCloseStatus> onCloseState;
    final boolean proxyPing;
    volatile int closeSent;
    static final String INBOUND_CANCEL_LOG = "WebSocket server inbound receiver cancelled, closing Websocket.";
    static final AtomicIntegerFieldUpdater<WebsocketServerOperations> CLOSE_SENT = AtomicIntegerFieldUpdater.newUpdater(WebsocketServerOperations.class, "closeSent");

    WebsocketServerOperations(String wsUrl, WebsocketServerSpec websocketServerSpec, HttpServerOperations replaced) {
        super(replaced);
        this.proxyPing = websocketServerSpec.handlePing();
        this.onCloseState = Sinks.unsafe().one();
        this.initHandshaker(wsUrl, websocketServerSpec, replaced);
    }

    void initHandshaker(String wsUrl, WebsocketServerSpec websocketServerSpec, HttpServerOperations replaced) {
        Channel channel = replaced.channel();
        WebSocketServerHandshakerFactory wsFactory = new WebSocketServerHandshakerFactory(wsUrl, websocketServerSpec.protocols(), true, websocketServerSpec.maxFramePayloadLength());
        this.handshakerHttp11 = wsFactory.newHandshaker(replaced.nettyRequest);
        if (this.handshakerHttp11 == null) {
            WebSocketServerHandshakerFactory.sendUnsupportedVersionResponse(channel);
            this.handshakerResult = null;
        } else {
            this.removeHandler("com.dataiku.dss.shadelibazure.reactor.left.httpTrafficHandler");
            this.removeHandler("com.dataiku.dss.shadelibazure.reactor.left.accessLogHandler");
            ChannelHandler handler = channel.pipeline().get("com.dataiku.dss.shadelibazure.reactor.left.httpMetricsHandler");
            if (handler != null) {
                this.replaceHandler("com.dataiku.dss.shadelibazure.reactor.left.httpMetricsHandler", new WebsocketHttpServerMetricsHandler((AbstractHttpServerMetricsHandler)handler));
            }
            this.handshakerResult = channel.newPromise();
            DefaultFullHttpRequest request = new DefaultFullHttpRequest(replaced.version(), replaced.method(), replaced.uri());
            request.headers().set(replaced.nettyRequest.headers());
            if (websocketServerSpec.compress()) {
                this.removeHandler("com.dataiku.dss.shadelibazure.reactor.left.compressionHandler");
                PerMessageDeflateServerExtensionHandshaker perMessageDeflateServerExtensionHandshaker = new PerMessageDeflateServerExtensionHandshaker(6, ZlibCodecFactory.isSupportingWindowSizeAndMemLevel(), 15, websocketServerSpec.compressionAllowServerNoContext(), websocketServerSpec.compressionPreferredClientNoContext(), 0);
                WebSocketServerExtensionHandler wsServerExtensionHandler = new WebSocketServerExtensionHandler(perMessageDeflateServerExtensionHandshaker, new DeflateFrameServerExtensionHandshaker(6, 0));
                try {
                    ChannelPipeline pipeline = channel.pipeline();
                    wsServerExtensionHandler.channelRead(pipeline.context("com.dataiku.dss.shadelibazure.reactor.right.reactiveBridge"), request);
                    String baseName = null;
                    if (pipeline.get("com.dataiku.dss.shadelibazure.reactor.left.httpCodec") != null) {
                        baseName = "com.dataiku.dss.shadelibazure.reactor.left.httpCodec";
                    } else {
                        HttpServerCodec httpServerCodec = pipeline.get(HttpServerCodec.class);
                        if (httpServerCodec != null) {
                            baseName = pipeline.context(httpServerCodec).name();
                        }
                    }
                    pipeline.addAfter(baseName, "com.dataiku.dss.shadelibazure.reactor.left.wsCompressionHandler", wsServerExtensionHandler);
                }
                catch (Throwable e) {
                    log.error(ReactorNetty.format(this.channel(), ""), e);
                }
            }
            this.handshakerHttp11.handshake(channel, (HttpRequest)request, replaced.responseHeaders.remove(HttpHeaderNames.TRANSFER_ENCODING), this.handshakerResult).addListener((GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener<Future>)f -> {
                if (replaced.rebind(this)) {
                    this.markPersistent(false);
                    channel.read();
                } else if (log.isDebugEnabled()) {
                    log.debug(ReactorNetty.format(channel, "Cannot bind WebsocketServerOperations after the handshake."));
                }
            }));
        }
    }

    @Override
    public NettyOutbound send(Publisher<? extends ByteBuf> dataStream) {
        return this.sendObject(Flux.from(dataStream).map(bytebufToWebsocketFrame));
    }

    @Override
    public HttpHeaders headers() {
        return this.requestHeaders();
    }

    @Override
    public void onInboundNext(ChannelHandlerContext ctx, Object frame) {
        if (frame instanceof CloseWebSocketFrame && ((CloseWebSocketFrame)frame).isFinalFragment()) {
            CloseWebSocketFrame closeFrame;
            if (log.isDebugEnabled()) {
                log.debug(ReactorNetty.format(this.channel(), "CloseWebSocketFrame detected. Closing Websocket"));
            }
            if ((closeFrame = new CloseWebSocketFrame(true, ((CloseWebSocketFrame)frame).rsv(), ((CloseWebSocketFrame)frame).content())).statusCode() != -1) {
                this.sendCloseNow(closeFrame, f -> this.terminate());
            } else {
                this.sendCloseNow(closeFrame, WebSocketCloseStatus.EMPTY, f -> this.terminate());
            }
            return;
        }
        if (!this.proxyPing && frame instanceof PingWebSocketFrame) {
            ctx.writeAndFlush(new PongWebSocketFrame(((PingWebSocketFrame)frame).content()));
            ctx.read();
            return;
        }
        if (frame != LastHttpContent.EMPTY_LAST_CONTENT) {
            super.onInboundNext(ctx, frame);
        }
    }

    @Override
    protected void onOutboundComplete() {
    }

    @Override
    protected void onOutboundError(Throwable err) {
        if (this.channel().isActive()) {
            if (log.isDebugEnabled()) {
                log.debug(ReactorNetty.format(this.channel(), "Outbound error happened"), err);
            }
            this.sendCloseNow(new CloseWebSocketFrame(WebSocketCloseStatus.PROTOCOL_ERROR), f -> this.terminate());
        }
    }

    @Override
    protected void onInboundCancel() {
        if (log.isDebugEnabled()) {
            log.debug(ReactorNetty.format(this.channel(), INBOUND_CANCEL_LOG));
        }
        this.sendCloseNow(new CloseWebSocketFrame(), WebSocketCloseStatus.ABNORMAL_CLOSURE, f -> this.terminate());
    }

    @Override
    public Mono<Void> sendClose() {
        return this.sendClose(new CloseWebSocketFrame());
    }

    @Override
    public Mono<Void> sendClose(int rsv) {
        return this.sendClose(new CloseWebSocketFrame(true, rsv));
    }

    @Override
    public Mono<Void> sendClose(int statusCode, @Nullable String reasonText) {
        return this.sendClose(new CloseWebSocketFrame(statusCode, reasonText));
    }

    @Override
    public Mono<Void> sendClose(int rsv, int statusCode, @Nullable String reasonText) {
        return this.sendClose(new CloseWebSocketFrame(true, rsv, statusCode, reasonText));
    }

    @Override
    public Mono<WebSocketCloseStatus> receiveCloseStatus() {
        return this.onCloseState.asMono().or(this.onTerminate());
    }

    Mono<Void> sendClose(CloseWebSocketFrame frame) {
        if (CLOSE_SENT.get(this) == 0) {
            return FutureMono.deferFuture(() -> {
                if (CLOSE_SENT.getAndSet(this, 1) == 0) {
                    this.discard();
                    this.onCloseState.tryEmitValue(new WebSocketCloseStatus(frame.statusCode(), frame.reasonText()));
                    return this.channel().writeAndFlush(frame).addListener(ChannelFutureListener.CLOSE);
                }
                frame.release();
                return this.channel().newSucceededFuture();
            }).doOnCancel(() -> ReactorNetty.safeRelease(frame));
        }
        frame.release();
        return Mono.empty();
    }

    void sendCloseNow(CloseWebSocketFrame frame, ChannelFutureListener listener) {
        this.sendCloseNow(frame, new WebSocketCloseStatus(frame.statusCode(), frame.reasonText()), listener);
    }

    void sendCloseNow(CloseWebSocketFrame frame, WebSocketCloseStatus closeStatus, ChannelFutureListener listener) {
        if (!frame.isFinalFragment()) {
            this.channel().writeAndFlush(frame);
            return;
        }
        if (CLOSE_SENT.getAndSet(this, 1) == 0) {
            this.onCloseState.tryEmitValue(closeStatus);
            this.channel().writeAndFlush(frame).addListener(listener);
        } else {
            frame.release();
        }
    }

    @Override
    public boolean isWebsocket() {
        return true;
    }

    @Override
    @Nullable
    public String selectedSubprotocol() {
        return this.handshakerHttp11.selectedSubprotocol();
    }

    Subscriber<Void> websocketSubscriber(ContextView contextView) {
        return new HttpServerOperations.WebsocketSubscriber(this, Context.of(contextView));
    }

    static final class WebsocketHttpServerMetricsHandler
    extends AbstractHttpServerMetricsHandler {
        final HttpServerMetricsRecorder recorder;

        WebsocketHttpServerMetricsHandler(AbstractHttpServerMetricsHandler copy) {
            super(copy);
            this.recorder = copy.recorder();
        }

        @Override
        public void channelActive(ChannelHandlerContext ctx) {
            ctx.fireChannelActive();
        }

        @Override
        public void channelInactive(ChannelHandlerContext ctx) {
            try {
                if (this.channelOpened && this.recorder instanceof MicrometerHttpServerMetricsRecorder) {
                    this.channelOpened = false;
                    this.recorder.recordServerConnectionClosed(ctx.channel().localAddress());
                }
                if (this.channelActivated) {
                    this.channelActivated = false;
                    this.recorder.recordServerConnectionInactive(ctx.channel().localAddress());
                }
            }
            catch (RuntimeException e) {
                if (HttpServerOperations.log.isWarnEnabled()) {
                    HttpServerOperations.log.warn(ReactorNetty.format(ctx.channel(), "Exception caught while recording metrics."), e);
                }
            }
            finally {
                ctx.fireChannelInactive();
            }
        }

        @Override
        public void channelRead(ChannelHandlerContext ctx, Object msg) {
            ctx.fireChannelRead(msg);
        }

        @Override
        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
            ctx.fireExceptionCaught(cause);
        }

        @Override
        public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) {
            ctx.write(msg, promise);
        }

        @Override
        public HttpServerMetricsRecorder recorder() {
            return this.recorder;
        }
    }
}

