/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.reactor.netty.http.server.compression;

import com.dataiku.dss.shadelibazure.io.netty.handler.codec.compression.Brotli;
import com.dataiku.dss.shadelibazure.io.netty.handler.codec.compression.CompressionOptions;
import com.dataiku.dss.shadelibazure.io.netty.handler.codec.compression.Zstd;
import com.dataiku.dss.shadelibazure.reactor.netty.http.server.compression.BrotliOption;
import com.dataiku.dss.shadelibazure.reactor.netty.http.server.compression.DeflateOption;
import com.dataiku.dss.shadelibazure.reactor.netty.http.server.compression.GzipOption;
import com.dataiku.dss.shadelibazure.reactor.netty.http.server.compression.HttpCompressionOption;
import com.dataiku.dss.shadelibazure.reactor.netty.http.server.compression.SnappyOption;
import com.dataiku.dss.shadelibazure.reactor.netty.http.server.compression.ZstdOption;
import java.util.ArrayList;
import java.util.Arrays;

public final class HttpCompressionOptionsSpec {
    private BrotliOption brotli;
    private DeflateOption deflate;
    private GzipOption gzip = GzipOption.provideDefault();
    private SnappyOption snappy;
    private ZstdOption zstd;

    private HttpCompressionOptionsSpec() {
        this.deflate = DeflateOption.provideDefault();
        this.snappy = new SnappyOption();
        if (Brotli.isAvailable()) {
            this.brotli = new BrotliOption();
        }
        if (Zstd.isAvailable()) {
            this.zstd = ZstdOption.provideDefault();
        }
    }

    public HttpCompressionOptionsSpec(HttpCompressionOption ... compressionOptions) {
        this();
        Arrays.stream(compressionOptions).forEach(this::initializeOption);
    }

    private void initializeOption(HttpCompressionOption option) {
        if (option instanceof GzipOption) {
            this.gzip = (GzipOption)option;
        } else if (option instanceof DeflateOption) {
            this.deflate = (DeflateOption)option;
        } else if (option instanceof SnappyOption) {
            this.snappy = (SnappyOption)option;
        } else if (Brotli.isAvailable() && option instanceof BrotliOption) {
            this.brotli = (BrotliOption)option;
        } else if (Zstd.isAvailable() && option instanceof ZstdOption) {
            this.zstd = (ZstdOption)option;
        }
    }

    public CompressionOptions[] adapt() {
        ArrayList<CompressionOptions> options = new ArrayList<CompressionOptions>(Arrays.asList(this.gzip.adapt(), this.deflate.adapt(), this.snappy.adapt()));
        if (this.brotli != null) {
            options.add(this.brotli.adapt());
        }
        if (this.zstd != null) {
            options.add(this.zstd.adapt());
        }
        return options.toArray(new CompressionOptions[0]);
    }
}

