/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.reactor.netty.http.server.logging;

import com.dataiku.dss.shadelibazure.io.netty.channel.ChannelHandlerContext;
import com.dataiku.dss.shadelibazure.io.netty.channel.ChannelPromise;
import com.dataiku.dss.shadelibazure.io.netty.handler.codec.http.HttpResponseStatus;
import com.dataiku.dss.shadelibazure.io.netty.incubator.codec.http3.Http3DataFrame;
import com.dataiku.dss.shadelibazure.io.netty.incubator.codec.http3.Http3HeadersFrame;
import com.dataiku.dss.shadelibazure.io.netty.incubator.codec.quic.QuicChannel;
import com.dataiku.dss.shadelibazure.io.netty.util.concurrent.Future;
import com.dataiku.dss.shadelibazure.io.netty.util.concurrent.GenericFutureListener;
import com.dataiku.dss.shadelibazure.reactor.netty.channel.ChannelOperations;
import com.dataiku.dss.shadelibazure.reactor.netty.http.server.HttpServerInfos;
import com.dataiku.dss.shadelibazure.reactor.netty.http.server.logging.AccessLog;
import com.dataiku.dss.shadelibazure.reactor.netty.http.server.logging.AccessLogArgProvider;
import com.dataiku.dss.shadelibazure.reactor.netty.http.server.logging.AccessLogArgProviderH3;
import com.dataiku.dss.shadelibazure.reactor.netty.http.server.logging.BaseAccessLogHandler;
import com.dataiku.dss.shadelibazure.reactor.util.annotation.Nullable;
import java.util.function.Function;

final class AccessLogHandlerH3
extends BaseAccessLogHandler {
    AccessLogArgProviderH3 accessLogArgProvider;

    AccessLogHandlerH3(@Nullable Function<AccessLogArgProvider, AccessLog> accessLog) {
        super(accessLog);
    }

    @Override
    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        if (msg instanceof Http3HeadersFrame) {
            Http3HeadersFrame requestHeaders = (Http3HeadersFrame)msg;
            if (this.accessLogArgProvider == null) {
                this.accessLogArgProvider = new AccessLogArgProviderH3(ctx.channel().parent() instanceof QuicChannel ? ((QuicChannel)ctx.channel().parent()).remoteSocketAddress() : null);
            }
            this.accessLogArgProvider.requestHeaders(requestHeaders);
            ctx.channel().closeFuture().addListener((GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener<Future>)f -> {
                AccessLog log = (AccessLog)this.accessLog.apply(this.accessLogArgProvider);
                if (log != null) {
                    log.log();
                }
                this.accessLogArgProvider.clear();
            }));
        }
        ctx.fireChannelRead(msg);
    }

    @Override
    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) {
        if (msg instanceof Http3HeadersFrame) {
            Http3HeadersFrame responseHeaders = (Http3HeadersFrame)msg;
            if (HttpResponseStatus.CONTINUE.codeAsText().contentEquals(responseHeaders.headers().status())) {
                ctx.write(msg, promise);
                return;
            }
            this.accessLogArgProvider.responseHeaders(responseHeaders).chunked(true);
            ChannelOperations<?, ?> ops = ChannelOperations.get(ctx.channel());
            if (ops instanceof HttpServerInfos) {
                AccessLogHandlerH3.applyServerInfos(this.accessLogArgProvider, (HttpServerInfos)((Object)ops));
            }
        }
        if (msg instanceof Http3DataFrame) {
            Http3DataFrame data = (Http3DataFrame)msg;
            this.accessLogArgProvider.increaseContentLength(data.content().readableBytes());
        }
        ctx.write(msg, promise);
    }
}

