/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.reactor.netty.http.server.logging.error;

import com.dataiku.dss.shadelibazure.io.netty.channel.ChannelHandlerContext;
import com.dataiku.dss.shadelibazure.reactor.netty.channel.ChannelOperations;
import com.dataiku.dss.shadelibazure.reactor.netty.http.server.HttpServerInfos;
import com.dataiku.dss.shadelibazure.reactor.netty.http.server.logging.error.BaseErrorLogHandler;
import com.dataiku.dss.shadelibazure.reactor.netty.http.server.logging.error.DefaultErrorLogArgProvider;
import com.dataiku.dss.shadelibazure.reactor.netty.http.server.logging.error.DefaultErrorLogEvent;
import com.dataiku.dss.shadelibazure.reactor.netty.http.server.logging.error.ErrorLog;
import com.dataiku.dss.shadelibazure.reactor.netty.http.server.logging.error.ErrorLogArgProvider;
import com.dataiku.dss.shadelibazure.reactor.util.annotation.Nullable;
import java.net.SocketAddress;
import java.util.function.Function;

public final class DefaultErrorLogHandler
extends BaseErrorLogHandler {
    private DefaultErrorLogArgProvider errorLogArgProvider;

    public DefaultErrorLogHandler(@Nullable Function<ErrorLogArgProvider, ErrorLog> errorLog) {
        super(errorLog);
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        if (this.errorLogArgProvider == null) {
            ChannelOperations<?, ?> ops = ChannelOperations.get(ctx.channel());
            SocketAddress remoteAddress = ops instanceof HttpServerInfos ? ((HttpServerInfos)((Object)ops)).connectionRemoteAddress() : ctx.channel().remoteAddress();
            this.errorLogArgProvider = new DefaultErrorLogArgProvider(remoteAddress);
        } else {
            this.errorLogArgProvider.clear();
        }
        this.errorLogArgProvider.applyConnectionInfo(ctx.channel());
        this.errorLogArgProvider.applyThrowable(cause);
        ErrorLog log = (ErrorLog)this.errorLog.apply(this.errorLogArgProvider);
        if (log != null) {
            log.log();
        }
        ctx.fireExceptionCaught(cause);
    }

    @Override
    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) {
        if (evt instanceof DefaultErrorLogEvent) {
            this.exceptionCaught(ctx, ((DefaultErrorLogEvent)evt).cause());
        }
        ctx.fireUserEventTriggered(evt);
    }
}

