/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.reactor.netty.resources;

import com.dataiku.dss.shadelibazure.io.netty.channel.Channel;
import com.dataiku.dss.shadelibazure.io.netty.channel.ChannelInitializer;
import com.dataiku.dss.shadelibazure.io.netty.channel.EventLoop;
import com.dataiku.dss.shadelibazure.io.netty.resolver.AddressResolverGroup;
import com.dataiku.dss.shadelibazure.io.netty.util.AttributeKey;
import com.dataiku.dss.shadelibazure.io.netty.util.concurrent.Future;
import com.dataiku.dss.shadelibazure.io.netty.util.concurrent.GenericFutureListener;
import com.dataiku.dss.shadelibazure.org.reactivestreams.Publisher;
import com.dataiku.dss.shadelibazure.org.reactivestreams.Subscription;
import com.dataiku.dss.shadelibazure.reactor.core.CoreSubscriber;
import com.dataiku.dss.shadelibazure.reactor.core.Disposable;
import com.dataiku.dss.shadelibazure.reactor.core.Disposables;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Mono;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.MonoSink;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Operators;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Sinks;
import com.dataiku.dss.shadelibazure.reactor.netty.Connection;
import com.dataiku.dss.shadelibazure.reactor.netty.ConnectionObserver;
import com.dataiku.dss.shadelibazure.reactor.netty.FutureMono;
import com.dataiku.dss.shadelibazure.reactor.netty.ReactorNetty;
import com.dataiku.dss.shadelibazure.reactor.netty.channel.ChannelOperations;
import com.dataiku.dss.shadelibazure.reactor.netty.internal.shaded.reactor.pool.InstrumentedPool;
import com.dataiku.dss.shadelibazure.reactor.netty.internal.shaded.reactor.pool.PooledRef;
import com.dataiku.dss.shadelibazure.reactor.netty.internal.shaded.reactor.pool.PooledRefMetadata;
import com.dataiku.dss.shadelibazure.reactor.netty.resources.ConnectionProvider;
import com.dataiku.dss.shadelibazure.reactor.netty.resources.MicrometerPoolMetricsRecorder;
import com.dataiku.dss.shadelibazure.reactor.netty.resources.PooledConnectionProvider;
import com.dataiku.dss.shadelibazure.reactor.netty.transport.DomainSocketAddressUtils;
import com.dataiku.dss.shadelibazure.reactor.netty.transport.TransportConfig;
import com.dataiku.dss.shadelibazure.reactor.netty.transport.TransportConnector;
import com.dataiku.dss.shadelibazure.reactor.util.Logger;
import com.dataiku.dss.shadelibazure.reactor.util.Loggers;
import com.dataiku.dss.shadelibazure.reactor.util.annotation.Nullable;
import com.dataiku.dss.shadelibazure.reactor.util.concurrent.Queues;
import com.dataiku.dss.shadelibazure.reactor.util.context.Context;
import java.io.IOException;
import java.net.SocketAddress;
import java.time.Clock;
import java.time.Duration;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BiPredicate;
import java.util.function.Function;

final class DefaultPooledConnectionProvider
extends PooledConnectionProvider<PooledConnection> {
    static final Logger log = Loggers.getLogger(DefaultPooledConnectionProvider.class);
    static final AttributeKey<ConnectionObserver> OWNER = AttributeKey.valueOf("connectionOwner");

    DefaultPooledConnectionProvider(ConnectionProvider.Builder builder) {
        this(builder, null);
    }

    DefaultPooledConnectionProvider(ConnectionProvider.Builder builder, @Nullable Clock clock) {
        super(builder, clock);
    }

    @Override
    protected CoreSubscriber<PooledRef<PooledConnection>> createDisposableAcquire(TransportConfig config, ConnectionObserver connectionObserver, long pendingAcquireTimeout, InstrumentedPool<PooledConnection> pool, MonoSink<Connection> sink2, Context currentContext) {
        return new DisposableAcquire(connectionObserver, config.channelOperationsProvider(), pendingAcquireTimeout, pool, sink2, currentContext);
    }

    @Override
    protected InstrumentedPool<PooledConnection> createPool(TransportConfig config, PooledConnectionProvider.PoolFactory<PooledConnection> poolFactory, SocketAddress remoteAddress, @Nullable AddressResolverGroup<?> resolverGroup) {
        return new PooledConnectionAllocator((TransportConfig)config, poolFactory, (SocketAddress)remoteAddress, resolverGroup).pool;
    }

    @Override
    protected InstrumentedPool<PooledConnection> createPool(String id, TransportConfig config, PooledConnectionProvider.PoolFactory<PooledConnection> poolFactory, SocketAddress remoteAddress, @Nullable AddressResolverGroup<?> resolverGroup) {
        return new PooledConnectionAllocator((String)id, (String)this.name, (TransportConfig)config, poolFactory, (SocketAddress)remoteAddress, resolverGroup).pool;
    }

    static final class PooledConnectionAllocator {
        final TransportConfig config;
        final InstrumentedPool<PooledConnection> pool;
        final SocketAddress remoteAddress;
        final AddressResolverGroup<?> resolver;
        static final BiPredicate<PooledConnection, PooledRefMetadata> DEFAULT_EVICTION_PREDICATE = (pooledConnection, metadata) -> !pooledConnection.channel.isActive() || !pooledConnection.isPersistent();
        static final Function<PooledConnection, Publisher<Void>> DEFAULT_DESTROY_HANDLER = pooledConnection -> {
            if (!pooledConnection.channel.isActive()) {
                return Mono.empty();
            }
            return FutureMono.from(pooledConnection.channel.close());
        };

        PooledConnectionAllocator(TransportConfig config, PooledConnectionProvider.PoolFactory<PooledConnection> provider, SocketAddress remoteAddress, @Nullable AddressResolverGroup<?> resolver) {
            this(null, null, config, provider, remoteAddress, resolver);
        }

        PooledConnectionAllocator(@Nullable String id, @Nullable String name, TransportConfig config, PooledConnectionProvider.PoolFactory<PooledConnection> provider, SocketAddress remoteAddress, @Nullable AddressResolverGroup<?> resolver) {
            this.config = config;
            this.remoteAddress = remoteAddress;
            this.resolver = resolver;
            this.pool = id == null ? provider.newPool(this.connectChannel(), null, DEFAULT_DESTROY_HANDLER, DEFAULT_EVICTION_PREDICATE) : provider.newPool(this.connectChannel(), DEFAULT_DESTROY_HANDLER, DEFAULT_EVICTION_PREDICATE, new MicrometerPoolMetricsRecorder(id, name, remoteAddress));
        }

        Publisher<PooledConnection> connectChannel() {
            return Mono.create(sink2 -> {
                EventLoop callerEventLoop;
                PooledConnectionInitializer initializer = new PooledConnectionInitializer((MonoSink<PooledConnection>)sink2);
                EventLoop eventLoop = callerEventLoop = sink2.contextView().hasKey("callereventloop") ? (EventLoop)sink2.contextView().get("callereventloop") : null;
                if (this.resolver != null) {
                    if (callerEventLoop != null) {
                        TransportConnector.connect(this.config, this.remoteAddress, this.resolver, initializer, callerEventLoop, sink2.contextView()).subscribe(initializer);
                    } else {
                        TransportConnector.connect(this.config, this.remoteAddress, this.resolver, (ChannelInitializer<Channel>)initializer, sink2.contextView()).subscribe(initializer);
                    }
                } else {
                    Objects.requireNonNull(this.config.bindAddress(), "bindAddress");
                    SocketAddress local = Objects.requireNonNull(this.config.bindAddress().get(), "Bind Address supplier returned null");
                    TransportConnector.bind(this.config, initializer, local, DomainSocketAddressUtils.isDomainSocketAddress(this.remoteAddress)).subscribe(initializer);
                }
            });
        }

        final class PooledConnectionInitializer
        extends ChannelInitializer<Channel>
        implements CoreSubscriber<Channel> {
            final MonoSink<PooledConnection> sink;
            PooledConnection pooledConnection;

            PooledConnectionInitializer(MonoSink<PooledConnection> sink2) {
                this.sink = sink2;
            }

            @Override
            protected void initChannel(Channel ch) {
                PooledConnection pooledConnection;
                if (log.isDebugEnabled()) {
                    PooledConnectionProvider.logPoolState(ch, PooledConnectionAllocator.this.pool, "Created a new pooled channel");
                }
                this.pooledConnection = pooledConnection = new PooledConnection(ch, PooledConnectionAllocator.this.pool);
                ch.attr(OWNER).compareAndSet(null, new PendingConnectionObserver(Context.of(this.sink.contextView())));
                ch.pipeline().remove(this);
                ch.pipeline().addFirst(PooledConnectionAllocator.this.config.channelInitializer(pooledConnection, PooledConnectionAllocator.this.remoteAddress, false));
                pooledConnection.bind();
            }

            @Override
            public void onComplete() {
            }

            @Override
            public void onError(Throwable t) {
                this.sink.error(t);
            }

            @Override
            public void onNext(Channel channel) {
                this.sink.success(this.pooledConnection);
            }

            @Override
            public void onSubscribe(Subscription s2) {
                s2.request(Long.MAX_VALUE);
            }
        }
    }

    static final class PooledConnection
    extends AtomicLong
    implements Connection,
    ConnectionObserver {
        final Channel channel;
        final Sinks.Empty<Void> onTerminate;
        final InstrumentedPool<PooledConnection> pool;
        PooledRef<PooledConnection> pooledRef;

        PooledConnection(Channel channel, InstrumentedPool<PooledConnection> pool) {
            this.channel = channel;
            this.onTerminate = Sinks.unsafe().empty();
            this.pool = pool;
        }

        @Override
        public Channel channel() {
            return this.channel;
        }

        @Override
        public Context currentContext() {
            return this.owner().currentContext();
        }

        @Override
        public void onStateChange(Connection connection, ConnectionObserver.State newState) {
            if (log.isDebugEnabled()) {
                log.debug(ReactorNetty.format(connection.channel(), "onStateChange({}, {})"), connection, newState);
            }
            if (newState == ConnectionObserver.State.DISCONNECTING) {
                if (!this.isPersistent() && this.channel.isActive()) {
                    this.channel.close();
                    this.owner().onStateChange(connection, ConnectionObserver.State.DISCONNECTING);
                    return;
                }
                if (!this.channel.isActive()) {
                    this.owner().onStateChange(connection, ConnectionObserver.State.DISCONNECTING);
                    return;
                }
                if (log.isDebugEnabled()) {
                    log.debug(ReactorNetty.format(connection.channel(), "Releasing channel"));
                }
                ConnectionObserver obs = this.channel.attr(OWNER).getAndSet(ConnectionObserver.emptyListener());
                if (ReactorNetty.getChannelContext(this.channel) != null) {
                    ReactorNetty.setChannelContext(this.channel, null);
                }
                if (this.pooledRef == null) {
                    return;
                }
                this.pooledRef.release().subscribe(null, t -> {
                    if (log.isDebugEnabled()) {
                        PooledConnectionProvider.logPoolState(this.pooledRef.poolable().channel, this.pool, "Failed cleaning the channel from pool", t);
                    }
                    this.onTerminate.tryEmitEmpty();
                    obs.onStateChange(connection, ConnectionObserver.State.RELEASED);
                }, () -> {
                    if (log.isDebugEnabled()) {
                        PooledConnectionProvider.logPoolState(this.pooledRef.poolable().channel, this.pool, "Channel cleaned");
                    }
                    this.onTerminate.tryEmitEmpty();
                    obs.onStateChange(connection, ConnectionObserver.State.RELEASED);
                });
                return;
            }
            this.owner().onStateChange(connection, newState);
        }

        @Override
        public Mono<Void> onTerminate() {
            return this.onTerminate.asMono().or(this.onDispose());
        }

        @Override
        public void onUncaughtException(Connection connection, Throwable error) {
            this.owner().onUncaughtException(connection, error);
        }

        @Override
        public String toString() {
            return "PooledConnection{channel=" + this.channel + '}';
        }

        ConnectionObserver owner() {
            ConnectionObserver obs;
            do {
                if ((obs = this.channel.attr(OWNER).get()) != null) {
                    return obs;
                }
                obs = new PendingConnectionObserver();
            } while (!this.channel.attr(OWNER).compareAndSet(null, obs));
            return obs;
        }
    }

    static final class PendingConnectionObserver
    implements ConnectionObserver {
        final Queue<Pending> pendingQueue = Queues.unbounded(4).get();
        final Context context;

        public PendingConnectionObserver() {
            this(Context.empty());
        }

        public PendingConnectionObserver(Context context) {
            this.context = context;
        }

        @Override
        public void onStateChange(Connection connection, ConnectionObserver.State newState) {
            this.pendingQueue.add(new Pending(connection, null, newState));
        }

        @Override
        public void onUncaughtException(Connection connection, Throwable error) {
            this.pendingQueue.add(new Pending(connection, error, null));
        }

        @Override
        public Context currentContext() {
            return this.context;
        }

        static class Pending {
            final Connection connection;
            final Throwable error;
            final ConnectionObserver.State state;

            Pending(Connection connection, @Nullable Throwable error, @Nullable ConnectionObserver.State state) {
                this.connection = connection;
                this.error = error;
                this.state = state;
            }
        }
    }

    static final class DisposableAcquire
    implements ConnectionObserver,
    Runnable,
    CoreSubscriber<PooledRef<PooledConnection>>,
    Disposable {
        final Disposable.Composite cancellations;
        final Context currentContext;
        final ConnectionObserver obs;
        final ChannelOperations.OnSetup opsFactory;
        final long pendingAcquireTimeout;
        final InstrumentedPool<PooledConnection> pool;
        final boolean retried;
        final MonoSink<Connection> sink;
        PooledRef<PooledConnection> pooledRef;
        Subscription subscription;

        DisposableAcquire(ConnectionObserver obs, ChannelOperations.OnSetup opsFactory, long pendingAcquireTimeout, InstrumentedPool<PooledConnection> pool, MonoSink<Connection> sink2, Context currentContext) {
            this.cancellations = Disposables.composite();
            this.currentContext = currentContext;
            this.obs = obs;
            this.opsFactory = opsFactory;
            this.pendingAcquireTimeout = pendingAcquireTimeout;
            this.pool = pool;
            this.retried = false;
            this.sink = sink2;
        }

        DisposableAcquire(DisposableAcquire parent) {
            this.cancellations = parent.cancellations;
            this.currentContext = parent.currentContext;
            this.obs = parent.obs;
            this.opsFactory = parent.opsFactory;
            this.pendingAcquireTimeout = parent.pendingAcquireTimeout;
            this.pool = parent.pool;
            this.retried = true;
            this.sink = parent.sink;
        }

        @Override
        public Context currentContext() {
            return this.currentContext;
        }

        @Override
        public void dispose() {
            this.subscription.cancel();
        }

        @Override
        public void onComplete() {
        }

        @Override
        public void onError(Throwable throwable) {
            this.sink.error(throwable);
        }

        @Override
        public void onNext(PooledRef<PooledConnection> value) {
            this.pooledRef = value;
            PooledConnection pooledConnection = value.poolable();
            pooledConnection.pooledRef = this.pooledRef;
            Channel c = pooledConnection.channel;
            if (!this.currentContext.isEmpty()) {
                ReactorNetty.setChannelContext(c, this.currentContext);
            }
            if (c.eventLoop().inEventLoop()) {
                this.run();
            } else {
                c.eventLoop().execute(this);
            }
        }

        @Override
        public void onStateChange(Connection connection, ConnectionObserver.State newState) {
            if (newState == ConnectionObserver.State.CONFIGURED) {
                this.sink.success(connection);
            }
            this.obs.onStateChange(connection, newState);
        }

        @Override
        public void onSubscribe(Subscription s2) {
            if (Operators.validate(this.subscription, s2)) {
                this.subscription = s2;
                this.cancellations.add(this);
                if (!this.retried) {
                    this.sink.onCancel(this.cancellations);
                }
                s2.request(Long.MAX_VALUE);
            }
        }

        @Override
        public void onUncaughtException(Connection connection, Throwable error) {
            this.sink.error(error);
            this.obs.onUncaughtException(connection, error);
        }

        @Override
        public void run() {
            PooledConnection pooledConnection = this.pooledRef.poolable();
            Channel c = pooledConnection.channel;
            if (!c.isActive()) {
                this.pooledRef.invalidate().subscribe(null, null, () -> {
                    if (log.isDebugEnabled()) {
                        PooledConnectionProvider.logPoolState(c, this.pool, "Channel closed");
                    }
                });
                if (!this.retried) {
                    if (log.isDebugEnabled()) {
                        log.debug(ReactorNetty.format(c, "Immediately aborted pooled channel, re-acquiring new channel"));
                    }
                    this.pool.acquire(Duration.ofMillis(this.pendingAcquireTimeout)).contextWrite(ctx -> ctx.put("callereventloop", c.eventLoop())).subscribe(new DisposableAcquire(this));
                } else {
                    this.sink.error(new IOException("Error while acquiring from " + this.pool));
                }
                return;
            }
            ConnectionObserver current = c.attr(OWNER).getAndSet(this);
            if (current instanceof PendingConnectionObserver) {
                PendingConnectionObserver.Pending p;
                PendingConnectionObserver pending = (PendingConnectionObserver)current;
                current = null;
                DisposableAcquire.registerClose(this.pooledRef, this.pool);
                while ((p = pending.pendingQueue.poll()) != null) {
                    if (p.error != null) {
                        this.onUncaughtException(p.connection, p.error);
                        continue;
                    }
                    if (p.state == null) continue;
                    this.onStateChange(p.connection, p.state);
                }
            } else if (current == null) {
                DisposableAcquire.registerClose(this.pooledRef, this.pool);
            }
            if (current != null) {
                if (log.isDebugEnabled()) {
                    PooledConnectionProvider.logPoolState(c, this.pool, "Channel acquired");
                }
                this.obs.onStateChange(pooledConnection, ConnectionObserver.State.ACQUIRED);
                ChannelOperations<?, ?> ops = this.opsFactory.create(pooledConnection, pooledConnection, null);
                if (ops != null) {
                    if (c.pipeline().get("com.dataiku.dss.shadelibazure.reactor.left.h2MultiplexHandler") == null) {
                        ops.bind();
                        this.sink.success(ops);
                        this.obs.onStateChange(ops, ConnectionObserver.State.CONFIGURED);
                    } else {
                        this.sink.success(ops);
                        this.obs.onStateChange(pooledConnection, ConnectionObserver.State.CONFIGURED);
                    }
                } else {
                    this.sink.success(pooledConnection);
                }
                return;
            }
            if (log.isDebugEnabled()) {
                PooledConnectionProvider.logPoolState(c, this.pool, "Channel connected");
            }
            if (this.opsFactory == ChannelOperations.OnSetup.empty()) {
                this.sink.success(Connection.from(c));
            }
        }

        static void registerClose(PooledRef<PooledConnection> pooledRef, InstrumentedPool<PooledConnection> pool) {
            Channel channel = pooledRef.poolable().channel;
            if (log.isDebugEnabled()) {
                log.debug(ReactorNetty.format(channel, "Registering pool release on close event for channel"));
            }
            channel.closeFuture().addListener((GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener<Future>)ff -> {
                ConnectionObserver owner = channel.attr(OWNER).get();
                if (owner instanceof DisposableAcquire) {
                    ((DisposableAcquire)owner).pooledRef.invalidate().subscribe(null, null, () -> {
                        if (log.isDebugEnabled()) {
                            PooledConnectionProvider.logPoolState(channel, pool, "Channel closed");
                        }
                    });
                }
            }));
        }
    }
}

